/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableArrayTextComponentList;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWidget;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.inventory.container.MinionContainer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.gui.widget.button.LockIconButton;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class MinionScreen
extends ContainerScreen<MinionContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("vampirism", "textures/gui/minion_inventory.png");
    private final int extraSlots;
    private ScrollableListWidget taskList;
    private Button taskButton;
    private Button appearanceButton;
    private Button statButton;
    private LockIconButton lockActionButton;

    public MinionScreen(MinionContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)Objects.requireNonNull(screenContainer), inv, titleIn);
        this.field_146999_f = 214;
        this.field_147000_g = 185;
        this.extraSlots = screenContainer.getExtraSlots();
    }

    public boolean func_231045_a_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        this.taskList.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        return super.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(mStack, mouseX, mouseY);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.appearanceButton = (Button)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 6, this.field_147009_r + 21, 18, 18, 238, 0, 18, GUI_TEXTURE, this::onConfigurePressed));
        this.lockActionButton = (LockIconButton)this.func_230480_a_((Widget)new LockIconButton(this.field_147003_i + 99, this.field_147009_r + 19, this::toggleActionLock));
        this.statButton = (Button)this.func_230480_a_((Widget)new ImageButton(this.field_147003_i + 6, this.field_147009_r + 40, 18, 18, 220, 0, 18, GUI_TEXTURE, this::onStatsPressed));
        this.lockActionButton.func_175229_b(((MinionContainer)this.field_147002_h).isTaskLocked());
        ITextComponent[] taskNames = (ITextComponent[])Arrays.stream(((MinionContainer)this.field_147002_h).getAvailableTasks()).map(IMinionTask::getName).toArray(ITextComponent[]::new);
        this.taskList = (ScrollableListWidget)this.func_230480_a_((Widget)new ScrollableArrayTextComponentList(this.field_147003_i + 120, this.field_147009_r + 19 + 19, 86, Math.min(60, taskNames.length * 20), 20, () -> taskNames, this::selectTask).scrollSpeed(2.0));
        this.taskList.field_230694_p_ = false;
        this.taskButton = (Button)this.func_230480_a_((Widget)new ExtendedButton(this.field_147003_i + 119, this.field_147009_r + 19, 88, 20, this.getActiveTaskName(), button -> {
            this.taskList.field_230694_p_ = !this.taskList.field_230694_p_;
        }));
    }

    protected void func_230450_a_(MatrixStack mStack, float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_238474_b_(mStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int k = this.extraSlots; k < 15; ++k) {
            this.func_238474_b_(mStack, i + 29 + 18 * (k / 3), j + 44 + 18 * (k % 3), 236, 80, 13, 13);
        }
    }

    protected void func_230451_b_(MatrixStack mStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(mStack, this.field_230704_d_, 5.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_243248_b(mStack, (ITextComponent)new TranslationTextComponent("gui.vampirism.minion.active_task"), 120.0f, 10.0f, 0x404040);
    }

    protected void func_230459_a_(MatrixStack mStack, int mouseX, int mouseY) {
        if (this.lockActionButton.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.drawButtonTip(mStack, (ITextComponent)new TranslationTextComponent("gui.vampirism.minion.lock_action"), mouseX, mouseY);
        } else if (this.appearanceButton.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.drawButtonTip(mStack, (ITextComponent)new TranslationTextComponent("gui.vampirism.minion.appearance"), mouseX, mouseY);
        } else if (this.statButton.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.drawButtonTip(mStack, (ITextComponent)new TranslationTextComponent("gui.vampirism.minion_stats"), mouseX, mouseY);
        } else {
            super.func_230459_a_(mStack, mouseX, mouseY);
        }
    }

    private void drawButtonTip(MatrixStack mStack, ITextComponent text, int mouseX, int mouseY) {
        GuiUtils.drawHoveringText((ItemStack)ItemStack.field_190927_a, (MatrixStack)mStack, Collections.singletonList(text), (int)mouseX, (int)mouseY, (int)this.field_230706_i_.func_228018_at_().func_198107_o(), (int)this.field_230706_i_.func_228018_at_().func_198087_p(), (int)-1, (FontRenderer)this.field_230712_o_);
    }

    private ITextComponent getActiveTaskName() {
        return ((MinionContainer)this.field_147002_h).getSelectedTask().getName();
    }

    private void onConfigurePressed(Button b) {
        ((MinionContainer)this.field_147002_h).openConfigurationScreen();
    }

    private void onStatsPressed(Button b) {
        ((MinionContainer)this.field_147002_h).openStatsScreen();
    }

    private void selectTask(int id) {
        this.taskList.field_230694_p_ = false;
        ((MinionContainer)this.field_147002_h).setTaskToActivate(id);
        this.taskButton.func_238482_a_(this.getActiveTaskName());
    }

    private void toggleActionLock(Button b) {
        this.lockActionButton.func_175229_b(!this.lockActionButton.func_175230_c());
        ((MinionContainer)this.field_147002_h).setTaskLocked(this.lockActionButton.func_175230_c());
    }
}

