/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.client.gui.ExtendedGui;
import de.teamlapen.lib.lib.util.FluidLib;
import de.teamlapen.lib.util.OptifineHandler;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.blocks.BloodContainerBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.StakeItem;
import de.teamlapen.vampirism.modcompat.IMCHandler;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.block.BlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class VampirismHUDOverlay
extends ExtendedGui {
    private final Minecraft mc;
    private final ResourceLocation icons = new ResourceLocation("vampirism:textures/gui/icons.png");
    private int screenColor = 0;
    private int screenPercentage = 0;
    private boolean fullScreen = false;
    private int renderFullTick = 0;
    private int rederFullOn;
    private int renderFullOff;
    private int renderFullColor;
    private int screenBottomColor = 0;
    private int screenBottomPercentage = 0;
    private boolean addTempPoison;
    private EffectInstance addedTempPoison;

    public VampirismHUDOverlay(Minecraft mc) {
        this.mc = mc;
    }

    public void makeRenderFullColor(int on, int off, int color) {
        this.rederFullOn = on;
        this.renderFullOff = off;
        this.renderFullTick = on + off;
        if ((color >> 24 & 0xFF) == 0) {
            color |= 0xFF000000;
        }
        this.renderFullColor = color;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            this.renderFullTick = 0;
            this.screenPercentage = 0;
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        IFactionPlayer player = FactionPlayerHandler.getCurrentFactionPlayer((PlayerEntity)this.mc.field_71439_g).orElse(null);
        if (player instanceof VampirePlayer) {
            this.handleScreenColorVampire((VampirePlayer)player);
        } else if (player instanceof HunterPlayer) {
            this.handleScreenColorHunter((HunterPlayer)player);
        } else {
            this.screenPercentage = 0;
            this.screenBottomPercentage = 0;
        }
        if (this.renderFullTick > 0) {
            this.screenColor = this.renderFullColor;
            this.fullScreen = true;
            this.screenPercentage = this.renderFullTick > this.renderFullOff ? (int)(100.0f * (1.0f - (float)(this.renderFullTick - this.renderFullOff) / (float)this.rederFullOn)) : (int)((float)(100 * this.renderFullTick) / (float)this.renderFullOff);
            --this.renderFullTick;
        }
    }

    @SubscribeEvent
    public void onRenderCrosshair(RenderGameOverlayEvent.Pre event) {
        float progress;
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS || this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        RayTraceResult p = Minecraft.func_71410_x().field_71476_x;
        if (p != null && p.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)p).func_216348_a();
            if (!entity.func_82150_aj()) {
                VampirismPlayerAttributes atts = VampirismPlayerAttributes.get((PlayerEntity)this.mc.field_71439_g);
                if (atts.vampireLevel > 0 && !this.mc.field_71439_g.func_175149_v() && !atts.getVampSpecial().bat && (double)entity.func_70032_d((Entity)this.mc.field_71439_g) <= this.mc.field_71439_g.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() / 2.0 + 1.0) {
                    VampirePlayer.getOpt((PlayerEntity)this.mc.field_71439_g).ifPresent(player -> {
                        Object biteableOpt = LazyOptional.empty();
                        if (entity instanceof IBiteableEntity) {
                            biteableOpt = LazyOptional.of(() -> (IBiteableEntity)entity);
                        } else if (entity instanceof CreatureEntity && entity.func_70089_S()) {
                            biteableOpt = ExtendedCreature.getSafe(entity);
                        } else if (entity instanceof PlayerEntity) {
                            biteableOpt = VampirePlayer.getOpt((PlayerEntity)entity);
                        }
                        biteableOpt.filter(iBiteableEntity -> iBiteableEntity.canBeBitten((IVampire)player)).ifPresent(biteable -> {
                            int color = 0xFF0000;
                            if (entity instanceof IHunterMob || ExtendedCreature.getSafe(entity).map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false).booleanValue()) {
                                color = 626722;
                            }
                            this.renderBloodFangs(event.getMatrixStack(), this.mc.func_228018_at_().func_198107_o(), this.mc.func_228018_at_().func_198087_p(), MathHelper.func_76131_a((float)biteable.getBloodLevelRelative(), (float)0.2f, (float)1.0f), color);
                            event.setCanceled(true);
                        });
                    });
                }
                if (atts.hunterLevel > 0 && !this.mc.field_71439_g.func_175149_v() && this.mc.field_71439_g.func_184614_ca().func_77973_b() == ModItems.STAKE.get() && entity instanceof LivingEntity && entity instanceof IVampireMob && StakeItem.canKillInstant((LivingEntity)entity, (LivingEntity)this.mc.field_71439_g) && ((LivingEntity)entity).func_110143_aJ() > 0.0f) {
                    this.renderStakeInstantKill(event.getMatrixStack(), this.mc.func_228018_at_().func_198107_o(), this.mc.func_228018_at_().func_198087_p());
                    event.setCanceled(true);
                }
            }
        } else if (p != null && p.func_216346_c() == RayTraceResult.Type.BLOCK) {
            TileEntity tile;
            BlockState block = Minecraft.func_71410_x().field_71441_e.func_180495_p(((BlockRayTraceResult)p).func_216350_a());
            if (((Object)((Object)((BloodContainerBlock)ModBlocks.BLOOD_CONTAINER.get()))).equals(block.func_177230_c()) && VampirePlayer.getOpt((PlayerEntity)this.mc.field_71439_g).map(VampirePlayer::wantsBlood).orElse(false).booleanValue() && (tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(((BlockRayTraceResult)p).func_216350_a())) != null) {
                tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
                    if (FluidLib.getFluidAmount(handler, (Fluid)ModFluids.BLOOD.get()) > 0) {
                        this.renderBloodFangs(event.getMatrixStack(), this.mc.func_228018_at_().func_198107_o(), this.mc.func_228018_at_().func_198087_p(), 1.0f, 0xFF0000);
                        event.setCanceled(true);
                    }
                });
            }
        }
        GameSettings gamesettings = this.mc.field_71474_y;
        if (gamesettings.func_243230_g().func_243192_a() && this.mc.field_71442_b.func_178889_l() != GameType.SPECTATOR && (progress = VampirePlayer.getOpt((PlayerEntity)this.mc.field_71439_g).map(VampirePlayer::getFeedProgress).orElse(Float.valueOf(0.0f)).floatValue()) > 0.0f) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (progress <= 1.0f) {
                int x = this.mc.func_228018_at_().func_198107_o() / 2 - 8;
                int y = this.mc.func_228018_at_().func_198087_p() / 2 - 7 + 16;
                this.mc.func_110434_K().func_110577_a(this.icons);
                int l = (int)(progress * 14.0f) + 2;
                this.func_238474_b_(event.getMatrixStack(), x, y, 0, 19, 16, 2);
                this.func_238474_b_(event.getMatrixStack(), x, y, 16, 19, l, 2);
            }
        }
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        if (this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        MatrixStack stack = event.getMatrixStack();
        switch (event.getType()) {
            case EXPERIENCE: {
                this.renderFactionLevel(stack);
                break;
            }
            case ALL: {
                this.renderAction(stack);
            }
        }
    }

    @SubscribeEvent
    public void onRenderFoodBar(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        if (this.mc.field_71439_g != null && Helper.isVampire((PlayerEntity)this.mc.field_71439_g) && !IMCHandler.requestedToDisableBloodbar) {
            event.setCanceled(true);
            if (this.mc.field_71442_b.func_78763_f() && this.mc.field_71439_g.func_70089_S()) {
                VampirePlayer.getOpt((PlayerEntity)this.mc.field_71439_g).map(VampirePlayer::getBloodStats).ifPresent(stats -> {
                    GlStateManager.func_227740_m_();
                    this.mc.func_110434_K().func_110577_a(this.icons);
                    int left = this.mc.func_228018_at_().func_198107_o() / 2 + 91;
                    int top = this.mc.func_228018_at_().func_198087_p() - ForgeIngameGui.right_height;
                    ForgeIngameGui.right_height += 10;
                    int blood = stats.getBloodLevel();
                    int maxBlood = stats.getMaxBlood();
                    int blood2 = blood - 20;
                    int maxBlood2 = maxBlood - 20;
                    for (int i = 0; i < 10; ++i) {
                        int idx = i * 2 + 1;
                        int x = left - i * 8 - 9;
                        this.func_238474_b_(event.getMatrixStack(), x, top, 0, idx <= maxBlood2 ? 9 : 0, 9, 9);
                        if (idx < blood) {
                            this.func_238474_b_(event.getMatrixStack(), x, top, 9, idx < blood2 ? 9 : 0, 9, 9);
                            if (idx != blood2) continue;
                            this.func_238474_b_(event.getMatrixStack(), x, top, 18, 9, 9, 9);
                            continue;
                        }
                        if (idx != blood) continue;
                        this.func_238474_b_(event.getMatrixStack(), x, top, 18, 0, 9, 9);
                    }
                    this.mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                    GlStateManager.func_227737_l_();
                });
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if ((this.screenPercentage > 0 || this.screenBottomPercentage > 0) && ((Boolean)VampirismConfig.CLIENT.renderScreenOverlay.get()).booleanValue()) {
            MatrixStack stack = event.getMatrixStack();
            stack.func_227860_a_();
            int w = this.mc.func_228018_at_().func_198107_o();
            int h = this.mc.func_228018_at_().func_198087_p();
            if (this.fullScreen) {
                float r = (float)(this.screenColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(this.screenColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(this.screenColor & 0xFF) / 255.0f;
                float a = (float)this.screenPercentage / 100.0f * (float)(this.screenColor >> 24 & 0xFF) / 255.0f;
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.disableAlphaTest();
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                RenderSystem.shadeModel((int)7425);
                Tessellator tessellator = Tessellator.func_178181_a();
                Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
                BufferBuilder worldrenderer = tessellator.func_178180_c();
                worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                worldrenderer.func_227888_a_(matrix, 0.0f, (float)h, (float)this.func_230927_p_()).func_227885_a_(r, g, b, a).func_181675_d();
                worldrenderer.func_227888_a_(matrix, (float)w, (float)h, (float)this.func_230927_p_()).func_227885_a_(r, g, b, a).func_181675_d();
                worldrenderer.func_227888_a_(matrix, (float)w, 0.0f, (float)this.func_230927_p_()).func_227885_a_(r, g, b, a).func_181675_d();
                worldrenderer.func_227888_a_(matrix, 0.0f, 0.0f, (float)this.func_230927_p_()).func_227885_a_(r, g, b, a).func_181675_d();
                tessellator.func_78381_a();
                RenderSystem.shadeModel((int)7424);
                RenderSystem.disableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
            } else if (this.screenPercentage > 0) {
                int bw = 0;
                int bh = 0;
                bh = Math.round((float)h / 4.0f * (float)this.screenPercentage / 100.0f);
                bw = Math.round((float)w / 8.0f * (float)this.screenPercentage / 100.0f);
                this.func_238468_a_(stack, 0, 0, w, bh, this.screenColor, 0);
                if (!OptifineHandler.isShaders()) {
                    this.func_238468_a_(stack, 0, h - bh, w, h, 0, this.screenColor);
                }
                this.fillGradient2(stack, 0, 0, bw, h, 0, this.screenColor);
                this.fillGradient2(stack, w - bw, 0, w, h, this.screenColor, 0);
            } else {
                int hh = 0;
                hh = Math.round((float)h / 4.0f * (float)this.screenBottomPercentage / 100.0f);
                this.func_238468_a_(event.getMatrixStack(), 0, h - hh, w, h, 0, this.screenBottomColor);
            }
            stack.func_227865_b_();
        }
    }

    @SubscribeEvent
    public void onRenderHealthBarPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH) {
            return;
        }
        if (this.addTempPoison) {
            this.mc.field_71439_g.field_70713_bf.remove(Effects.field_76436_u);
        }
    }

    @SubscribeEvent
    public void onRenderHealthBarPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH) {
            return;
        }
        boolean bl = this.addTempPoison = this.mc.field_71439_g.func_70644_a((Effect)ModEffects.POISON.get()) && !this.mc.field_71439_g.field_70713_bf.containsKey(Effects.field_76436_u);
        if (this.addTempPoison) {
            if (this.addedTempPoison == null) {
                this.addedTempPoison = new EffectInstance(Effects.field_76436_u, 100);
            }
            this.mc.field_71439_g.field_70713_bf.put(Effects.field_76436_u, this.addedTempPoison);
        }
    }

    private void handleScreenColorHunter(HunterPlayer hunter) {
        if (hunter.getSpecialAttributes().isDisguised()) {
            this.screenPercentage = (int)(100.0f * hunter.getSpecialAttributes().getDisguiseProgress());
            this.screenColor = -15658735;
            this.fullScreen = false;
        } else if (hunter.getSpecialAttributes().isVampireNearby()) {
            this.screenPercentage = (int)(70.0f * hunter.getSpecialAttributes().getVampireNearbyProgress());
            this.screenColor = -2135287754;
            this.fullScreen = false;
        } else {
            this.screenPercentage = (int)Math.max(0.0f, (float)this.screenPercentage / 20.0f * 10.0f);
        }
    }

    private void handleScreenColorVampire(VampirePlayer vampire) {
        if (vampire.getActionHandler().isActionActive((ILastingAction)VampireActions.VAMPIRE_RAGE.get())) {
            this.screenPercentage = 100;
            this.screenColor = -1048576;
            this.fullScreen = false;
        } else {
            this.screenPercentage = vampire.getTicksInSun() / 2;
            if (this.screenPercentage > 0) {
                EffectInstance effect = this.mc.field_71439_g.func_70660_b((Effect)ModEffects.SUNSCREEN.get());
                if (effect == null || effect.func_76458_c() < 5) {
                    this.screenColor = -2219;
                    this.fullScreen = false;
                    if (vampire.getRepresentingPlayer().field_71075_bZ.field_75098_d || effect != null && effect.func_76458_c() >= 3) {
                        this.screenPercentage = Math.min(20, this.screenPercentage);
                    }
                    this.screenPercentage = Math.min(this.screenPercentage, (Integer)VampirismConfig.BALANCE.vpMaxYellowBorderPercentage.get());
                } else {
                    this.screenPercentage = 0;
                }
            } else {
                this.screenPercentage = 0;
            }
        }
        if (vampire.getActionHandler().isActionActive((ILastingAction)VampireActions.BAT.get())) {
            float batPercentage = vampire.getActionHandler().getPercentageForAction((IAction)VampireActions.BAT.get());
            if (batPercentage < 0.2f && batPercentage > 0.0f) {
                this.screenBottomColor = -865048583;
                this.screenBottomPercentage = (int)((0.2f - batPercentage) * 1000.0f);
                this.fullScreen = false;
            } else {
                this.screenBottomPercentage = 0;
            }
        } else {
            this.screenBottomPercentage = 0;
        }
    }

    private void renderBloodFangs(MatrixStack stack, int width, int height, float perc, int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 256.0f;
        float g = (float)((color & 0xFF00) >> 8) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        this.mc.func_110434_K().func_110577_a(this.icons);
        int left = width / 2 - 8;
        int top = height / 2 - 4;
        GL11.glEnable((int)3042);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        this.func_238474_b_(stack, left, top, 27, 0, 16, 10);
        GlStateManager.func_227702_d_((float)r, (float)g, (float)b, (float)0.8f);
        int percHeight = (int)(10.0f * perc);
        this.func_238474_b_(stack, left, top + (10 - percHeight), 27, 10 - percHeight, 16, percHeight);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    private void renderStakeInstantKill(MatrixStack mStack, int width, int height) {
        if (this.mc.field_71474_y.func_243230_g().func_243192_a() && this.mc.field_71442_b.func_178889_l() != GameType.SPECTATOR) {
            GlStateManager.func_227644_a_((int)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
            this.mc.field_71446_o.func_110577_a(AbstractGui.field_230665_h_);
            GlStateManager.func_227702_d_((float)0.6171875f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.func_238474_b_(mStack, (width - 15) / 2, (height - 15) / 2, 0, 0, 15, 15);
            int j = height / 2 - 7 + 16;
            int k = width / 2 - 8;
            this.func_238474_b_(mStack, k, j, 68, 94, 16, 16);
            this.func_238474_b_(mStack, k, j, 36, 94, 16, 4);
            this.func_238474_b_(mStack, k, j, 52, 94, 17, 4);
        }
    }

    private void renderFactionLevel(MatrixStack stack) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        FactionPlayerHandler.getOpt((PlayerEntity)this.mc.field_71439_g).ifPresent(handler -> {
            IPlayableFaction<IFactionPlayer<?>> faction = handler.getCurrentFaction();
            if (this.mc.field_71442_b.func_78763_f() && faction != null && faction.renderLevel()) {
                String text;
                int color = faction.getColor().getRGB();
                int lord = handler.getLordLevel();
                if (lord > 0) {
                    String title = handler.getLordTitle().getString();
                    text = title.substring(0, Math.min(3, title.length()));
                } else {
                    text = "" + handler.getCurrentLevel();
                }
                int x = (this.mc.func_228018_at_().func_198107_o() - this.mc.field_71466_p.func_78256_a(text)) / 2 + (Integer)VampirismConfig.CLIENT.guiLevelOffsetX.get();
                int y = this.mc.func_228018_at_().func_198087_p() - (Integer)VampirismConfig.CLIENT.guiLevelOffsetY.get();
                this.mc.field_71466_p.func_238421_b_(stack, text, (float)(x + 1), (float)y, 0);
                this.mc.field_71466_p.func_238421_b_(stack, text, (float)(x - 1), (float)y, 0);
                this.mc.field_71466_p.func_238421_b_(stack, text, (float)x, (float)(y + 1), 0);
                this.mc.field_71466_p.func_238421_b_(stack, text, (float)x, (float)(y - 1), 0);
                this.mc.field_71466_p.func_238421_b_(stack, text, (float)x, (float)y, color);
            }
        });
    }

    private void renderAction(MatrixStack matrixStack) {
        if (VampirismAPI.factionRegistry().getFaction((Entity)this.mc.field_71439_g) != null) {
            VampirismAPI.getFactionPlayerHandler((PlayerEntity)this.mc.field_71439_g).ifPresent(playerHandler -> playerHandler.getCurrentFactionPlayer().ifPresent(factionPlayer -> {
                int perc;
                ResourceLocation loc;
                IActionHandler actionHandler = factionPlayer.getActionHandler();
                int x = 12;
                int y = this.mc.func_228018_at_().func_198087_p() - 27;
                if (!((Boolean)VampirismConfig.CLIENT.disableHudActionDurationRendering.get()).booleanValue()) {
                    for (IAction action : factionPlayer.getActionHandler().getUnlockedActions()) {
                        if (!(action instanceof ILastingAction) || !((ILastingAction)action).showHudDuration((PlayerEntity)this.mc.field_71439_g) || !actionHandler.isActionActive((ILastingAction)action)) continue;
                        loc = new ResourceLocation(action.getRegistryName().func_110624_b(), "textures/actions/" + action.getRegistryName().func_110623_a() + ".png");
                        this.mc.func_110434_K().func_110577_a(loc);
                        perc = (int)((1.0f - actionHandler.getPercentageForAction(action)) * 16.0f);
                        this.func_238468_a_(matrixStack, x, y + perc, x + 16, y + 16, 0x44888888, 0x44888888);
                        RenderSystem.enableBlend();
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                        VampirismHUDOverlay.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                        x += 17;
                    }
                }
                x = this.mc.func_228018_at_().func_198107_o() - 12 - 16;
                if (!((Boolean)VampirismConfig.CLIENT.disableHudActionDurationRendering.get()).booleanValue()) {
                    for (IAction action : factionPlayer.getActionHandler().getUnlockedActions()) {
                        if (!action.showHudCooldown((PlayerEntity)this.mc.field_71439_g) || !actionHandler.isActionOnCooldown(action)) continue;
                        loc = new ResourceLocation(action.getRegistryName().func_110624_b(), "textures/actions/" + action.getRegistryName().func_110623_a() + ".png");
                        this.mc.func_110434_K().func_110577_a(loc);
                        perc = (int)((1.0f - -actionHandler.getPercentageForAction(action)) * 16.0f);
                        this.func_238468_a_(matrixStack, x, y + perc, x + 16, y + 16, 0x44888888, 0x44888888);
                        RenderSystem.enableBlend();
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                        VampirismHUDOverlay.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                        x -= 17;
                    }
                }
            }));
        }
    }
}

