/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.client.render.tiles.VampirismTESR;
import de.teamlapen.vampirism.tileentity.TotemTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TotemTESR
extends VampirismTESR<TotemTileEntity> {
    private static final ResourceLocation TEXTURE_BEACON_BEAM = new ResourceLocation("vampirism", "textures/entity/totem_beam.png");
    private static final int HEIGHT = 100;

    public TotemTESR(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TotemTileEntity te, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer iRenderTypeBuffer, int i, int i1) {
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        float textureScale = te.shouldRenderBeam();
        if (textureScale > 0.0f) {
            long totalWorldTime = te.func_145831_w().func_82737_E();
            int captureProgress = te.getCaptureProgress();
            float[] baseColors = te.getBaseColors();
            int offset = 0;
            if (captureProgress > 0) {
                float[] overtakeColors = te.getCapturingColors();
                offset = captureProgress * 100 / 100;
                BeaconTileEntityRenderer.func_228842_a_((MatrixStack)matrixStack, (IRenderTypeBuffer)iRenderTypeBuffer, (ResourceLocation)TEXTURE_BEACON_BEAM, (float)partialTicks, (float)textureScale, (long)totalWorldTime, (int)0, (int)offset, (float[])overtakeColors, (float)0.2f, (float)0.25f);
            }
            BeaconTileEntityRenderer.func_228842_a_((MatrixStack)matrixStack, (IRenderTypeBuffer)iRenderTypeBuffer, (ResourceLocation)TEXTURE_BEACON_BEAM, (float)partialTicks, (float)textureScale, (long)totalWorldTime, (int)offset, (int)(100 - offset), (float[])baseColors, (float)0.2f, (float)0.25f);
        } else {
            IFaction<?> faction = te.getControllingFaction();
            if (faction != null) {
                this.renderFactionName(faction, matrixStack, iRenderTypeBuffer, i);
            }
        }
    }

    public boolean shouldRenderOffScreen(TotemTileEntity te) {
        return true;
    }

    private void renderFactionName(IFaction<?> faction, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int packedLight) {
        IFormattableTextComponent displayNameIn = faction.getNamePlural().func_230531_f_().func_240699_a_(faction.getChatColor());
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.0, 0.5);
        matrixStack.func_227863_a_(Minecraft.func_71410_x().field_71460_t.func_215316_n().func_227995_f_());
        matrixStack.func_227862_a_(-0.025f, -0.025f, -0.025f);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        float f1 = 0.0f;
        int j = (int)(f1 * 255.0f) << 24;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        float nameOffset = -font.func_238414_a_((ITextProperties)displayNameIn) / 2;
        font.func_243247_a((ITextComponent)displayNameIn, nameOffset, 0.0f, 0x20FFFFFF, false, matrix4f, iRenderTypeBuffer, true, j, packedLight);
        font.func_243247_a((ITextComponent)displayNameIn, nameOffset, 0.0f, -1, false, matrix4f, iRenderTypeBuffer, true, 0, packedLight);
        matrixStack.func_227865_b_();
    }
}

