/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.command.arguments.BiomeArgument;
import de.teamlapen.vampirism.command.arguments.ModSuggestionProvider;
import de.teamlapen.vampirism.config.VampirismConfig;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntitySummonArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigCommand
extends BasicCommand {
    private static final SimpleCommandExceptionType NO_SELECTED_ENTITY = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.vampirism.base.config.bloodvalues.blacklist.no_entity"));
    private static final SimpleCommandExceptionType NO_CONFIG_TYPE = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.vampirism.base.config.no_config"));
    private static final SimpleCommandExceptionType NO_BLOOD_VALUE_TYPE = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.vampirism.base.config.bloodvalues.no_type"));
    private static final SimpleCommandExceptionType NO_BLOOD_VALUE_BLACKLIST_TYPE = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.vampirism.base.config.bloodvalues.blacklist.no_type"));
    private static final SimpleCommandExceptionType NO_SUN_DAMAGE_TYPE = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.vampirism.base.config.sun_damage.no_type"));
    private static final SimpleCommandExceptionType NO_SUN_DAMAGE_BLACKLIST_TYPE = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.vampirism.base.config.sun_damage.blacklist.no_type"));

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"config").requires(context -> context.func_197034_c(3))).executes(context -> {
            throw NO_CONFIG_TYPE.create();
        })).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"bloodvalues").executes(context -> {
            throw NO_BLOOD_VALUE_TYPE.create();
        })).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"blacklist").executes(context -> {
            throw NO_BLOOD_VALUE_BLACKLIST_TYPE.create();
        })).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"entity").executes(context -> ConfigCommand.blacklistEntity(((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"entity", (ArgumentType)EntitySummonArgument.func_211366_a()).suggests(ModSuggestionProvider.ENTITIES).executes(context -> ConfigCommand.blacklistEntity(((CommandSource)context.getSource()).func_197035_h(), EntitySummonArgument.func_211368_a((CommandContext)context, (String)"entity")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"sundamage").executes(context -> {
            throw NO_SUN_DAMAGE_TYPE.create();
        })).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"blacklist").executes(context -> {
            throw NO_SUN_DAMAGE_BLACKLIST_TYPE.create();
        })).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"biome").executes(context -> ConfigCommand.blacklistBiome(((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"biome", (ArgumentType)BiomeArgument.biome()).suggests(ModSuggestionProvider.BIOMES).executes(context -> ConfigCommand.blacklistBiome(((CommandSource)context.getSource()).func_197035_h(), BiomeArgument.getBiomeId((CommandContext<CommandSource>)context, "biome")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"dimension").executes(context -> ConfigCommand.blacklistDimension(((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> ConfigCommand.blacklistDimension(((CommandSource)context.getSource()).func_197035_h(), DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension"))))))).then(Commands.func_197057_a((String)"enforce").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"dimension").executes(context -> ConfigCommand.enforceDimension(((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> ConfigCommand.enforceDimension(((CommandSource)context.getSource()).func_197035_h(), DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension")))))))).then(Commands.func_197057_a((String)"bat-dimension-blacklist").then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> ConfigCommand.batBlacklistDimension(((CommandSource)context.getSource()).func_197035_h(), DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension")))));
    }

    private static int blacklistEntity(ServerPlayerEntity player) throws CommandSyntaxException {
        AxisAlignedBB axisalignedbb;
        Vector3d vec3d = player.func_174824_e(1.0f);
        double d0 = 50.0;
        Vector3d vec3d1 = player.func_70676_i(1.0f);
        Vector3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0);
        EntityRayTraceResult result = ProjectileHelper.func_221269_a((World)player.field_70170_p, (Entity)player, (Vector3d)vec3d, (Vector3d)vec3d2, (AxisAlignedBB)(axisalignedbb = player.func_174813_aQ().func_216361_a(vec3d1.func_186678_a(d0)).func_186662_g(1.0)), a -> !a.func_175149_v());
        if (result == null) {
            throw NO_SELECTED_ENTITY.create();
        }
        Entity entity = result.func_216348_a();
        EntityType entityType = entity.func_200600_R();
        return ConfigCommand.blacklistEntity(player, entityType.getRegistryName());
    }

    private static int blacklistEntity(ServerPlayerEntity player, ResourceLocation entity) {
        return ConfigCommand.modifyList(player, entity, VampirismConfig.SERVER.blacklistedBloodEntity, "command.vampirism.base.config.entity.blacklisted", "command.vampirism.base.config.entity.not_blacklisted");
    }

    private static int blacklistBiome(ServerPlayerEntity player) {
        return ConfigCommand.blacklistBiome(player, player.func_130014_f_().func_226691_t_(player.func_233580_cy_()).getRegistryName());
    }

    private static int blacklistBiome(ServerPlayerEntity player, ResourceLocation biome) {
        return ConfigCommand.modifyList(player, biome, VampirismConfig.SERVER.sundamageDisabledBiomes, "command.vampirism.base.config.biome.blacklisted", "command.vampirism.base.config.biome.not_blacklisted");
    }

    private static int blacklistDimension(ServerPlayerEntity player) {
        return ConfigCommand.blacklistDimension(player, player.func_71121_q());
    }

    private static int blacklistDimension(ServerPlayerEntity player, ServerWorld dimension) {
        return ConfigCommand.modifyList(player, dimension.func_234923_W_().func_240901_a_(), VampirismConfig.SERVER.sundamageDimensionsOverrideNegative, "command.vampirism.base.config.dimension.blacklisted", "command.vampirism.base.config.dimension.not_blacklisted");
    }

    private static int enforceDimension(ServerPlayerEntity player) {
        return ConfigCommand.enforceDimension(player, player.func_71121_q());
    }

    private static int enforceDimension(ServerPlayerEntity player, ServerWorld dimension) {
        return ConfigCommand.modifyList(player, dimension.func_234923_W_().func_240901_a_(), VampirismConfig.SERVER.sundamageDimensionsOverridePositive, "command.vampirism.base.config.dimension.enforced", "command.vampirism.base.config.dimension.not_enforced");
    }

    private static int batBlacklistDimension(ServerPlayerEntity player, ServerWorld dim) {
        return ConfigCommand.modifyList(player, dim.func_234923_W_().func_240901_a_(), VampirismConfig.SERVER.batDimensionBlacklist, "command.vampirism.base.config.bat_dim.blacklisted", "command.vampirism.base.config.bat_dim.not_blacklisted");
    }

    private static int modifyList(ServerPlayerEntity player, ResourceLocation id, ForgeConfigSpec.ConfigValue<List<? extends String>> configList, String blacklist, String not_blacklist) {
        List list = (List)configList.get();
        if (!list.contains(id.toString())) {
            list.add(id.toString());
            player.func_146105_b((ITextComponent)new TranslationTextComponent(blacklist, new Object[]{id}), false);
        } else {
            list.remove(id.toString());
            player.func_146105_b((ITextComponent)new TranslationTextComponent(not_blacklist, new Object[]{id}), false);
        }
        configList.set((Object)list);
        return 0;
    }
}

