/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.command.arguments.MinionArgument;
import de.teamlapen.vampirism.entity.minion.management.MinionInventory;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.misc.VampirismLogger;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ItemArgument;
import net.minecraft.command.arguments.ItemInput;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class MinionInventoryCommand
extends BasicCommand {
    private static final SimpleCommandExceptionType NO_PLAYER = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.vampirism.base.minion_inventory.no_player"));
    private static final SimpleCommandExceptionType NO_MINION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.vampirism.base.minion_inventory.no_minion"));

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"modifyMinionInventory").requires(context -> context.func_197034_c(3))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"minion", (ArgumentType)MinionArgument.minions()).then(Commands.func_197057_a((String)"list").executes(context -> MinionInventoryCommand.listInventory((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h(), MinionArgument.getId((CommandContext<CommandSource>)context, "minion"))))).then(Commands.func_197057_a((String)"remove").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(context -> MinionInventoryCommand.removeItem((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h(), MinionArgument.getId((CommandContext<CommandSource>)context, "minion"), ItemArgument.func_197316_a((CommandContext)context, (String)"item"), 1))).then(Commands.func_197056_a((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> MinionInventoryCommand.removeItem((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h(), MinionArgument.getId((CommandContext<CommandSource>)context, "minion"), ItemArgument.func_197316_a((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"))))))).then(Commands.func_197057_a((String)"add").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(context -> MinionInventoryCommand.addItem((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h(), MinionArgument.getId((CommandContext<CommandSource>)context, "minion"), ItemArgument.func_197316_a((CommandContext)context, (String)"item"), 1))).then(Commands.func_197056_a((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> MinionInventoryCommand.addItem((CommandSource)context.getSource(), ((CommandSource)context.getSource()).func_197035_h(), MinionArgument.getId((CommandContext<CommandSource>)context, "minion"), ItemArgument.func_197316_a((CommandContext)context, (String)"item"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count")))))));
    }

    private static int addItem(CommandSource source, ServerPlayerEntity player, MinionArgument.MinionId playerMinionIdentifier, ItemInput item, int count) throws CommandSyntaxException {
        ItemStack itemStack = item.func_197320_a(count, true);
        MinionInventoryCommand.getInventory(playerMinionIdentifier).ifPresent(minionInventory -> {
            minionInventory.addItemStack(itemStack.func_77946_l());
            VampirismLogger.info(VampirismLogger.MINION_INVENTORY, "{} added {} {} to inventory of {}", player.func_200200_C_().getString(), itemStack.func_190916_E(), itemStack.func_151000_E().getString(), playerMinionIdentifier);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.minion_inventory.add_success", new Object[]{itemStack.func_190916_E(), itemStack.func_151000_E().getString(), playerMinionIdentifier}).func_240699_a_(TextFormatting.AQUA), false);
        });
        return 0;
    }

    private static int removeItem(CommandSource source, ServerPlayerEntity player, MinionArgument.MinionId playerMinionIdentifier, ItemInput item, int count) throws CommandSyntaxException {
        MinionInventoryCommand.getInventory(playerMinionIdentifier).ifPresent(minionInventory -> {
            List itemStacks = minionInventory.getAllInventorys().stream().flatMap(Collection::stream).filter(item).collect(Collectors.toList());
            if (!itemStacks.isEmpty()) {
                ItemStack stack = ((ItemStack)itemStacks.get(0)).func_77979_a(count);
                player.func_191521_c(stack.func_77946_l());
                VampirismLogger.info(VampirismLogger.MINION_INVENTORY, "{} removed {} {} from inventory of {}", player.func_200200_C_().getString(), stack.func_190916_E(), stack.func_151000_E().getString(), playerMinionIdentifier);
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.minion_inventory.item_removed", new Object[]{stack.func_190916_E(), stack.func_151000_E().getString(), playerMinionIdentifier}).func_240699_a_(TextFormatting.AQUA), false);
            } else {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.minion_inventory.item_not_found"));
            }
        });
        return 0;
    }

    private static int listInventory(CommandSource source, ServerPlayerEntity player, MinionArgument.MinionId playerMinionIdentifier) throws CommandSyntaxException {
        MinionInventoryCommand.getInventory(playerMinionIdentifier).ifPresent(inv -> {
            HashMap count = new HashMap();
            inv.getAllInventorys().stream().flatMap(Collection::stream).filter(stack -> !stack.func_190926_b()).forEach(item -> count.merge(item.func_77973_b(), item.func_190916_E(), Integer::sum));
            if (count.isEmpty()) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.minion_inventory.empty", new Object[]{playerMinionIdentifier}).func_240699_a_(TextFormatting.AQUA), false);
            } else {
                VampirismLogger.info(VampirismLogger.MINION_INVENTORY, "{} views inventory of {}", player.func_200200_C_().getString(), playerMinionIdentifier);
                source.func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.minion_inventory.content", new Object[]{playerMinionIdentifier}).func_240699_a_(TextFormatting.AQUA).func_240699_a_(TextFormatting.UNDERLINE), false);
                source.func_197030_a((ITextComponent)new StringTextComponent(count.entrySet().stream().map(a -> a.getValue() + " " + ((Item)a.getKey()).getRegistryName()).collect(Collectors.joining("\n"))).func_240699_a_(TextFormatting.AQUA), false);
            }
        });
        return 0;
    }

    private static Optional<MinionInventory> getInventory(MinionArgument.MinionId playerMinionIdentifier) throws CommandSyntaxException {
        String playerName = playerMinionIdentifier.player;
        int minionId = playerMinionIdentifier.id;
        MinionWorldData data = MinionWorldData.getData(ServerLifecycleHooks.getCurrentServer());
        GameProfile profile = ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152655_a(playerName);
        if (profile == null) {
            throw NO_PLAYER.create();
        }
        PlayerMinionController controller = data.getController(profile.getId());
        if (controller == null) {
            throw NO_MINION.create();
        }
        Optional<MinionInventory> minionInventory = controller.contactMinionData(minionId, minionData -> {
            playerMinionIdentifier.updateName(minionData.getFormattedName().getString());
            return minionData.getInventory();
        });
        if (!minionInventory.isPresent()) {
            throw NO_MINION.create();
        }
        return minionInventory;
    }
}

