/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.arguments;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.StringEscapeUtils;

public class MinionArgument
implements ArgumentType<MinionId> {
    public static final SimpleCommandExceptionType NO_MINION_FOUND = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.vampirism.argument.minion.notfound"));
    private final Supplier<Collection<MinionId>> playerMinionIds;

    public MinionArgument() {
        this.playerMinionIds = this::getPlayerMinionIds;
    }

    public MinionArgument(Collection<MinionId> playerMinionIds) {
        this.playerMinionIds = () -> playerMinionIds;
    }

    public static MinionArgument minions() {
        return new MinionArgument();
    }

    public static MinionId getId(CommandContext<CommandSource> source, String argumentId) {
        return (MinionId)source.getArgument(argumentId, MinionId.class);
    }

    private Collection<MinionId> getPlayerMinionIds() {
        MinionWorldData data = MinionWorldData.getData(ServerLifecycleHooks.getCurrentServer());
        PlayerProfileCache profileCache = ServerLifecycleHooks.getCurrentServer().func_152358_ax();
        return data.getControllers().entrySet().stream().filter(entry -> profileCache.func_152652_a((UUID)entry.getKey()) != null).flatMap(id -> ((PlayerMinionController)id.getValue()).getMinionIdForName(profileCache.func_152652_a((UUID)id.getKey()).getName()).stream()).collect(Collectors.toList());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining();
        this.filterResources((Iterable<MinionId>)this.playerMinionIds.get(), s, arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    void filterResources(Iterable<MinionId> arguments, String commandText, Consumer<String> consumer) {
        for (MinionId id : arguments) {
            if (!ISuggestionProvider.func_237256_a_((String)commandText, (String)id.toEscaped()) && !ISuggestionProvider.func_237256_a_((String)commandText, (String)id.toShort())) continue;
            consumer.accept(id.toShort());
            consumer.accept(id.toEscaped());
        }
    }

    public MinionId parse(StringReader reader) throws CommandSyntaxException {
        StringBuilder builder = new StringBuilder();
        boolean isQuotes = false;
        int prev = 0;
        while (reader.canRead()) {
            char c = reader.peek();
            if (c == '\"' && prev != 92) {
                isQuotes = !isQuotes;
                reader.skip();
                continue;
            }
            if (c == ' ' && !isQuotes) break;
            builder.append(c);
            reader.skip();
            prev = c;
        }
        MinionId id = new MinionId(builder.toString());
        if (this.playerMinionIds.get().contains(id)) {
            return id;
        }
        throw NO_MINION_FOUND.create();
    }

    public static class MinionArgumentSerializer
    implements IArgumentSerializer<MinionArgument> {
        public void serializeToNetwork(@Nonnull MinionArgument argument, @Nonnull PacketBuffer buffer) {
            Collection ids = (Collection)argument.playerMinionIds.get();
            buffer.func_150787_b(ids.size());
            ids.forEach(id -> buffer.func_180714_a(id.toString()));
        }

        @Nonnull
        public MinionArgument deserializeFromNetwork(@Nonnull PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            ArrayList<MinionId> ids = new ArrayList<MinionId>(size);
            for (int i = 0; i < size; ++i) {
                ids.add(new MinionId(buffer.func_218666_n()));
            }
            return new MinionArgument(ids);
        }

        public void serializeToJson(@Nonnull MinionArgument argument, @Nonnull JsonObject json) {
            JsonArray array = new JsonArray();
            ((Collection)argument.playerMinionIds.get()).forEach(id -> array.add(id.toString()));
            json.add("playerMinionIds", (JsonElement)array);
        }
    }

    public static class MinionId {
        public final String player;
        public final int id;
        public String name;

        public MinionId(String player, int id, String name) {
            this.player = player;
            this.id = id;
            this.name = name;
        }

        public MinionId(String id) throws NumberFormatException {
            int first = id.indexOf(58);
            this.player = id.substring(0, first);
            int second = id.indexOf(124);
            if (second == -1) {
                this.id = Integer.parseInt(id.substring(first + 1).trim());
                this.name = "";
            } else {
                this.id = Integer.parseInt(id.substring(first + 1, second).trim());
                this.name = id.length() > second + 1 ? id.substring(second + 1).trim() : "";
            }
        }

        public void updateName(String name) {
            this.name = name;
        }

        public String toString() {
            if (this.name.isEmpty()) {
                return this.player + ":" + this.id;
            }
            return this.player + ":" + this.id + " | " + this.name;
        }

        public String toEscaped() {
            String res = StringEscapeUtils.escapeJava((String)(this.player + ":" + this.id + " | " + this.name));
            if (res.contains(" ")) {
                res = "\"" + res + "\"";
            }
            return res;
        }

        public String toShort() {
            return this.player + ":" + this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MinionId id1 = (MinionId)o;
            if (this.id != id1.id) {
                return false;
            }
            return Objects.equals(this.player, id1.player);
        }

        public int hashCode() {
            int result = this.player != null ? this.player.hashCode() : 0;
            result = 31 * result + this.id;
            return result;
        }
    }
}

