/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.command.arguments.RefinementSetArgument;
import de.teamlapen.vampirism.entity.factions.PlayableFaction;
import de.teamlapen.vampirism.items.VampireRefinementItem;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GiveAccessoriesCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"giveAccessories").requires(context -> context.func_197034_c(2))).then(Commands.func_197056_a((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).then(Commands.func_197056_a((String)"set", (ArgumentType)RefinementSetArgument.actions()).executes(context -> GiveAccessoriesCommand.give((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"), RefinementSetArgument.getSet((CommandContext<CommandSource>)context, "set")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"random").executes(context -> GiveAccessoriesCommand.random((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), 1))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> GiveAccessoriesCommand.random((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))).then(Commands.func_197057_a((String)"help").executes(GiveAccessoriesCommand::help));
    }

    private static <Z extends Item> int give(CommandContext<CommandSource> context, ServerPlayerEntity asPlayer, int number, IRefinementSet set) {
        IFaction<?> faction = set.getFaction();
        if (faction instanceof PlayableFaction) {
            ItemStack s;
            Object i = ((PlayableFaction)faction).getRefinementItem(IRefinementItem.AccessorySlotType.values()[number - 1]);
            if (((IRefinementItem)i).applyRefinementSet(s = new ItemStack(i), set)) {
                asPlayer.func_191521_c(s);
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.give_accessories.success", new Object[]{set.getName(), number}), false);
            } else {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.give_accessories.incompatible", new Object[]{set.getName(), number}), false);
            }
        }
        return 0;
    }

    private static int help(CommandContext<CommandSource> context) {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.give_accessories.help"), false);
        return 0;
    }

    private static <T extends IFactionPlayer<?>> int random(CommandContext<CommandSource> context, ServerPlayerEntity entity, int amount) {
        IFaction faction = VampirismAPI.factionRegistry().getFaction((Entity)entity);
        if (faction instanceof PlayableFaction) {
            for (int i = 0; i < amount; ++i) {
                ItemStack stack = VampireRefinementItem.getRandomRefinementItem((PlayableFaction)faction);
                if (stack.func_190926_b()) {
                    ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.test.give_accessories.no_item"), false);
                    return 0;
                }
                entity.func_191521_c(stack);
            }
        }
        return 0;
    }
}

