/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.config.bloodvalues;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.config.bloodvalues.BloodValueBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BloodValueReader<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final Consumer<Map<ResourceLocation, Float>> valueConsumer;
    private final String directory;
    private final String name;

    public BloodValueReader(Consumer<Map<ResourceLocation, Float>> valueConsumer, String directory, String name) {
        this.valueConsumer = valueConsumer;
        this.directory = directory;
        this.name = name;
    }

    public CompletableFuture<Map<String, BloodValueBuilder>> prepare(IResourceManager manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> this.loadValues(manager), executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, BloodValueBuilder> loadValues(IResourceManager manager) {
        HashMap<String, BloodValueBuilder> values = new HashMap<String, BloodValueBuilder>();
        for (ResourceLocation resourcePath : manager.func_199003_a(this.directory, file -> file.endsWith(".json"))) {
            String s = resourcePath.func_110623_a();
            ResourceLocation resourceName = new ResourceLocation(resourcePath.func_110624_b(), s.substring(this.directory.length() + 1, s.length() - PATH_SUFFIX_LENGTH));
            try {
                for (IResource resource : manager.func_199004_b(resourcePath)) {
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8));
                        Throwable throwable = null;
                        try {
                            JsonObject json = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                            if (json == null) {
                                LOGGER.error("Couldn't load {} blood values {} from {} in datapack {} as it is empty or null", (Object)this.name, (Object)resourceName, (Object)resourcePath, (Object)resource.func_199026_d());
                                continue;
                            }
                            values.computeIfAbsent(resourceName.func_110623_a(), id -> new BloodValueBuilder()).addFromJson(json, resource.func_199026_d());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (IOException | RuntimeException e) {
                        LOGGER.error("Couldn't read {} blood values {} from {} in datapack {}", (Object)this.name, (Object)resourceName, (Object)resourcePath, (Object)resource.func_199026_d(), (Object)e);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Couldn't read {} blood values {} from {}", (Object)this.name, (Object)resourceName, (Object)resourcePath, (Object)e);
            }
        }
        return values;
    }

    public void load(Map<String, BloodValueBuilder> values) {
        this.valueConsumer.accept(values.entrySet().stream().flatMap(a -> ((BloodValueBuilder)a.getValue()).build().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }
}

