/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.effects.FreezeEffect;
import de.teamlapen.vampirism.effects.OblivionEffect;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.effects.VampirismNightVisionPotion;
import de.teamlapen.vampirism.effects.VampirismPoisonEffect;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModEffects {
    public static final DeferredRegister<Effect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"vampirism");
    public static final RegistryObject<SanguinareEffect> SANGUINARE = EFFECTS.register("sanguinare", () -> new SanguinareEffect(EffectType.NEUTRAL, 6949000));
    public static final RegistryObject<VampirismEffect> SATURATION = EFFECTS.register("saturation", () -> new VampirismEffect(EffectType.BENEFICIAL, 14483200));
    public static final RegistryObject<VampirismEffect> SUNSCREEN = EFFECTS.register("sunscreen", () -> (VampirismEffect)new VampirismEffect(EffectType.BENEFICIAL, 0xFFF100).func_220304_a((Attribute)ModAttributes.SUNDAMAGE.get(), "9dc9420c-3e5e-41c7-9ba4-ff70e9dc69fc", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<VampirismEffect> FIRE_PROTECTION = EFFECTS.register("fire_protection", () -> new VampirismEffect(EffectType.BENEFICIAL, 14981690));
    public static final RegistryObject<VampirismEffect> DISGUISE_AS_VAMPIRE = EFFECTS.register("disguise_as_vampire", () -> new VampirismEffect(EffectType.NEUTRAL, 0x999900));
    public static final RegistryObject<VampirismEffect> GARLIC = EFFECTS.register("garlic", () -> new VampirismEffect(EffectType.HARMFUL, 0xFFFFFF));
    public static final RegistryObject<VampirismPoisonEffect> POISON = EFFECTS.register("poison", () -> new VampirismPoisonEffect(5149489));
    public static final RegistryObject<FreezeEffect> FREEZE = EFFECTS.register("freeze", FreezeEffect::new);
    public static final RegistryObject<VampirismEffect> NEONATAL = EFFECTS.register("neonatal", () -> (VampirismEffect)new VampirismEffect(EffectType.NEUTRAL, 0xFFBBBB).func_220304_a(Attributes.field_233823_f_, "377d132d-d091-43b2-8a8f-b940f9bc894c", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL).func_220304_a(Attributes.field_233821_d_, "ad6d7def-46e2-485f-afba-39252767f114", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<OblivionEffect> OBLIVION = EFFECTS.register("oblivion", () -> new OblivionEffect(EffectType.NEUTRAL, 5149489));
    public static final RegistryObject<VampirismEffect> ARMOR_REGENERATION = EFFECTS.register("armor_regeneration", () -> new VampirismEffect(EffectType.NEUTRAL, 13727298));
    public static final RegistryObject<Effect> LORD_SPEED = EFFECTS.register("lord_speed", () -> new VampirismEffect(EffectType.BENEFICIAL, 0xFFFFFF).func_220304_a(Attributes.field_233821_d_, "efe607d8-db8a-4156-b9d0-6a0640593057", 0.07f, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<Effect> LORD_ATTACK_SPEED = EFFECTS.register("lord_attack_speed", () -> new VampirismEffect(EffectType.BENEFICIAL, 0xFFFFFF).func_220304_a(Attributes.field_233825_h_, "a2ca9534-3baf-404f-b159-bc835bf963e6", 0.05f, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<BadOmenEffect> BAD_OMEN_HUNTER = EFFECTS.register("bad_omen_" + REFERENCE.HUNTER_PLAYER_KEY.func_110623_a(), () -> new BadOmenEffect(){

        @Override
        public IFaction<?> getFaction() {
            return VReference.HUNTER_FACTION;
        }
    });
    public static final RegistryObject<BadOmenEffect> BAD_OMEN_VAMPIRE = EFFECTS.register("bad_omen_" + REFERENCE.VAMPIRE_PLAYER_KEY.func_110623_a(), () -> new BadOmenEffect(){

        @Override
        public IFaction<?> getFaction() {
            return VReference.VAMPIRE_FACTION;
        }
    });
    private static final Logger LOGGER = LogManager.getLogger();
    private static Effect modded_night_vision;
    private static Effect vanilla_night_vision;

    static void replaceEffects(IForgeRegistry<Effect> registry) {
        vanilla_night_vision = Effects.field_76439_r;
        modded_night_vision = new VampirismNightVisionPotion();
        registry.register((IForgeRegistryEntry)modded_night_vision);
    }

    static void registerEffects(IEventBus bus) {
        EFFECTS.register(bus);
    }

    static void fixNightVisionEffectTypes() {
        LOGGER.info("Fixing vanilla night vision potion types");
        try {
            for (EffectInstance effect : Potions.field_185234_f.func_185170_a()) {
                if (!effect.func_188419_a().equals(vanilla_night_vision)) continue;
                ObfuscationReflectionHelper.setPrivateValue(EffectInstance.class, (Object)effect, (Object)modded_night_vision, (String)"potion");
            }
            for (EffectInstance effect : Potions.field_185235_g.func_185170_a()) {
                if (!effect.func_188419_a().equals(vanilla_night_vision)) continue;
                ObfuscationReflectionHelper.setPrivateValue(EffectInstance.class, (Object)effect, (Object)modded_night_vision, (String)"potion");
            }
        }
        catch (ObfuscationReflectionHelper.UnableToAccessFieldException e) {
            LOGGER.error("Unable to modify vanilla night vision types. Potion tileInventory and more might not work", (Throwable)e);
        }
    }

    static boolean checkNightVision() {
        if (!(Effects.field_76439_r instanceof VampirismNightVisionPotion)) {
            LOGGER.warn("Vampirism was not able to register it's night vision potion");
            return false;
        }
        return true;
    }

    public static void fixMappings(RegistryEvent.MissingMappings<Effect> event) {
        event.getAllMappings().forEach(missingMapping -> {
            switch (missingMapping.key.toString()) {
                case "vampirism:thirst": {
                    missingMapping.remap((IForgeRegistryEntry)Effects.field_76438_s);
                }
            }
        });
    }
}

