/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.entity.AreaParticleCloudEntity;
import de.teamlapen.vampirism.entity.BlindingBatEntity;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.DarkBloodProjectileEntity;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.entity.ThrowableItemEntity;
import de.teamlapen.vampirism.entity.VampirismBoatEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedCowEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedDonkeyEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedHorseEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedMuleEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedSheepEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedVillagerEntity;
import de.teamlapen.vampirism.entity.converted.SpecialConvertingHandler;
import de.teamlapen.vampirism.entity.hunter.AdvancedHunterEntity;
import de.teamlapen.vampirism.entity.hunter.AggressiveVillagerEntity;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.entity.hunter.DummyHunterTrainerEntity;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTaskMasterEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.entity.vampire.BasicVampireEntity;
import de.teamlapen.vampirism.entity.vampire.DummyBittenAnimalEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireTaskMasterEntity;
import de.teamlapen.vampirism.sit.SitEntity;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"vampirism");
    public static final RegistryObject<EntityType<BasicHunterEntity>> HUNTER = ENTITY_TYPES.register("hunter", () -> ModEntities.prepareEntityType("hunter", EntityType.Builder.func_220322_a(BasicHunterEntity::new, (EntityClassification)VReference.HUNTER_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
    public static final RegistryObject<EntityType<HunterTrainerEntity>> HUNTER_TRAINER = ENTITY_TYPES.register("hunter_trainer", () -> ModEntities.prepareEntityType("hunter_trainer", EntityType.Builder.func_220322_a(HunterTrainerEntity::new, (EntityClassification)VReference.HUNTER_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
    public static final RegistryObject<EntityType<AdvancedHunterEntity>> ADVANCED_HUNTER = ENTITY_TYPES.register("advanced_hunter", () -> ModEntities.prepareEntityType("advanced_hunter", EntityType.Builder.func_220322_a(AdvancedHunterEntity::new, (EntityClassification)VReference.HUNTER_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
    public static final RegistryObject<EntityType<VampireBaronEntity>> VAMPIRE_BARON = ENTITY_TYPES.register("vampire_baron", () -> ModEntities.prepareEntityType("vampire_baron", EntityType.Builder.func_220322_a(VampireBaronEntity::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
    public static final RegistryObject<EntityType<BasicVampireEntity>> VAMPIRE = ENTITY_TYPES.register("vampire", () -> ModEntities.prepareEntityType("vampire", EntityType.Builder.func_220322_a(BasicVampireEntity::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
    public static final RegistryObject<EntityType<AdvancedVampireEntity>> ADVANCED_VAMPIRE = ENTITY_TYPES.register("advanced_vampire", () -> ModEntities.prepareEntityType("advanced_vampire", EntityType.Builder.func_220322_a(AdvancedVampireEntity::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
    public static final RegistryObject<EntityType<ConvertedCreatureEntity>> CONVERTED_CREATURE = ENTITY_TYPES.register("converted_creature", () -> ModEntities.prepareEntityType("converted_creature", EntityType.Builder.func_220322_a(ConvertedCreatureEntity::new, (EntityClassification)EntityClassification.CREATURE), false));
    public static final RegistryObject<EntityType<DummyBittenAnimalEntity>> DUMMY_CREATURE = ENTITY_TYPES.register("dummy_creature", () -> ModEntities.prepareEntityType("dummy_creature", EntityType.Builder.func_220322_a(DummyBittenAnimalEntity::new, (EntityClassification)EntityClassification.CREATURE), true));
    public static final RegistryObject<EntityType<BlindingBatEntity>> BLINDING_BAT = ENTITY_TYPES.register("blinding_bat", () -> ModEntities.prepareEntityType("blinding_bat", EntityType.Builder.func_220322_a(BlindingBatEntity::new, (EntityClassification)EntityClassification.AMBIENT).func_220321_a(0.5f, 0.9f), true));
    public static final RegistryObject<EntityType<AdvancedHunterEntity.IMob>> ADVANCED_HUNTER_IMOB = ENTITY_TYPES.register("advanced_hunter_imob", () -> ModEntities.prepareEntityType("advanced_hunter_imob", EntityType.Builder.func_220322_a(AdvancedHunterEntity.IMob::new, (EntityClassification)VReference.HUNTER_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), false));
    public static final RegistryObject<EntityType<AdvancedVampireEntity.IMob>> ADVANCED_VAMPIRE_IMOB = ENTITY_TYPES.register("advanced_vampire_imob", () -> ModEntities.prepareEntityType("advanced_vampire_imob", EntityType.Builder.func_220322_a(AdvancedVampireEntity.IMob::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), false));
    public static final RegistryObject<EntityType<ConvertedCreatureEntity.IMob>> CONVERTED_CREATURE_IMOB = ENTITY_TYPES.register("converted_creature_imob", () -> ModEntities.prepareEntityType("converted_creature_imob", EntityType.Builder.func_220322_a(ConvertedCreatureEntity.IMob::new, (EntityClassification)EntityClassification.CREATURE), false));
    public static final RegistryObject<EntityType<ConvertedSheepEntity>> CONVERTED_SHEEP = ENTITY_TYPES.register("converted_sheep", () -> ModEntities.prepareEntityType("converted_sheep", EntityType.Builder.func_220322_a(ConvertedSheepEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 1.3f), false));
    public static final RegistryObject<EntityType<ConvertedCowEntity>> CONVERTED_COW = ENTITY_TYPES.register("converted_cow", () -> ModEntities.prepareEntityType("converted_cow", EntityType.Builder.func_220322_a(ConvertedCowEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 1.4f), false));
    public static final RegistryObject<EntityType<CrossbowArrowEntity>> CROSSBOW_ARROW = ENTITY_TYPES.register("crossbow_arrow", () -> ModEntities.prepareEntityType("crossbow_arrow", EntityType.Builder.func_220322_a(CrossbowArrowEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setCustomClientFactory((spawnEntity, world) -> new CrossbowArrowEntity((EntityType<? extends CrossbowArrowEntity>)((EntityType)CROSSBOW_ARROW.get()), (World)world)), false));
    public static final RegistryObject<EntityType<DarkBloodProjectileEntity>> DARK_BLOOD_PROJECTILE = ENTITY_TYPES.register("dark_blood_projectile", () -> ModEntities.prepareEntityType("dark_blood_projectile", EntityType.Builder.func_220322_a(DarkBloodProjectileEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 1.95f).func_220320_c().setCustomClientFactory((spawnEntity, world) -> new DarkBloodProjectileEntity((EntityType<? extends DarkBloodProjectileEntity>)((EntityType)DARK_BLOOD_PROJECTILE.get()), (World)world)), false));
    public static final RegistryObject<EntityType<DummyHunterTrainerEntity>> HUNTER_TRAINER_DUMMY = ENTITY_TYPES.register("hunter_trainer_dummy", () -> ModEntities.prepareEntityType("hunter_trainer_dummy", EntityType.Builder.func_220322_a(DummyHunterTrainerEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 1.95f), true));
    public static final RegistryObject<EntityType<AreaParticleCloudEntity>> PARTICLE_CLOUD = ENTITY_TYPES.register("particle_cloud", () -> ModEntities.prepareEntityType("particle_cloud", EntityType.Builder.func_220322_a(AreaParticleCloudEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(6.0f, 0.5f).func_220320_c().setCustomClientFactory((spawnEntity, world) -> new AreaParticleCloudEntity((EntityType<? extends AreaParticleCloudEntity>)((EntityType)PARTICLE_CLOUD.get()), (World)world)), false));
    public static final RegistryObject<EntityType<SoulOrbEntity>> SOUL_ORB = ENTITY_TYPES.register("soul_orb", () -> ModEntities.prepareEntityType("soul_orb", EntityType.Builder.func_220322_a(SoulOrbEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_220320_c().setCustomClientFactory((spawnEntity, world) -> new SoulOrbEntity((EntityType<? extends SoulOrbEntity>)((EntityType)SOUL_ORB.get()), (World)world)), false));
    public static final RegistryObject<EntityType<ThrowableItemEntity>> THROWABLE_ITEM = ENTITY_TYPES.register("throwable_item", () -> ModEntities.prepareEntityType("throwable_item", EntityType.Builder.func_220322_a(ThrowableItemEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setCustomClientFactory((spawnEntity, world) -> new ThrowableItemEntity((EntityType<? extends ThrowableItemEntity>)((EntityType)THROWABLE_ITEM.get()), (World)world)), false));
    public static final RegistryObject<EntityType<BasicVampireEntity.IMob>> VAMPIRE_IMOB = ENTITY_TYPES.register("vampire_imob", () -> ModEntities.prepareEntityType("vampire_imob", EntityType.Builder.func_220322_a(BasicVampireEntity.IMob::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), false));
    public static final RegistryObject<EntityType<BasicHunterEntity.IMob>> HUNTER_IMOB = ENTITY_TYPES.register("hunter_imob", () -> ModEntities.prepareEntityType("hunter_imob", EntityType.Builder.func_220322_a(BasicHunterEntity.IMob::new, (EntityClassification)VReference.HUNTER_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), false));
    public static final RegistryObject<EntityType<AggressiveVillagerEntity>> VILLAGER_ANGRY = ENTITY_TYPES.register("villager_angry", () -> ModEntities.prepareEntityType("villager_angry", EntityType.Builder.func_220322_a(AggressiveVillagerEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.95f), false));
    public static final RegistryObject<EntityType<ConvertedVillagerEntity>> VILLAGER_CONVERTED = ENTITY_TYPES.register("villager_converted", () -> ModEntities.prepareEntityType("villager_converted", EntityType.Builder.func_220322_a(ConvertedVillagerEntity::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
    public static final RegistryObject<EntityType<ConvertedHorseEntity>> CONVERTED_HORSE = ENTITY_TYPES.register("converted_horse", () -> ModEntities.prepareEntityType("converted_horse", EntityType.Builder.func_220322_a(ConvertedHorseEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f), true));
    public static final RegistryObject<EntityType<VampireMinionEntity>> VAMPIRE_MINION = ENTITY_TYPES.register("vampire_minion", () -> ModEntities.prepareEntityType("vampire_minion", EntityType.Builder.func_220322_a(VampireMinionEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.95f), false));
    public static final RegistryObject<EntityType<ConvertedDonkeyEntity>> CONVERTED_DONKEY = ENTITY_TYPES.register("converted_donkey", () -> ModEntities.prepareEntityType("converted_donkey", EntityType.Builder.func_220322_a(ConvertedDonkeyEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.5f), true));
    public static final RegistryObject<EntityType<ConvertedMuleEntity>> CONVERTED_MULE = ENTITY_TYPES.register("converted_mule", () -> ModEntities.prepareEntityType("converted_mule", EntityType.Builder.func_220322_a(ConvertedMuleEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.5f), true));
    public static final RegistryObject<EntityType<HunterMinionEntity>> HUNTER_MINION = ENTITY_TYPES.register("hunter_minion", () -> ModEntities.prepareEntityType("hunter_minion", EntityType.Builder.func_220322_a(HunterMinionEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.95f), false));
    public static final RegistryObject<EntityType<VampireTaskMasterEntity>> TASK_MASTER_VAMPIRE = ENTITY_TYPES.register("task_master_vampire", () -> ModEntities.prepareEntityType("task_master_vampire", EntityType.Builder.func_220322_a(VampireTaskMasterEntity::new, (EntityClassification)VReference.VAMPIRE_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
    public static final RegistryObject<EntityType<HunterTaskMasterEntity>> TASK_MASTER_HUNTER = ENTITY_TYPES.register("task_master_hunter", () -> ModEntities.prepareEntityType("task_master_hunter", EntityType.Builder.func_220322_a(HunterTaskMasterEntity::new, (EntityClassification)VReference.HUNTER_CREATURE_TYPE).func_220321_a(0.6f, 1.95f), true));
    public static final RegistryObject<EntityType<SitEntity>> DUMMY_SIT_ENTITY = ENTITY_TYPES.register("dummy_sit_entity", () -> ModEntities.prepareEntityType("dummy_sit_entity", EntityType.Builder.func_220322_a(SitEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0E-4f, 1.0E-4f).setTrackingRange(256).setUpdateInterval(20), false));
    public static final RegistryObject<EntityType<VampirismBoatEntity>> BOAT = ENTITY_TYPES.register("boat", () -> ModEntities.prepareEntityType("boat", EntityType.Builder.func_220322_a(VampirismBoatEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.375f, 0.5625f).func_233606_a_(10).setCustomClientFactory((spawnENtity, level) -> new VampirismBoatEntity((World)level, spawnENtity.getPosX(), spawnENtity.getPosY(), spawnENtity.getPosZ())), false));

    static void registerCustomExtendedCreatures() {
        IVampirismEntityRegistry registry = VampirismAPI.entityRegistry();
    }

    static void registerConvertibles() {
        Function<String, ResourceLocation> overlay = name -> new ResourceLocation("vampirism", String.format("textures/entity/vanilla/%s_overlay.png", name));
        IVampirismEntityRegistry registry = VampirismAPI.entityRegistry();
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200796_j, overlay.apply("cow"), new ConvertedCowEntity.ConvertingHandler());
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200769_I, overlay.apply("llama"));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200781_U, overlay.apply("cat"));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_220353_aa, overlay.apply("panda"));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200784_X, overlay.apply("pig"));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200786_Z, overlay.apply("polarbear"));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200736_ab, overlay.apply("rabbit"));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200737_ac, overlay.apply("sheep"), new ConvertedSheepEntity.ConvertingHandler());
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200756_av, null, new ConvertedVillagerEntity.ConvertingHandler());
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200762_B, overlay.apply("horse"), new SpecialConvertingHandler((EntityType)CONVERTED_HORSE.get()));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200798_l, overlay.apply("horse"), new SpecialConvertingHandler((EntityType)CONVERTED_DONKEY.get()));
        registry.addConvertible((EntityType<? extends CreatureEntity>)EntityType.field_200779_S, overlay.apply("horse"), new SpecialConvertingHandler((EntityType)CONVERTED_MULE.get()));
    }

    static void registerEntities(IEventBus bus) {
        ENTITY_TYPES.register(bus);
    }

    public static void initializeEntities() {
        VampireMinionEntity.init();
        HunterMinionEntity.init();
    }

    static void registerSpawns() {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ADVANCED_HUNTER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, HunterBaseEntity::spawnPredicateHunter);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)ADVANCED_VAMPIRE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VampireBaseEntity::spawnPredicateVampire);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)BLINDING_BAT.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BlindingBatEntity::spawnPredicate);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)DUMMY_CREATURE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, DummyBittenAnimalEntity::spawnPredicate);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)CONVERTED_CREATURE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ConvertedCreatureEntity::spawnPredicate);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)CONVERTED_SHEEP.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ConvertedCreatureEntity::spawnPredicate);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)CONVERTED_COW.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ConvertedCreatureEntity::spawnPredicate);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)HUNTER_TRAINER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)HUNTER_TRAINER_DUMMY.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)VAMPIRE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VampireBaseEntity::spawnPredicateVampire);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)VAMPIRE_BARON.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, VampireBaronEntity::spawnPredicateBaron);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)HUNTER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, HunterBaseEntity::spawnPredicateHunter);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)VILLAGER_ANGRY.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)VILLAGER_CONVERTED.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)CONVERTED_HORSE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ConvertedHorseEntity::checkConvertedHorseSpawnRules);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)CONVERTED_DONKEY.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ConvertedDonkeyEntity::checkConvertedDonkeySpawnRules);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)CONVERTED_MULE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ConvertedMuleEntity::checkConvertedMuleSpawnRules);
    }

    static void onRegisterEntityTypeAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ADVANCED_HUNTER.get(), AdvancedHunterEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)ADVANCED_HUNTER_IMOB.get(), AdvancedHunterEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)ADVANCED_VAMPIRE.get(), AdvancedVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)ADVANCED_VAMPIRE_IMOB.get(), AdvancedVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)BLINDING_BAT.get(), BatEntity.func_234175_m_().func_233813_a_());
        event.put((EntityType)CONVERTED_CREATURE.get(), BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)CONVERTED_CREATURE_IMOB.get(), BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)CONVERTED_HORSE.get(), ConvertedHorseEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)CONVERTED_SHEEP.get(), BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)CONVERTED_COW.get(), BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)CONVERTED_DONKEY.get(), ConvertedDonkeyEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)CONVERTED_MULE.get(), ConvertedMuleEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)DUMMY_CREATURE.get(), BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)HUNTER.get(), BasicHunterEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)HUNTER_IMOB.get(), BasicHunterEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)HUNTER_TRAINER.get(), HunterTrainerEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)HUNTER_TRAINER_DUMMY.get(), HunterTrainerEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)VAMPIRE.get(), BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)VAMPIRE_IMOB.get(), BasicVampireEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)VAMPIRE_BARON.get(), VampireBaronEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)VILLAGER_ANGRY.get(), AggressiveVillagerEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)VILLAGER_CONVERTED.get(), ConvertedVillagerEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)HUNTER_MINION.get(), HunterMinionEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)VAMPIRE_MINION.get(), VampireMinionEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)TASK_MASTER_HUNTER.get(), HunterTaskMasterEntity.getAttributeBuilder().func_233813_a_());
        event.put((EntityType)TASK_MASTER_VAMPIRE.get(), VampireTaskMasterEntity.getAttributeBuilder().func_233813_a_());
    }

    static void onModifyEntityTypeAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.field_200729_aH, (Attribute)ModAttributes.SUNDAMAGE.get());
        event.add(EntityType.field_200729_aH, (Attribute)ModAttributes.BLOOD_EXHAUSTION.get());
        event.add(EntityType.field_200729_aH, (Attribute)ModAttributes.BITE_DAMAGE.get());
    }

    private static <T extends Entity> EntityType<T> prepareEntityType(String id, EntityType.Builder<T> builder, boolean spawnable) {
        EntityType.Builder type = builder.setTrackingRange(80).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true);
        if (!spawnable) {
            type.func_200705_b();
        }
        return type.func_206830_a("vampirism:" + id);
    }

    static void fixMapping(RegistryEvent.MissingMappings<EntityType<?>> missingMappings) {
        missingMappings.getAllMappings().forEach(mapping -> {
            if (mapping.key.equals((Object)new ResourceLocation("vampirism:vampire_hunter"))) {
                mapping.remap(HUNTER.get());
            } else if (mapping.key.equals((Object)new ResourceLocation("vampirism:vampire_hunter_imob"))) {
                mapping.remap(HUNTER_IMOB.get());
            }
        });
    }

    public static Set<EntityType<?>> getAllEntities() {
        return ENTITY_TYPES.getEntries().stream().map(RegistryObject::get).collect(Collectors.toSet());
    }
}

