/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data;

import de.teamlapen.vampirism.blocks.CursedBarkBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.SignItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "vampirism", existingFileHelper);
    }

    public ItemModelBuilder block(Block name) {
        try {
            return (ItemModelBuilder)super.withExistingParent(name.getRegistryName().func_110623_a(), "vampirism:block/" + name.getRegistryName().func_110623_a());
        }
        catch (IllegalStateException e) {
            return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("vampirism:block/" + name.getRegistryName().func_110623_a()));
        }
    }

    @Nonnull
    public String func_200397_b() {
        return "Vampirism Item Models";
    }

    public ItemModelBuilder item(Item item, ResourceLocation ... texture) {
        if (texture != null && texture.length == 0) {
            return (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated")).texture("layer0", "vampirism:item/" + item.getRegistryName().func_110623_a());
        }
        return this.item(item.getRegistryName().func_110623_a(), texture);
    }

    public ItemModelBuilder item(String item, ResourceLocation ... texture) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated"));
        if (texture != null) {
            for (int i = 0; i < texture.length; ++i) {
                model.texture("layer" + i, texture[i]);
            }
        }
        return model;
    }

    @Nonnull
    public ItemModelBuilder withExistingParent(Item name, Item parent) {
        return this.withExistingParent(name, parent.getRegistryName());
    }

    @Nonnull
    public ItemModelBuilder withExistingParent(Block name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(name.getRegistryName().func_110623_a(), parent);
    }

    @Nonnull
    public ItemModelBuilder withExistingParent(Item name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(name.getRegistryName().func_110623_a(), parent);
    }

    protected void registerModels() {
        HashSet<Block> blocks = new HashSet<Block>(){
            {
                this.add(ModBlocks.ALTAR_TIP.get());
                this.add(ModBlocks.CASTLE_BLOCK_DARK_BRICK.get());
                this.add(ModBlocks.CASTLE_BLOCK_DARK_BRICK_BLOODY.get());
                this.add(ModBlocks.CASTLE_BLOCK_DARK_STONE.get());
                this.add(ModBlocks.CASTLE_BLOCK_NORMAL_BRICK.get());
                this.add(ModBlocks.CASTLE_BLOCK_PURPLE_BRICK.get());
                this.add(ModBlocks.CASTLE_SLAB_DARK_BRICK.get());
                this.add(ModBlocks.CASTLE_SLAB_DARK_STONE.get());
                this.add(ModBlocks.CASTLE_SLAB_PURPLE_BRICK.get());
                this.add(ModBlocks.CASTLE_STAIRS_DARK_BRICK.get());
                this.add(ModBlocks.CASTLE_STAIRS_DARK_STONE.get());
                this.add(ModBlocks.CASTLE_STAIRS_PURPLE_BRICK.get());
                this.add(ModBlocks.BLOOD_GRINDER.get());
                this.add(ModBlocks.BLOOD_PEDESTAL.get());
                this.add(ModBlocks.POTION_TABLE.get());
                this.add(ModBlocks.BLOOD_SIEVE.get());
                this.add(ModBlocks.CHURCH_ALTAR.get());
                this.add(ModBlocks.CURSED_EARTH.get());
                this.add(ModBlocks.GARLIC_BEACON_WEAK.get());
                this.add(ModBlocks.GARLIC_BEACON_NORMAL.get());
                this.add(ModBlocks.GARLIC_BEACON_IMPROVED.get());
                this.add(ModBlocks.SUNSCREEN_BEACON.get());
                this.add(ModBlocks.TOTEM_TOP.get());
                this.add(ModBlocks.TOTEM_TOP_VAMPIRISM_VAMPIRE.get());
                this.add(ModBlocks.TOTEM_TOP_VAMPIRISM_HUNTER.get());
                this.add(ModBlocks.VAMPIRE_ORCHID.get());
                this.add(ModBlocks.CHANDELIER.get());
                this.add(ModBlocks.CROSS.get());
                this.add(ModBlocks.TOMBSTONE1.get());
                this.add(ModBlocks.TOMBSTONE2.get());
                this.add(ModBlocks.TOMBSTONE3.get());
                this.add(ModBlocks.GRAVE_CAGE.get());
                this.add(ModBlocks.CURSED_GRASS.get());
                this.add(ModBlocks.DARK_SPRUCE_LOG.get());
                this.add(ModBlocks.CURSED_ROOTS.get());
                this.add(ModBlocks.CURSED_SPRUCE_LOG.get());
                this.add(ModBlocks.STRIPPED_DARK_SPRUCE_LOG.get());
                this.add(ModBlocks.STRIPPED_CURSED_SPRUCE_LOG.get());
                this.add(ModBlocks.DARK_SPRUCE_PLANKS.get());
                this.add(ModBlocks.CURSED_SPRUCE_PLANKS.get());
                this.add(ModBlocks.DARK_SPRUCE_STAIRS.get());
                this.add(ModBlocks.CURSED_SPRUCE_STAIRS.get());
                this.add(ModBlocks.DARK_SPRUCE_WOOD.get());
                this.add(ModBlocks.CURSED_SPRUCE_WOOD.get());
                this.add(ModBlocks.STRIPPED_DARK_SPRUCE_WOOD.get());
                this.add(ModBlocks.STRIPPED_CURSED_SPRUCE_WOOD.get());
                this.add(ModBlocks.DARK_SPRUCE_PRESSURE_PLACE.get());
                this.add(ModBlocks.CURSED_SPRUCE_PRESSURE_PLACE.get());
                this.add(ModBlocks.DARK_SPRUCE_BUTTON.get());
                this.add(ModBlocks.CURSED_SPRUCE_BUTTON.get());
                this.add(ModBlocks.DARK_SPRUCE_SLAB.get());
                this.add(ModBlocks.CURSED_SPRUCE_SLAB.get());
                this.add(ModBlocks.DARK_SPRUCE_FENCE_GATE.get());
                this.add(ModBlocks.CURSED_SPRUCE_FENCE_GATE.get());
                this.add(ModBlocks.VAMPIRE_RACK.get());
                this.add(ModBlocks.THRONE.get());
            }
        };
        HashSet<Item> items = new HashSet<Item>(){
            {
                this.add(ModItems.HUNTER_COAT_CHEST_NORMAL.get());
                this.add(ModItems.HUNTER_COAT_CHEST_ENHANCED.get());
                this.add(ModItems.HUNTER_COAT_CHEST_ULTIMATE.get());
                this.add(ModItems.HUNTER_COAT_FEET_NORMAL.get());
                this.add(ModItems.HUNTER_COAT_FEET_ENHANCED.get());
                this.add(ModItems.HUNTER_COAT_FEET_ULTIMATE.get());
                this.add(ModItems.HUNTER_COAT_HEAD_NORMAL.get());
                this.add(ModItems.HUNTER_COAT_HEAD_ENHANCED.get());
                this.add(ModItems.HUNTER_COAT_HEAD_ULTIMATE.get());
                this.add(ModItems.HUNTER_COAT_LEGS_NORMAL.get());
                this.add(ModItems.HUNTER_COAT_LEGS_ENHANCED.get());
                this.add(ModItems.HUNTER_COAT_LEGS_ULTIMATE.get());
                this.add(ModItems.BLOOD_BUCKET.get());
                this.add(ModItems.IMPURE_BLOOD_BUCKET.get());
                this.add(ModItems.BLOOD_INFUSED_ENHANCED_IRON_INGOT.get());
                this.add(ModItems.BLOOD_INFUSED_IRON_INGOT.get());
                this.add(ModItems.PURE_SALT.get());
                this.add(ModItems.PURE_SALT_WATER.get());
                this.add(ModItems.HUMAN_HEART.get());
                this.add(ModItems.INJECTION_EMPTY.get());
                this.add(ModItems.INJECTION_GARLIC.get());
                this.add(ModItems.INJECTION_SANGUINARE.get());
                this.add(ModItems.PURIFIED_GARLIC.get());
                this.add(ModItems.SOUL_ORB_VAMPIRE.get());
                this.add(ModItems.TECH_CROSSBOW_AMMO_PACKAGE.get());
                this.add(ModItems.VAMPIRE_BLOOD_BOTTLE.get());
                this.add(ModItems.VAMPIRE_CLOAK_BLACK_BLUE.get());
                this.add(ModItems.VAMPIRE_CLOAK_BLACK_RED.get());
                this.add(ModItems.VAMPIRE_CLOAK_BLACK_WHITE.get());
                this.add(ModItems.VAMPIRE_CLOAK_WHITE_BLACK.get());
                this.add(ModItems.VAMPIRE_CLOAK_RED_BLACK.get());
                this.add(ModItems.VAMPIRE_FANG.get());
                this.add(ModItems.WEAK_HUMAN_HEART.get());
                this.add(ModItems.ITEM_TENT.get());
                this.add(ModItems.PURE_BLOOD_0.get());
                this.add(ModItems.PURE_BLOOD_1.get());
                this.add(ModItems.PURE_BLOOD_2.get());
                this.add(ModItems.PURE_BLOOD_3.get());
                this.add(ModItems.PURE_BLOOD_4.get());
                this.add(ModItems.VAMPIRE_MINION_BINDING.get());
                this.add(ModItems.VAMPIRE_MINION_UPGRADE_SIMPLE.get());
                this.add(ModItems.VAMPIRE_MINION_UPGRADE_ENHANCED.get());
                this.add(ModItems.VAMPIRE_MINION_UPGRADE_SPECIAL.get());
                this.add(ModItems.HUNTER_MINION_EQUIPMENT.get());
                this.add(ModItems.HUNTER_MINION_UPGRADE_SIMPLE.get());
                this.add(ModItems.HUNTER_MINION_UPGRADE_ENHANCED.get());
                this.add(ModItems.HUNTER_MINION_UPGRADE_SPECIAL.get());
                this.add(ModItems.OBLIVION_POTION.get());
                this.add(ModItems.VAMPIRE_CLOTHING_HAT.get());
                this.add(ModItems.VAMPIRE_CLOTHING_BOOTS.get());
                this.add(ModItems.VAMPIRE_CLOTHING_LEGS.get());
                this.add(ModItems.VAMPIRE_CLOTHING_CROWN.get());
                this.add(ModItems.GARLIC_FINDER.get());
                this.add(ModItems.DARK_SPRUCE_BOAT.get());
                this.add(ModItems.CURSED_SPRUCE_BOAT.get());
            }
        };
        HashMap<Item, ResourceLocation> itemsWithTexture = new HashMap<Item, ResourceLocation>(){
            {
                this.put(ModItems.HOLY_WATER_BOTTLE_NORMAL.get(), ItemModelGenerator.this.modLoc("item/holy_water_normal"));
                this.put(ModItems.HOLY_WATER_BOTTLE_ENHANCED.get(), ItemModelGenerator.this.modLoc("item/holy_water_enhanced"));
                this.put(ModItems.HOLY_WATER_BOTTLE_ULTIMATE.get(), ItemModelGenerator.this.modLoc("item/holy_water_ultimate"));
                this.put(ModItems.HOLY_WATER_SPLASH_BOTTLE_NORMAL.get(), ItemModelGenerator.this.modLoc("item/holy_water_splash_normal"));
                this.put(ModItems.HOLY_WATER_SPLASH_BOTTLE_ENHANCED.get(), ItemModelGenerator.this.modLoc("item/holy_water_splash_enhanced"));
                this.put(ModItems.HOLY_WATER_SPLASH_BOTTLE_ULTIMATE.get(), ItemModelGenerator.this.modLoc("item/holy_water_splash_ultimate"));
                this.put(ModItems.GARLIC_BREAD.get(), ItemModelGenerator.this.modLoc("item/garlic_bread"));
                this.put(ModItems.HUNTER_HAT_HEAD_0.get(), ItemModelGenerator.this.modLoc("item/hunter_hat_0"));
                this.put(ModItems.HUNTER_HAT_HEAD_1.get(), ItemModelGenerator.this.modLoc("item/hunter_hat_1"));
                this.put(ModItems.ITEM_ALCHEMICAL_FIRE.get(), ItemModelGenerator.this.modLoc("item/alchemical_fire"));
                this.put(ModItems.ITEM_GARLIC.get(), ItemModelGenerator.this.modLoc("item/garlic"));
                this.put(ModItems.ITEM_TENT_SPAWNER.get(), ItemModelGenerator.this.modLoc("item/item_tent"));
                this.put(ModItems.VAMPIRE_BOOK.get(), ItemModelGenerator.this.modLoc("item/vampire_book"));
                this.put(Item.func_150898_a((Block)((Block)ModBlocks.MED_CHAIR.get())), ItemModelGenerator.this.modLoc("item/med_chair"));
                this.put(((CursedBarkBlock)ModBlocks.CURSED_BARK.get()).func_199767_j(), ItemModelGenerator.this.modLoc("block/" + ((CursedBarkBlock)ModBlocks.CURSED_BARK.get()).getRegistryName().func_110623_a()));
                this.put(ModItems.DARK_SPRUCE_SIGN.get(), ItemModelGenerator.this.modLoc("item/" + ((SignItem)ModItems.DARK_SPRUCE_SIGN.get()).getRegistryName().func_110623_a()));
                this.put(ModItems.CURSED_SPRUCE_SIGN.get(), ItemModelGenerator.this.modLoc("item/" + ((SignItem)ModItems.CURSED_SPRUCE_SIGN.get()).getRegistryName().func_110623_a()));
            }
        };
        blocks.forEach(this::block);
        items.forEach(x$0 -> this.item((Item)x$0, new ResourceLocation[0]));
        itemsWithTexture.forEach((x$0, xva$1) -> this.item((Item)x$0, (ResourceLocation)xva$1));
        this.withExistingParent((Block)ModBlocks.DARK_SPRUCE_LEAVES.get(), this.mcLoc("block/oak_leaves"));
        this.withExistingParent((Block)ModBlocks.DARK_SPRUCE_SAPLING.get(), this.mcLoc("item/generated")).texture("layer0", "vampirism:block/" + ((SaplingBlock)ModBlocks.DARK_SPRUCE_SAPLING.get()).getRegistryName().func_110623_a());
        this.withExistingParent((Block)ModBlocks.CURSED_SPRUCE_SAPLING.get(), this.mcLoc("item/generated")).texture("layer0", "vampirism:block/" + ((SaplingBlock)ModBlocks.CURSED_SPRUCE_SAPLING.get()).getRegistryName().func_110623_a());
        this.withExistingParent((Block)ModBlocks.ALCHEMICAL_FIRE.get(), this.modLoc("block/fire_side"));
        this.withExistingParent((Block)ModBlocks.ALTAR_INSPIRATION.get(), this.modLoc("block/altar_inspiration/altar_inspiration"));
        this.item("crossbow_arrow", this.modLoc("item/crossbow_arrow"), this.modLoc("item/crossbow_arrow_tip"));
        this.withExistingParent((Item)ModItems.CROSSBOW_ARROW_NORMAL.get(), this.modLoc("item/crossbow_arrow"));
        this.withExistingParent((Item)ModItems.CROSSBOW_ARROW_SPITFIRE.get(), this.modLoc("item/crossbow_arrow"));
        this.withExistingParent((Item)ModItems.CROSSBOW_ARROW_VAMPIRE_KILLER.get(), this.modLoc("item/crossbow_arrow"));
        this.withExistingParent((Item)ModItems.CROSSBOW_ARROW_TELEPORT.get(), this.modLoc("item/crossbow_arrow"));
        this.item((Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_NORMAL.get(), this.modLoc("item/armor_of_swiftness_chest_normal"), this.modLoc("item/armor_of_swiftness_chest_normal_overlay"));
        this.item((Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ENHANCED.get(), this.modLoc("item/armor_of_swiftness_chest_enhanced"), this.modLoc("item/armor_of_swiftness_chest_enhanced_overlay"));
        this.item((Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get(), this.modLoc("item/armor_of_swiftness_chest_ultimate"), this.modLoc("item/armor_of_swiftness_chest_ultimate_overlay"));
        this.item((Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_NORMAL.get(), this.modLoc("item/armor_of_swiftness_feet_normal"), this.modLoc("item/armor_of_swiftness_feet_normal_overlay"));
        this.item((Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_ENHANCED.get(), this.modLoc("item/armor_of_swiftness_feet_enhanced"), this.modLoc("item/armor_of_swiftness_feet_enhanced_overlay"));
        this.item((Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get(), this.modLoc("item/armor_of_swiftness_feet_ultimate"), this.modLoc("item/armor_of_swiftness_feet_ultimate_overlay"));
        this.item((Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_NORMAL.get(), this.modLoc("item/armor_of_swiftness_head_normal"), this.modLoc("item/armor_of_swiftness_head_normal_overlay"));
        this.item((Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ENHANCED.get(), this.modLoc("item/armor_of_swiftness_head_enhanced"), this.modLoc("item/armor_of_swiftness_head_enhanced_overlay"));
        this.item((Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get(), this.modLoc("item/armor_of_swiftness_head_ultimate"), this.modLoc("item/armor_of_swiftness_head_ultimate_overlay"));
        this.item((Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_NORMAL.get(), this.modLoc("item/armor_of_swiftness_legs_normal"), this.modLoc("item/armor_of_swiftness_legs_normal_overlay"));
        this.item((Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ENHANCED.get(), this.modLoc("item/armor_of_swiftness_legs_enhanced"), this.modLoc("item/armor_of_swiftness_legs_enhanced_overlay"));
        this.item((Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get(), this.modLoc("item/armor_of_swiftness_legs_ultimate"), this.modLoc("item/armor_of_swiftness_legs_ultimate_overlay"));
        this.withExistingParent((Item)ModItems.ADVANCED_VAMPIRE_HUNTER_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.ADVANCED_VAMPIRE_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.HUNTER_TRAINER_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.VAMPIRE_BARON_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.VAMPIRE_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.VAMPIRE_HUNTER_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent((Item)ModItems.BASIC_CROSSBOW.get(), this.modLoc("item/crossbow")).texture("texture", "item/crossbow")).texture("string", "item/crossbow_part_string")).texture("arrow", "item/crossbow_part_arrow")).override().predicate(this.modLoc("charged"), 0.01f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("basic_crossbow_unloaded", this.modLoc("item/crossbow_unloaded"))).texture("texture", "item/crossbow")).texture("string", "item/crossbow_part_string_unloaded"));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent((Item)ModItems.BASIC_DOUBLE_CROSSBOW.get(), this.modLoc("item/double_crossbow")).texture("texture", "item/crossbow_double")).texture("string", "item/crossbow_part_double_string")).texture("arrows", "item/crossbow_part_arrows")).override().predicate(this.modLoc("charged"), 0.01f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("basic_double_crossbow_unloaded", this.modLoc("item/double_crossbow_unloaded"))).texture("texture", "item/crossbow_double")).texture("string", "item/crossbow_part_double_string_unloaded"));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent((Item)ModItems.BASIC_TECH_CROSSBOW.get(), this.modLoc("item/tech_crossbow")).texture("texture", "item/tech_crossbow")).texture("string", "item/crossbow_part_tech_string")).override().predicate(this.modLoc("charged"), 0.01f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("basic_tech_crossbow_unloaded", this.modLoc("item/tech_crossbow_unloaded"))).texture("texture", "item/tech_crossbow")).texture("string", "item/crossbow_part_tech_string_unloaded"));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent((Item)ModItems.ENHANCED_CROSSBOW.get(), this.modLoc("item/crossbow")).texture("texture", "item/crossbow_enhanced")).texture("string", "item/crossbow_part_string")).texture("arrow", "item/crossbow_part_arrow")).override().predicate(this.modLoc("charged"), 0.01f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("enhanced_crossbow_unloaded", this.modLoc("item/crossbow_unloaded"))).texture("texture", "item/crossbow_enhanced")).texture("string", "item/crossbow_part_string_unloaded"));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent((Item)ModItems.ENHANCED_DOUBLE_CROSSBOW.get(), this.modLoc("item/double_crossbow")).texture("texture", "item/crossbow_double_enhanced")).texture("string", "item/crossbow_part_double_string")).texture("arrows", "item/crossbow_part_arrows")).override().predicate(this.modLoc("charged"), 0.01f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("enhanced_double_crossbow_unloaded", this.modLoc("item/double_crossbow_unloaded"))).texture("texture", "item/crossbow_double_enhanced")).texture("string", "item/crossbow_part_double_string_unloaded"));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent((Item)ModItems.ENHANCED_TECH_CROSSBOW.get(), this.modLoc("item/tech_crossbow")).texture("texture", "item/tech_crossbow_enhanced")).texture("string", "item/crossbow_part_tech_string")).override().predicate(this.modLoc("charged"), 0.01f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("enhanced_tech_crossbow_unloaded", this.modLoc("item/tech_crossbow_unloaded"))).texture("texture", "item/tech_crossbow_enhanced")).texture("string", "item/crossbow_part_tech_string_unloaded"));
        this.withExistingParent((Item)ModItems.GARLIC_BEACON_CORE_IMPROVED.get(), (Item)ModItems.GARLIC_BEACON_CORE.get()).texture("texture", "block/garlic_beacon_inside_improved");
        this.withExistingParent((Item)ModItems.HEART_SEEKER_NORMAL.get(), this.modLoc("item/heart_seeker_model"));
        this.withExistingParent((Item)ModItems.HEART_SEEKER_ENHANCED.get(), this.modLoc("item/heart_seeker_model")).texture("3", "item/heart_seeker_enhanced");
        this.withExistingParent((Item)ModItems.HEART_SEEKER_ULTIMATE.get(), this.modLoc("item/heart_seeker_model")).texture("3", "item/heart_seeker_ultimate");
        this.withExistingParent((Item)ModItems.HEART_STRIKER_NORMAL.get(), this.modLoc("item/heart_striker_model"));
        this.withExistingParent((Item)ModItems.HEART_STRIKER_ENHANCED.get(), this.modLoc("item/heart_striker_model")).texture("2", "item/heart_striker_enhanced");
        this.withExistingParent((Item)ModItems.HEART_STRIKER_ULTIMATE.get(), this.modLoc("item/heart_striker_model")).texture("2", "item/heart_striker_ultimate");
        this.withExistingParent((Item)ModItems.HUNTER_AXE_NORMAL.get(), this.modLoc("item/hunter_axe"));
        this.withExistingParent((Item)ModItems.HUNTER_AXE_ENHANCED.get(), this.modLoc("item/hunter_axe")).texture("texture", "item/hunter_axe_enhanced");
        this.withExistingParent((Item)ModItems.HUNTER_AXE_ULTIMATE.get(), this.modLoc("item/hunter_axe")).texture("texture", "item/hunter_axe_ultimate");
        this.withExistingParent((Item)ModItems.HUNTER_INTEL_0.get(), this.modLoc("item/hunter_intel"));
        this.withExistingParent((Item)ModItems.HUNTER_INTEL_1.get(), this.modLoc("item/hunter_intel"));
        this.withExistingParent((Item)ModItems.HUNTER_INTEL_2.get(), this.modLoc("item/hunter_intel"));
        this.withExistingParent((Item)ModItems.HUNTER_INTEL_3.get(), this.modLoc("item/hunter_intel"));
        this.withExistingParent((Item)ModItems.HUNTER_INTEL_4.get(), this.modLoc("item/hunter_intel"));
        this.withExistingParent((Item)ModItems.HUNTER_INTEL_5.get(), this.modLoc("item/hunter_intel"));
        this.withExistingParent((Item)ModItems.HUNTER_INTEL_6.get(), this.modLoc("item/hunter_intel"));
        this.withExistingParent((Item)ModItems.HUNTER_INTEL_7.get(), this.modLoc("item/hunter_intel"));
        this.withExistingParent((Item)ModItems.HUNTER_INTEL_8.get(), this.modLoc("item/hunter_intel"));
        this.withExistingParent((Item)ModItems.HUNTER_INTEL_9.get(), this.modLoc("item/hunter_intel"));
        this.item((Item)ModItems.RING.get(), this.modLoc("item/vampire_ring_layer0"), this.modLoc("item/vampire_ring_layer1"));
        this.item((Item)ModItems.AMULET.get(), this.modLoc("item/vampire_amulet_layer0"), this.modLoc("item/vampire_amulet_layer1"));
        this.item((Item)ModItems.OBI_BELT.get(), this.modLoc("item/vampire_obi_belt_layer0"), this.modLoc("item/vampire_obi_belt_layer1"));
        this.withExistingParent((Item)ModItems.ITEM_CANDELABRA.get(), this.modLoc("block/candelabra"));
        this.withExistingParent((Item)ModItems.CRUCIFIX_NORMAL.get(), this.modLoc("item/crucifix")).texture("texture", "item/crucifix_wooden");
        this.withExistingParent((Item)ModItems.CRUCIFIX_ENHANCED.get(), this.modLoc("item/crucifix")).texture("texture", "item/crucifix_iron");
        this.withExistingParent((Item)ModItems.CRUCIFIX_ULTIMATE.get(), this.modLoc("item/crucifix")).texture("texture", "item/crucifix_gold");
        ((ItemModelBuilder)this.singleTexture("blood_bottle", this.mcLoc("item/generated"), "layer0", this.modLoc("item/blood_bottle_0"))).override().predicate(this.mcLoc("damage"), 0.0f).model((ModelFile)((ItemModelBuilder)this.withExistingParent("blood_bottle_0", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/blood_bottle_0"))).end().override().predicate(this.mcLoc("damage"), 0.11f).model((ModelFile)((ItemModelBuilder)this.withExistingParent("blood_bottle_1", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/blood_bottle_1"))).end().override().predicate(this.mcLoc("damage"), 0.22f).model((ModelFile)((ItemModelBuilder)this.withExistingParent("blood_bottle_2", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/blood_bottle_2"))).end().override().predicate(this.mcLoc("damage"), 0.33f).model((ModelFile)((ItemModelBuilder)this.withExistingParent("blood_bottle_3", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/blood_bottle_3"))).end().override().predicate(this.mcLoc("damage"), 0.44f).model((ModelFile)((ItemModelBuilder)this.withExistingParent("blood_bottle_4", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/blood_bottle_4"))).end().override().predicate(this.mcLoc("damage"), 0.55f).model((ModelFile)((ItemModelBuilder)this.withExistingParent("blood_bottle_5", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/blood_bottle_5"))).end().override().predicate(this.mcLoc("damage"), 0.66f).model((ModelFile)((ItemModelBuilder)this.withExistingParent("blood_bottle_6", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/blood_bottle_6"))).end().override().predicate(this.mcLoc("damage"), 0.77f).model((ModelFile)((ItemModelBuilder)this.withExistingParent("blood_bottle_7", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/blood_bottle_7"))).end().override().predicate(this.mcLoc("damage"), 0.88f).model((ModelFile)((ItemModelBuilder)this.withExistingParent("blood_bottle_8", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/blood_bottle_8"))).end().override().predicate(this.mcLoc("damage"), 0.99f).model((ModelFile)((ItemModelBuilder)this.withExistingParent("blood_bottle_9", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/blood_bottle_9"))).end();
        this.withExistingParent((Block)ModBlocks.DARK_SPRUCE_TRAPDOOR.get(), this.modLoc("block/dark_spruce_trapdoor_bottom"));
        this.withExistingParent((Block)ModBlocks.CURSED_SPRUCE_TRAPDOOR.get(), this.modLoc("block/cursed_spruce_trapdoor_bottom"));
        this.item(((DoorBlock)ModBlocks.DARK_SPRUCE_DOOR.get()).func_199767_j(), this.modLoc("item/dark_spruce_door"));
        this.item(((DoorBlock)ModBlocks.CURSED_SPRUCE_DOOR.get()).func_199767_j(), this.modLoc("item/cursed_spruce_door"));
        this.withExistingParent(((WoodButtonBlock)ModBlocks.DARK_SPRUCE_BUTTON.get()).func_199767_j(), this.modLoc("block/dark_spruce_button_inventory"));
        this.withExistingParent(((WoodButtonBlock)ModBlocks.CURSED_SPRUCE_BUTTON.get()).func_199767_j(), this.modLoc("block/cursed_spruce_button_inventory"));
        this.withExistingParent(((FenceBlock)ModBlocks.DARK_SPRUCE_FENCE.get()).func_199767_j(), this.modLoc("block/dark_spruce_fence_inventory"));
        this.withExistingParent(((FenceBlock)ModBlocks.CURSED_SPRUCE_FENCE.get()).func_199767_j(), this.modLoc("block/cursed_spruce_fence_inventory"));
        this.withExistingParent((Block)ModBlocks.HUNTER_TABLE.get(), this.modLoc("block/hunter_table/hunter_table"));
        for (DyeColor dye : DyeColor.values()) {
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("coffin_" + dye.func_176762_d())).parent((ModelFile)new ModelFile.UncheckedModelFile("vampirism:block/coffin/coffin_bottom_" + dye.func_176762_d()))).transforms().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(30.0f, 160.0f, 0.0f).translation(-1.0f, 0.0f, 1.0f).scale(0.23f, 0.23f, 0.23f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(30.0f, 160.0f, 0.0f).translation(0.0f, 0.0f, 3.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ModelBuilder.Perspective.GUI).rotation(30.0f, 160.0f, 0.0f).translation(-1.0f, -1.0f, -4.0f).scale(0.5325f, 0.5325f, 0.5325f).end().transform(ModelBuilder.Perspective.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 2.0f, -2.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ModelBuilder.Perspective.HEAD).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 2.0f, -8.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ModelBuilder.Perspective.FIXED).rotation(270.0f, 0.0f, 0.0f).translation(0.0f, -4.0f, -4.0f).scale(0.5f, 0.5f, 0.5f).end().end();
        }
        this.item((Item)ModItems.OIL_BOTTLE.get(), this.modLoc("item/oil_bottle"), this.modLoc("item/oil_bottle_overlay"));
        this.withExistingParent((Block)ModBlocks.ALCHEMY_TABLE.get(), this.modLoc("block/alchemy_table/alchemy_table"));
    }
}

