/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModOils;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.items.OilBottle;
import de.teamlapen.vampirism.util.NBTIngredient;
import de.teamlapen.vampirism.util.OilUtils;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
public class AlchemyTableRecipeBuilder {
    private final ItemStack result;
    private final IOil resultOil;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private String group;
    private Ingredient ingredient;
    private IOil ingredientOil = (IOil)ModOils.EMPTY.get();
    private Ingredient input;
    private ISkill[] skills;

    public static AlchemyTableRecipeBuilder builder(ItemStack stack) {
        return new AlchemyTableRecipeBuilder(stack);
    }

    public static AlchemyTableRecipeBuilder builder(IOil oilStack) {
        return new AlchemyTableRecipeBuilder(OilUtils.createOilItem(oilStack));
    }

    public static AlchemyTableRecipeBuilder builder(Supplier<? extends IOil> oilStack) {
        return AlchemyTableRecipeBuilder.builder(oilStack.get());
    }

    public AlchemyTableRecipeBuilder(ItemStack result) {
        this(result, OilUtils.getOil(result));
    }

    public AlchemyTableRecipeBuilder(ItemStack result, IOil resultOil) {
        Objects.requireNonNull(result);
        Objects.requireNonNull(resultOil);
        this.result = result;
        this.resultOil = resultOil;
    }

    public AlchemyTableRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public AlchemyTableRecipeBuilder ingredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public AlchemyTableRecipeBuilder oilIngredient(IOil oil) {
        this.ingredient = new NBTIngredient(((OilBottle)ModItems.OIL_BOTTLE.get()).withOil(oil));
        return this;
    }

    public AlchemyTableRecipeBuilder plantOilIngredient() {
        return this.ingredient(new NBTIngredient(((OilBottle)ModItems.OIL_BOTTLE.get()).withOil((IOil)ModOils.PLANT.get()))).withCriterion("has_bottles", (ICriterionInstance)AlchemyTableRecipeBuilder.has((IItemProvider)ModItems.OIL_BOTTLE.get()));
    }

    public AlchemyTableRecipeBuilder bloodOilIngredient() {
        return this.ingredient(new NBTIngredient(((OilBottle)ModItems.OIL_BOTTLE.get()).withOil((IOil)ModOils.VAMPIRE_BLOOD.get()))).withCriterion("has_bottles", (ICriterionInstance)AlchemyTableRecipeBuilder.has((IItemProvider)ModItems.OIL_BOTTLE.get()));
    }

    public AlchemyTableRecipeBuilder input(Ingredient input) {
        this.input = input;
        return this;
    }

    public AlchemyTableRecipeBuilder withCriterion(String name, ICriterionInstance criterion) {
        this.advancementBuilder.func_200275_a(name, criterion);
        return this;
    }

    public AlchemyTableRecipeBuilder withSkills(ISkill ... skills) {
        this.skills = skills;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        id = new ResourceLocation(id.func_110624_b(), "alchemy_table/" + id.func_110623_a());
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(new Result(id, this.group != null ? this.group : "", this.ingredient, this.ingredientOil, this.input, this.result, this.resultOil, this.skills != null ? this.skills : new ISkill[]{}, new ResourceLocation(id.func_110624_b(), "recipes/" + this.result.func_77973_b().func_77640_w().func_200300_c() + "/" + id.func_110623_a()), this.advancementBuilder));
    }

    private void validate(ResourceLocation id) {
        if (this.ingredient == null) {
            throw new IllegalStateException("No ingredients defined for alchemical table recipe " + id + "!");
        }
        if (this.input == null) {
            throw new IllegalStateException("No input defined for alchemical table recipe " + id + "!");
        }
    }

    protected static InventoryChangeTrigger.Instance has(IItemProvider p_200403_0_) {
        return AlchemyTableRecipeBuilder.inventoryTrigger(ItemPredicate.Builder.func_200309_a().func_200308_a(p_200403_0_).func_200310_b());
    }

    protected static InventoryChangeTrigger.Instance has(ITag<Item> p_200409_0_) {
        return AlchemyTableRecipeBuilder.inventoryTrigger(ItemPredicate.Builder.func_200309_a().func_200307_a(p_200409_0_).func_200310_b());
    }

    protected static InventoryChangeTrigger.Instance inventoryTrigger(ItemPredicate ... p_200405_0_) {
        return new InventoryChangeTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, p_200405_0_);
    }

    private static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final ItemStack result;
        private final IOil resultOil;
        private final Advancement.Builder advancementBuilder;
        private final String group;
        private final Ingredient ingredient;
        private final IOil ingredientOil;
        private final Ingredient input;
        private final ISkill[] skills;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, String group, Ingredient ingredient, IOil ingredientOil, Ingredient input, ItemStack result, IOil resultOil, ISkill[] skills, ResourceLocation advancementId, Advancement.Builder advancementBuilder) {
            this.id = id;
            this.result = result;
            this.resultOil = resultOil;
            this.group = group;
            this.ingredient = ingredient;
            this.ingredientOil = ingredientOil;
            this.input = input;
            this.skills = skills;
            this.advancementId = advancementId;
            this.advancementBuilder = advancementBuilder;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)ModRecipes.ALCHEMICAL_TABLE.get();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("result", (JsonElement)this.item(this.result));
            json.add("ingredient", this.ingredient.func_200304_c());
            json.add("input", this.input.func_200304_c());
            JsonArray skills = new JsonArray();
            for (ISkill skill : this.skills) {
                skills.add(skill.getRegistryName().toString());
            }
            json.add("skill", (JsonElement)skills);
        }

        private JsonObject item(ItemStack stack) {
            JsonObject obj = new JsonObject();
            obj.addProperty("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_190916_E() > 1) {
                obj.addProperty("count", (Number)stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                obj.add("nbt", (JsonElement)new JsonParser().parse(stack.func_77978_p().toString()).getAsJsonObject());
            }
            return obj;
        }
    }
}

