/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class BlindingBatEntity
extends BatEntity {
    private final EntityPredicate nonVampirePredicatePlayer = new EntityPredicate().func_221012_a(VampirismAPI.factionRegistry().getPredicate(VReference.VAMPIRE_FACTION, true).and(EntityPredicates.field_188444_d));
    private final EntityPredicate nonVampirePredicate = new EntityPredicate().func_221012_a(e -> !Helper.isVampire((Entity)e));
    private boolean restrictLiveSpan;
    private boolean targeting;
    private boolean targetingMob = false;

    public static boolean spawnPredicate(EntityType<? extends BlindingBatEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        if (((Biome)ModBiomes.VAMPIRE_FOREST.get()).getRegistryName().equals((Object)Helper.getBiomeId((IBiomeReader)iWorld, blockPos)) || ((Biome)ModBiomes.VAMPIRE_FOREST_HILLS.get()).getRegistryName().equals((Object)Helper.getBiomeId((IBiomeReader)iWorld, blockPos))) {
            return true;
        }
        if (blockPos.func_177956_o() >= iWorld.func_181545_F()) {
            return false;
        }
        int i = iWorld.func_201696_r(blockPos);
        int j = 4;
        if (random.nextBoolean()) {
            return false;
        }
        return i <= random.nextInt(j) && BlindingBatEntity.func_223315_a(entityType, (IWorld)iWorld, (SpawnReason)spawnReason, (BlockPos)blockPos, (Random)random);
    }

    public BlindingBatEntity(EntityType<? extends BlindingBatEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return worldIn.func_195585_a((Entity)this, VoxelShapes.func_197881_a((AxisAlignedBB)this.func_174813_aQ())) && worldIn.func_226668_i_((Entity)this) && !worldIn.func_72953_d(this.func_174813_aQ());
    }

    public void restrictLiveSpan() {
        this.restrictLiveSpan = true;
    }

    public void setTargeting() {
        this.targeting = true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.restrictLiveSpan && this.field_70173_aa > BalanceMobProps.mobProps.BLINDING_BAT_LIVE_SPAWN) {
            this.func_70097_a(DamageSource.field_76376_m, 10.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            List l = this.field_70170_p.func_217357_a(this.targetingMob ? MonsterEntity.class : PlayerEntity.class, this.func_174813_aQ());
            boolean hit = false;
            for (LivingEntity e : l) {
                if (!e.func_70089_S() || Helper.isVampire((Entity)e)) continue;
                e.func_195064_c(new EffectInstance(Effects.field_76440_q, BalanceMobProps.mobProps.BLINDING_BAT_EFFECT_DURATION));
                hit = true;
            }
            if (this.targeting && hit) {
                this.func_70097_a(DamageSource.field_76377_j, 1000.0f);
            }
        }
    }

    protected void func_70619_bc() {
        boolean t = false;
        if (this.targeting && this.field_70173_aa > 40) {
            Vector3d diff;
            double dist;
            this.targetingMob = false;
            PlayerEntity e = this.field_70170_p.func_217370_a(this.nonVampirePredicatePlayer, (LivingEntity)this);
            if (e == null) {
                e = this.field_70170_p.func_217360_a(MonsterEntity.class, this.nonVampirePredicate, null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_174813_aQ().func_186662_g(20.0));
                this.targetingMob = true;
            }
            if (e != null && (dist = (diff = e.func_213303_ch().func_72441_c(0.0, (double)e.func_70047_e(), 0.0).func_178788_d(this.func_213303_ch())).func_72433_c()) < 20.0) {
                Vector3d mov = diff.func_186678_a(0.15 / dist);
                this.func_213317_d(mov);
                float f = (float)(MathHelper.func_181159_b((double)mov.field_72449_c, (double)mov.field_72450_a) * 57.2957763671875) - 90.0f;
                float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
                this.field_191988_bg = 0.5f;
                this.field_70177_z += f1;
                t = true;
            }
        }
        if (!t) {
            super.func_70619_bc();
        }
    }
}

