/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.action;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.IEntityAction;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionManager;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.ArrayUtils;

public class ActionManagerEntity
implements IEntityActionManager {
    @Override
    public List<IEntityAction> getAllEntityActions() {
        return Lists.newArrayList((Iterable)ModRegistries.ENTITYACTIONS.getValues());
    }

    @Override
    public List<IEntityAction> getAllEntityActionsByTierAndClassType(IFaction faction, @Nonnull EntityActionTier tier, EntityClassType classtype) {
        ArrayList actions = Lists.newArrayList((Iterable)ModRegistries.ENTITYACTIONS.getValues());
        actions.removeIf(action -> action.getFaction() != faction || action.getTier().getId() > tier.getId() || !ArrayUtils.contains((Object[])action.getClassTypes(), (Object)((Object)classtype)));
        return actions;
    }

    @Override
    public IForgeRegistry<IEntityAction> getRegistry() {
        return RegistryManager.ACTIVE.getRegistry(new ResourceLocation("vampirism:entityactions"));
    }
}

