/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IForgeShearable;

public class ConvertedSheepEntity
extends ConvertedCreatureEntity<SheepEntity>
implements IForgeShearable {
    private static final DataParameter<Byte> COAT = EntityDataManager.func_187226_a(ConvertedSheepEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private Boolean lastSheared = null;

    public ConvertedSheepEntity(EntityType<? extends ConvertedSheepEntity> type, World world) {
        super((EntityType<? extends ConvertedCreatureEntity>)type, world);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        boolean t = this.getSheared();
        if (!(this.nil() || this.lastSheared != null && this.lastSheared == t)) {
            this.lastSheared = t;
            ((SheepEntity)this.getOldCreature()).func_70893_e(this.lastSheared.booleanValue());
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("Sheared", this.getSheared());
    }

    public DyeColor getFleeceColor() {
        return this.nil() ? DyeColor.WHITE : ((SheepEntity)this.getOldCreature()).func_175509_cj();
    }

    public boolean getSheared() {
        return ((Byte)this.field_70180_af.func_187225_a(COAT) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(COAT);
        if (sheared) {
            this.field_70180_af.func_187227_b(COAT, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(COAT, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return !this.getSheared() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(@Nullable PlayerEntity player, ItemStack item, World world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!world.func_201670_d()) {
            this.setSheared(true);
            int i = 1 + this.field_70146_Z.nextInt(3);
            for (int j = 0; j < i; ++j) {
                ret.add(new ItemStack((IItemProvider)SheepEntity.field_200206_bz.get(this.getFleeceColor())));
            }
            this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        }
        return ret;
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setSheared(nbt.func_74767_n("Sheared"));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COAT, (Object)0);
    }

    public static class ConvertingHandler
    extends DefaultConvertingHandler<SheepEntity> {
        public ConvertingHandler() {
            super(null);
        }

        @Override
        public ConvertedCreatureEntity<SheepEntity> createFrom(SheepEntity entity) {
            return Helper.createEntity((EntityType)ModEntities.CONVERTED_SHEEP.get(), entity.func_130014_f_()).map(creature -> {
                this.copyImportantStuff(creature, entity);
                creature.setSheared(entity.func_70892_o());
                return creature;
            }).orElse(null);
        }
    }
}

