/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.entity.converted.BiteableEntryManager;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampirismEntityRegistry
implements IVampirismEntityRegistry {
    @Nonnull
    public static final BiteableEntryManager biteableEntryManager = new BiteableEntryManager();
    private static final Logger LOGGER = LogManager.getLogger();
    @Nonnull
    private final Map<EntityType<? extends CreatureEntity>, IConvertingHandler> convertibles = new ConcurrentHashMap<EntityType<? extends CreatureEntity>, IConvertingHandler>();
    @Nonnull
    private final Map<EntityType<? extends CreatureEntity>, ResourceLocation> convertibleOverlay = new ConcurrentHashMap<EntityType<? extends CreatureEntity>, ResourceLocation>();
    private final Map<Class<? extends CreatureEntity>, Function> extendedCreatureConstructors = new ConcurrentHashMap<Class<? extends CreatureEntity>, Function>();
    private Function<IConvertingHandler.IDefaultHelper, IConvertingHandler> defaultConvertingHandlerCreator;
    private boolean finished = false;

    @Override
    public void addConvertible(EntityType<? extends CreatureEntity> type, ResourceLocation overlayLocation) {
        this.addConvertible(type, overlayLocation, new DefaultConvertingHandler(null));
    }

    @Override
    public void addConvertible(EntityType<? extends CreatureEntity> type, ResourceLocation overlay_loc, IConvertingHandler.IDefaultHelper helper) {
        this.addConvertible(type, overlay_loc, this.defaultConvertingHandlerCreator.apply(helper));
    }

    @Override
    public void addConvertible(EntityType<? extends CreatureEntity> type, ResourceLocation overlay_loc, @Nonnull IConvertingHandler handler) {
        if (this.finished) {
            throw new IllegalStateException("Register convertibles during InterModEnqueueEvent");
        }
        this.convertibles.put(type, handler);
        if (FMLEnvironment.dist.isClient() && overlay_loc != null) {
            this.convertibleOverlay.put(type, overlay_loc);
        }
    }

    @Override
    public <T extends CreatureEntity> void addCustomExtendedCreature(Class<? extends T> clazz, Function<T, IExtendedCreatureVampirism> constructor) {
        if (this.finished) {
            throw new IllegalStateException("Register extended creatures during InterModEnqueueEvent");
        }
        this.extendedCreatureConstructors.put(clazz, constructor);
    }

    public void applyNewResources(Map<ResourceLocation, Float> valuesIn) {
        HashMap values = Maps.newHashMap(valuesIn);
        HashMap biteables = Maps.newHashMap();
        HashSet blacklist = Sets.newHashSet();
        IConvertingHandler defaultHandler = this.defaultConvertingHandlerCreator.apply(null);
        for (Map.Entry<EntityType<? extends CreatureEntity>, IConvertingHandler> entry : this.convertibles.entrySet()) {
            ResourceLocation id = entry.getKey().getRegistryName();
            if (id == null) {
                LOGGER.warn("Cannot register convertible {} since there is no EntityString for it", entry.getKey());
                continue;
            }
            Float bloodF = (Float)values.remove(id);
            if (bloodF == null) {
                LOGGER.warn("Missing blood value for convertible creature {} ({})", (Object)entry.getKey().func_212546_e(), (Object)id);
                continue;
            }
            int blood = Math.round(bloodF.floatValue());
            LOGGER.debug("Registering convertible {} with blood {} and handler {}", (Object)entry.getKey().func_212546_e().getString(), (Object)blood, (Object)entry.getValue().getClass().getName());
            BiteableEntry biteEntry = new BiteableEntry(blood, entry.getValue() == null ? defaultHandler : entry.getValue());
            biteables.put(id, biteEntry);
        }
        LOGGER.info("Registered {} convertibles", (Object)biteables.size());
        for (Map.Entry<Object, IConvertingHandler<Object>> entry : values.entrySet()) {
            if (!ForgeRegistries.ENTITIES.containsKey((ResourceLocation)entry.getKey())) continue;
            int blood = Math.abs(Math.round(((Float)((Object)entry.getValue())).floatValue()));
            if (blood == 0) {
                blacklist.add(entry.getKey());
                continue;
            }
            biteables.put(entry.getKey(), new BiteableEntry(blood));
        }
        biteableEntryManager.setNewBiteables(biteables, blacklist);
    }

    @Override
    @Nullable
    public IConvertedCreature convert(CreatureEntity entity) {
        BiteableEntry b = biteableEntryManager.get(entity);
        if (b != null && b.convertingHandler != null) {
            return b.convertingHandler.createFrom(entity);
        }
        LOGGER.warn("Failed to find convertible entry for {}", (Object)entity);
        return null;
    }

    public void finishRegistration() {
        this.finished = true;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Map<EntityType<? extends CreatureEntity>, ResourceLocation> getConvertibleOverlay() {
        return this.convertibleOverlay;
    }

    @Override
    @Nullable
    public <T extends CreatureEntity> Function<T, IExtendedCreatureVampirism> getCustomExtendedCreatureConstructor(T entity) {
        return this.extendedCreatureConstructors.get(entity.getClass());
    }

    @Override
    @Nullable
    public BiteableEntry getEntry(CreatureEntity creature) {
        return biteableEntryManager.get(creature);
    }

    public void setDefaultConvertingHandlerCreator(Function<IConvertingHandler.IDefaultHelper, IConvertingHandler> creator) {
        this.defaultConvertingHandlerCreator = creator;
    }
}

