/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionBuilder;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillageBuilder;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFactionBuilder;
import de.teamlapen.vampirism.api.entity.factions.IVillageFactionData;
import de.teamlapen.vampirism.api.entity.factions.LordTitles;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.entity.factions.Faction;
import de.teamlapen.vampirism.entity.factions.FactionVillageBuilder;
import de.teamlapen.vampirism.entity.factions.PlayableFaction;
import de.teamlapen.vampirism.entity.factions.PredicateFaction;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.NonNullSupplier;

public class FactionRegistry
implements IFactionRegistry {
    private final Map<Integer, Predicate<LivingEntity>> predicateMap = new HashMap<Integer, Predicate<LivingEntity>>();
    private List<Faction> temp = new CopyOnWriteArrayList<Faction>();
    private Faction[] allFactions;
    private PlayableFaction[] playableFactions;

    public void finish() {
        this.allFactions = this.temp.toArray(new Faction[0]);
        this.temp = null;
        ArrayList<PlayableFaction> temp2 = new ArrayList<PlayableFaction>();
        for (Faction allFaction : this.allFactions) {
            allFaction.finish();
            if (!(allFaction instanceof PlayableFaction)) continue;
            temp2.add((PlayableFaction)allFaction);
        }
        this.playableFactions = temp2.toArray(new PlayableFaction[0]);
    }

    @Override
    @Nullable
    public IFaction getFaction(Entity entity) {
        if (entity instanceof IFactionEntity) {
            return ((IFactionEntity)entity).getFaction();
        }
        if (entity instanceof PlayerEntity) {
            return VampirismPlayerAttributes.get((PlayerEntity)((PlayerEntity)entity)).faction;
        }
        return null;
    }

    @Override
    @Nullable
    public IFaction getFactionByID(ResourceLocation id) {
        if (this.allFactions == null) {
            return null;
        }
        for (Faction f : this.allFactions) {
            if (!f.getID().equals((Object)id)) continue;
            return f;
        }
        return null;
    }

    public Faction[] getFactions() {
        return this.allFactions;
    }

    public PlayableFaction<?>[] getPlayableFactions() {
        return this.playableFactions;
    }

    public Predicate<LivingEntity> getPredicate(IFaction thisFaction, boolean ignoreDisguise) {
        return this.getPredicate(thisFaction, true, true, true, ignoreDisguise, null);
    }

    @Override
    public Predicate<LivingEntity> getPredicate(IFaction<?> thisFaction, boolean player, boolean mob, boolean neutralPlayer, boolean ignoreDisguise, @Nullable IFaction<?> otherFaction) {
        Object predicate;
        int id;
        int key = 0;
        if (otherFaction != null) {
            id = otherFaction.hashCode();
            if (id > 63) {
                Biome.field_150586_aC.warn("Faction id over 64, predicates won't work");
            }
            key |= (id & 0x3F) << 10;
        }
        if (player) {
            key |= 0x200;
        }
        if (mob) {
            key |= 0x100;
        }
        if (neutralPlayer) {
            key |= 0x80;
        }
        if (ignoreDisguise) {
            key |= 0x40;
        }
        if ((id = thisFaction.hashCode()) > 64) {
            Biome.field_150586_aC.warn("Faction id over 64, predicates won't work");
        }
        if (this.predicateMap.containsKey(key |= id & 0x3F)) {
            predicate = this.predicateMap.get(key);
        } else {
            predicate = new PredicateFaction(thisFaction, player, mob, neutralPlayer, ignoreDisguise, otherFaction);
            this.predicateMap.put(key, (Predicate<LivingEntity>)predicate);
        }
        return predicate;
    }

    @Override
    public <T extends IFactionEntity> IFaction registerFaction(ResourceLocation id, Class<T> entityInterface, Color color, boolean hostileTowardsNeutral) {
        return this.registerFaction(id, entityInterface, color, hostileTowardsNeutral, null);
    }

    @Override
    public <T extends IFactionEntity> IFaction registerFaction(ResourceLocation id, Class<T> entityInterface, Color color, boolean hostileTowardsNeutral, @Nullable IVillageFactionData villageFactionData) {
        if (!UtilLib.isNonNull(id, entityInterface)) {
            throw new IllegalArgumentException("[Vampirism]Parameter for faction cannot be null");
        }
        Faction<T> f = new Faction<T>(id, entityInterface, color, hostileTowardsNeutral, villageFactionData == null ? new FactionVillageBuilder() : villageFactionData, TextFormatting.WHITE, (ITextComponent)new StringTextComponent(id.toString()), (ITextComponent)new StringTextComponent(id.toString()));
        this.addFaction(f);
        return f;
    }

    @Override
    @Deprecated
    public <T extends IFactionPlayer<?>> IPlayableFaction<T> registerPlayableFaction(ResourceLocation id, Class<T> entityInterface, Color color, boolean hostileTowardsNeutral, NonNullSupplier<Capability<T>> playerCapabilitySupplier, int highestLevel, int highestLordLevel, @Nonnull BiFunction<Integer, Boolean, ITextComponent> lordTitleFunction, @Nullable IVillageFactionData villageFactionData) {
        if (!UtilLib.isNonNull(id, entityInterface, playerCapabilitySupplier)) {
            throw new IllegalArgumentException("[Vampirism]Parameters for faction cannot be null");
        }
        PlayableFaction<T> f = new PlayableFaction<T>(id, entityInterface, color, hostileTowardsNeutral, playerCapabilitySupplier, highestLevel, highestLordLevel, lordTitleFunction::apply, villageFactionData == null ? new FactionVillageBuilder() : villageFactionData, null, TextFormatting.WHITE, (ITextComponent)new StringTextComponent(id.toString()), (ITextComponent)new StringTextComponent(id.toString()), false);
        this.addFaction(f);
        return f;
    }

    @Override
    @Deprecated
    public <T extends IFactionPlayer<?>> IPlayableFaction<T> registerPlayableFaction(ResourceLocation id, Class<T> entityInterface, Color color, boolean hostileTowardsNeutral, NonNullSupplier<Capability<T>> playerCapabilitySupplier, int highestLevel) {
        return this.registerPlayableFaction(id, entityInterface, color, hostileTowardsNeutral, playerCapabilitySupplier, highestLevel, 0, (a, b) -> new StringTextComponent("Lord " + a), null);
    }

    private void addFaction(Faction faction) {
        if (this.temp == null) {
            throw new IllegalStateException(String.format("[Vampirism]You have to register factions during InterModEnqueueEvent. (%s)", faction.getID()));
        }
        this.temp.add(faction);
    }

    @Override
    public <T extends IFactionEntity> IFactionBuilder<T> createFaction(ResourceLocation id, Class<T> entityInterface) {
        if (!UtilLib.isNonNull(id, entityInterface)) {
            throw new IllegalArgumentException("[Vampirism] Parameter for faction cannot be null");
        }
        return new FactionBuilder<T>(id, entityInterface);
    }

    @Override
    public <T extends IFactionPlayer<?>> IPlayableFactionBuilder<T> createPlayableFaction(ResourceLocation id, Class<T> entityInterface, NonNullSupplier<Capability<T>> playerCapabilitySupplier) {
        if (!UtilLib.isNonNull(id, entityInterface, playerCapabilitySupplier)) {
            throw new IllegalArgumentException("[Vampirism] Parameters for faction cannot be null");
        }
        return new PlayableFactionBuilder<T>(id, entityInterface, playerCapabilitySupplier);
    }

    private class PlayableFactionBuilder<T extends IFactionPlayer<?>>
    extends FactionBuilder<T>
    implements IPlayableFactionBuilder<T> {
        protected final NonNullSupplier<Capability<T>> playerCapabilitySupplier;
        protected int highestLevel;
        protected int highestLordLevel;
        protected LordTitles lordTitleFunction;
        protected Function<IRefinementItem.AccessorySlotType, IRefinementItem> refinementItemBySlot;
        protected boolean hasLordSkills;

        public PlayableFactionBuilder(ResourceLocation id, Class<T> entityInterface, NonNullSupplier<Capability<T>> playerCapabilitySupplier) {
            super(id, entityInterface);
            this.highestLevel = 1;
            this.highestLordLevel = 0;
            this.hasLordSkills = false;
            this.playerCapabilitySupplier = playerCapabilitySupplier;
        }

        @Override
        public IPlayableFactionBuilder<T> color(@Nonnull Color color) {
            return (IPlayableFactionBuilder)super.color(color);
        }

        @Override
        public IPlayableFactionBuilder<T> hostileTowardsNeutral() {
            return (IPlayableFactionBuilder)super.hostileTowardsNeutral();
        }

        @Override
        public IPlayableFactionBuilder<T> highestLevel(int highestLevel) {
            this.highestLevel = highestLevel;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> lordLevel(int highestLordLevel) {
            this.highestLordLevel = highestLordLevel;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> lordTitle(@Nonnull LordTitles lordTitleFunction) {
            this.lordTitleFunction = lordTitleFunction;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> lordTitle(@Nonnull LordTitles.LordTitlesNeutral lordTitleFunction) {
            return this.lordTitle((LordTitles)lordTitleFunction);
        }

        @Override
        public IPlayableFactionBuilder<T> village(@Nonnull Consumer<IFactionVillageBuilder> villageBuilder) {
            return (IPlayableFactionBuilder)super.village(villageBuilder);
        }

        @Override
        public IPlayableFactionBuilder<T> refinementItems(@Nonnull Function<IRefinementItem.AccessorySlotType, IRefinementItem> refinementItemBySlot) {
            this.refinementItemBySlot = refinementItemBySlot;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> chatColor(@Nonnull TextFormatting color) {
            return (IPlayableFactionBuilder)super.chatColor(color);
        }

        @Override
        public IPlayableFactionBuilder<T> name(@Nonnull String nameKey) {
            return (IPlayableFactionBuilder)super.name(nameKey);
        }

        @Override
        public IPlayableFactionBuilder<T> namePlural(@Nonnull String namePluralKey) {
            return (IPlayableFactionBuilder)super.namePlural(namePluralKey);
        }

        @Override
        public IPlayableFactionBuilder<T> enableLordSkills() {
            this.hasLordSkills = true;
            return this;
        }

        @Override
        public IPlayableFaction<T> register() {
            if (this.lordTitleFunction == null) {
                this.lordTitleFunction = (a, b) -> new StringTextComponent("Lord " + a);
            }
            PlayableFaction<T> faction = new PlayableFaction<T>(this.id, this.entityInterface, this.color, this.hostileTowardsNeutral, this.playerCapabilitySupplier, this.highestLevel, this.highestLordLevel, this.lordTitleFunction, this.villageFactionData, this.refinementItemBySlot, this.chatColor != null ? this.chatColor : TextFormatting.WHITE, (ITextComponent)(this.name == null ? new StringTextComponent(this.id.toString()) : new TranslationTextComponent(this.name)), (ITextComponent)(this.namePlural == null ? (this.name == null ? new StringTextComponent(this.id.toString()) : new TranslationTextComponent(this.name)) : new TranslationTextComponent(this.namePlural)), this.hasLordSkills);
            FactionRegistry.this.addFaction(faction);
            return faction;
        }
    }

    private class FactionBuilder<T extends IFactionEntity>
    implements IFactionBuilder<T> {
        protected final ResourceLocation id;
        protected final Class<T> entityInterface;
        protected Color color = Color.WHITE;
        protected boolean hostileTowardsNeutral;
        protected FactionVillageBuilder villageFactionData = new FactionVillageBuilder();
        protected TextFormatting chatColor;
        protected String name;
        protected String namePlural;

        public FactionBuilder(ResourceLocation id, Class<T> entityInterface) {
            this.id = id;
            this.entityInterface = entityInterface;
        }

        @Override
        public IFactionBuilder<T> color(@Nonnull Color color) {
            this.color = color;
            return this;
        }

        @Override
        public IFactionBuilder<T> chatColor(@Nonnull TextFormatting color) {
            this.chatColor = color;
            return this;
        }

        @Override
        public IFactionBuilder<T> hostileTowardsNeutral() {
            this.hostileTowardsNeutral = true;
            return this;
        }

        @Override
        public IFactionBuilder<T> village(@Nonnull Consumer<IFactionVillageBuilder> villageBuilder) {
            villageBuilder.accept(this.villageFactionData);
            return this;
        }

        @Override
        public IFactionBuilder<T> name(@Nonnull String nameKey) {
            this.name = nameKey;
            return this;
        }

        @Override
        public IFactionBuilder<T> namePlural(@Nonnull String namePluralKey) {
            this.namePlural = namePluralKey;
            return this;
        }

        @Override
        public IFaction<T> register() {
            Faction<T> faction = new Faction<T>(this.id, this.entityInterface, this.color, this.hostileTowardsNeutral, this.villageFactionData, this.chatColor != null ? this.chatColor : TextFormatting.WHITE, (ITextComponent)(this.name == null ? new StringTextComponent(this.id.toString()) : new TranslationTextComponent(this.name)), (ITextComponent)(this.namePlural == null ? (this.name == null ? new StringTextComponent(this.id.toString()) : new TranslationTextComponent(this.name)) : new TranslationTextComponent(this.namePlural)));
            FactionRegistry.this.addFaction(faction);
            return faction;
        }
    }
}

