/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.ITaskMasterEntity;
import de.teamlapen.vampirism.api.entity.factions.IVillageFactionData;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import org.apache.commons.lang3.tuple.Pair;

public class FactionVillageData
implements IVillageFactionData {
    private final Effect badOmenEffect;
    private final ItemStack bannerStack;
    private final ImmutableList<CaptureEntityEntry> captureEntities;
    private final VillagerProfession factionVillageProfession;
    private final Class<? extends MobEntity> guardSuperClass;
    private final EntityType<? extends ITaskMasterEntity> taskMasterEntity;
    private final Block fragileTotem;
    private final Block craftedTotem;
    private final Pair<Block, Block> totemPair;

    public FactionVillageData(@Nullable Effect badOmenEffect, @Nonnull ItemStack bannerStack, @Nonnull ImmutableList<CaptureEntityEntry> captureEntities, @Nonnull VillagerProfession factionVillageProfession, @Nonnull Class<? extends MobEntity> guardSuperClass, @Nullable EntityType<? extends ITaskMasterEntity> taskMasterEntity, @Nonnull Block fragileTotem, @Nonnull Block craftedTotem) {
        this.badOmenEffect = badOmenEffect;
        this.bannerStack = bannerStack;
        this.captureEntities = captureEntities;
        this.factionVillageProfession = factionVillageProfession;
        this.guardSuperClass = guardSuperClass;
        this.taskMasterEntity = taskMasterEntity;
        this.fragileTotem = fragileTotem;
        this.craftedTotem = craftedTotem;
        this.totemPair = Pair.of((Object)fragileTotem, (Object)craftedTotem);
    }

    @Override
    @Nullable
    public Effect getBadOmenEffect() {
        return this.badOmenEffect;
    }

    @Override
    @Nonnull
    public ItemStack getBanner() {
        return this.bannerStack.func_77946_l();
    }

    @Override
    public List<CaptureEntityEntry> getCaptureEntries() {
        return this.captureEntities;
    }

    @Override
    @Nonnull
    public VillagerProfession getFactionVillageProfession() {
        return this.factionVillageProfession;
    }

    @Override
    @Nonnull
    public Class<? extends MobEntity> getGuardSuperClass() {
        return this.guardSuperClass;
    }

    @Override
    @Nullable
    public EntityType<? extends ITaskMasterEntity> getTaskMasterEntity() {
        return this.taskMasterEntity;
    }

    @Override
    @Nonnull
    public Pair<Block, Block> getTotemTopBlock() {
        return this.totemPair;
    }

    @Override
    @Nonnull
    public Block getTotemTopBlock(boolean crafted) {
        return crafted ? this.craftedTotem : this.fragileTotem;
    }

    @Override
    public boolean isBanner(@Nonnull ItemStack stack) {
        return ItemStack.func_77989_b((ItemStack)this.bannerStack, (ItemStack)stack);
    }
}

