/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.goals;

import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public abstract class MoveToPositionGoal<T extends CreatureEntity>
extends Goal {
    protected final T entity;
    protected final IWorldReader world;
    private final double followSpeed;
    private final PathNavigator navigator;
    private final float minDist;
    private final float maxDist;
    private final boolean doTeleport;
    private final boolean look;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public MoveToPositionGoal(T entity, double followSpeed, float minDist, float maxDist, boolean doTeleport, boolean look) {
        this.entity = entity;
        this.world = entity.func_130014_f_();
        this.followSpeed = followSpeed;
        this.minDist = minDist;
        this.navigator = entity.func_70661_as();
        this.maxDist = maxDist;
        this.doTeleport = doTeleport;
        this.look = look;
        this.func_220684_a(look ? EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP) : EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        if (!(entity.func_70661_as() instanceof GroundPathNavigator) && !(entity.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for MoveToPositionGoal");
        }
    }

    public boolean func_75253_b() {
        return this.getTargetPosition().func_177951_i((Vector3i)this.entity.func_233580_cy_()) > (double)(this.minDist * this.minDist);
    }

    public boolean func_75250_a() {
        return this.getTargetPosition().func_177951_i((Vector3i)this.entity.func_233580_cy_()) > (double)(this.minDist * this.minDist);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.navigator.func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        Vector3i target = this.getTargetPosition();
        if (this.look) {
            this.entity.func_70671_ap().func_220674_a(this.getLookPosition());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            boolean flag = this.navigator.func_75492_a((double)target.func_177958_n(), (double)target.func_177956_o(), (double)target.func_177952_p(), this.followSpeed);
            if (!(!this.doTeleport || flag && this.entity.func_70681_au().nextInt(8) != 0 || this.entity.func_70092_e((double)target.func_177958_n(), (double)target.func_177956_o(), (double)target.func_177952_p()) < (double)(this.maxDist * this.maxDist))) {
                int sX = target.func_177958_n() - 2;
                int sZ = target.func_177952_p() - 2;
                int sY = target.func_177956_o();
                for (int dX = 0; dX <= 4; ++dX) {
                    for (int dZ = 0; dZ <= 4; ++dZ) {
                        if (dX >= 1 && dZ >= 1 && dX <= 3 && dZ <= 3 || !this.canTeleportToBlock(new BlockPos(sX + dX, sY - 1, sZ + dZ))) continue;
                        this.entity.func_70012_b((double)((float)(sX + dX) + 0.5f), (double)sY, (double)((float)(sZ + dZ) + 0.5f), ((CreatureEntity)this.entity).field_70177_z, ((CreatureEntity)this.entity).field_70125_A);
                        this.navigator.func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    protected boolean canTeleportToBlock(BlockPos pos) {
        BlockState blockstate = this.world.func_180495_p(pos);
        return blockstate.func_215688_a((IBlockReader)this.world, pos, this.entity.func_200600_R()) && this.world.func_175623_d(pos.func_177984_a()) && this.world.func_175623_d(pos.func_177981_b(2));
    }

    protected abstract Vector3d getLookPosition();

    protected abstract Vector3i getTargetPosition();
}

