/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.items.HunterCoatItem;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;

public abstract class VampireBaseEntity
extends VampirismEntity
implements IVampireMob,
INPC {
    private final boolean countAsMonsterForSpawn;
    protected EnumStrength garlicResist = EnumStrength.NONE;
    protected boolean canSuckBloodFromPlayer = false;
    protected boolean vulnerableToFire = true;
    private SpawnRestriction spawnRestriction = SpawnRestriction.NORMAL;
    private boolean sundamageCache;
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean dropSoul = false;

    public static boolean spawnPredicateVampire(EntityType<? extends VampirismEntity> entityType, IServerWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && (VampireBaseEntity.spawnPredicateLight(world, blockPos, random) || VampireBaseEntity.spawnPredicateVampireFog((IWorld)world, blockPos)) && VampireBaseEntity.spawnPredicateCanSpawn(entityType, (IWorld)world, spawnReason, blockPos, random);
    }

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        AttributeModifierMap.MutableAttribute mutableAttribute = VampirismEntity.getAttributeBuilder();
        Attribute attribute = (Attribute)ModAttributes.SUNDAMAGE.get();
        BalanceMobProps.mobProps.getClass();
        return mutableAttribute.func_233815_a_(attribute, 7.0);
    }

    public VampireBaseEntity(EntityType<? extends VampireBaseEntity> type, World world, boolean countAsMonsterForSpawn) {
        super(type, world);
        this.countAsMonsterForSpawn = countAsMonsterForSpawn;
    }

    @Override
    public void func_70636_d() {
        if (this.field_70173_aa % 40 == 3) {
            this.isGettingGarlicDamage((IWorld)this.field_70170_p, true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage((IWorld)this.field_70170_p, true);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isGettingSundamage((IWorld)this.field_70170_p) && this.func_70089_S()) {
                double dmg;
                if (((Boolean)VampirismConfig.BALANCE.vpSundamageInstantDeath.get()).booleanValue()) {
                    this.func_70097_a(VReference.SUNDAMAGE, 1000.0f);
                    this.turnToAsh();
                } else if (this.field_70173_aa % 40 == 11 && (dmg = this.func_110148_a((Attribute)ModAttributes.SUNDAMAGE.get()).func_111126_e()) > 0.0) {
                    this.func_70097_a(VReference.SUNDAMAGE, (float)dmg);
                }
            }
            if (this.isGettingGarlicDamage((IWorld)this.field_70170_p) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((IWorld)this.field_70170_p), this.field_70173_aa);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70090_H()) {
            this.func_70050_g(300);
            if (this.field_70173_aa % 16 == 4) {
                this.func_195064_c(new EffectInstance(Effects.field_76437_t, 80, 0));
            }
        }
        super.func_70636_d();
    }

    private void turnToAsh() {
        if (!this.func_70089_S()) {
            this.field_70725_aQ = 19;
            ModParticles.spawnParticlesServer(this.field_70170_p, (IParticleData)ParticleTypes.field_239820_at_, this.func_226277_ct_() + 0.5, this.func_226278_cu_() + (double)this.func_213302_cg(), this.func_226281_cx_() + 0.5, 20, 0.2, (double)this.func_213302_cg() * 0.2, 0.2, 0.1);
            ModParticles.spawnParticlesServer(this.field_70170_p, (IParticleData)ParticleTypes.field_239813_am_, this.func_226277_ct_() + 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_() + 0.5, 20, 0.2, (double)this.func_213302_cg() * 0.2, 0.2, 0.1);
            this.func_70106_y();
        }
    }

    @Override
    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        if (this.spawnRestriction.level >= SpawnRestriction.SIMPLE.level) {
            if (this.isGettingSundamage(worldIn, true) || this.isGettingGarlicDamage(worldIn, true) != EnumStrength.NONE) {
                return false;
            }
            if (this.spawnRestriction.level >= SpawnRestriction.NORMAL.level) {
                if ((double)worldIn.func_205052_D(this.func_233580_cy_()) > 0.5 && this.field_70146_Z.nextInt(5) != 0) {
                    return false;
                }
                if (this.field_70170_p.func_195588_v(this.func_233580_cy_()) && worldIn instanceof ServerWorld && ((ServerWorld)this.field_70170_p).getWorldServer().func_241827_a(SectionPos.func_218167_a((BlockPos)this.func_233580_cy_()), Structure.field_236381_q_).findAny().isPresent() && this.func_70681_au().nextInt(60) != 0) {
                    return false;
                }
                if (this.spawnRestriction.level >= SpawnRestriction.SPECIAL.level && !this.getCanSpawnHereRestricted(worldIn)) {
                    return false;
                }
            }
        }
        return super.func_213380_a(worldIn, spawnReasonIn);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76364_f() instanceof CrossbowArrowEntity && Helper.isHunter(cause.func_76346_g())) {
            this.dropSoul = true;
        } else if (cause.func_76364_f() instanceof PlayerEntity && Helper.isHunter(cause.func_76364_f())) {
            ItemStack weapon = ((PlayerEntity)cause.func_76364_f()).func_184614_ca();
            if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof IVampireFinisher) {
                this.dropSoul = true;
            }
        } else {
            this.dropSoul = false;
        }
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return !strength.isStrongerThan(this.garlicResist);
    }

    public boolean func_70652_k(Entity entity) {
        if (this.canSuckBloodFromPlayer && !this.field_70170_p.field_72995_K && this.wantsBlood() && entity instanceof PlayerEntity && !Helper.isHunter(entity) && !UtilLib.canReallySee((LivingEntity)entity, (LivingEntity)this, true)) {
            int amt = VampirePlayer.getOpt((PlayerEntity)entity).map(v -> v.onBite(this)).orElse(0);
            this.drinkBlood(amt, 0.7f);
            VampirePlayer.getOpt((PlayerEntity)entity).ifPresent(v -> v.tryInfect(this));
            return true;
        }
        for (ItemStack e : entity.func_184193_aE()) {
            if (e == null || !(e.func_77973_b() instanceof HunterCoatItem)) continue;
            int j = 1;
            if (((HunterCoatItem)e.func_77973_b()).getVampirismTier().equals((Object)IItemWithTier.TIER.ENHANCED)) {
                j = 2;
            } else if (((HunterCoatItem)e.func_77973_b()).getVampirismTier().equals((Object)IItemWithTier.TIER.ULTIMATE)) {
                j = 3;
            }
            if (this.func_70681_au().nextInt((4 - j) * 2) != 0) continue;
            this.func_195064_c(new EffectInstance((Effect)ModEffects.POISON.get(), (int)(20.0 * Math.sqrt(j)), j));
        }
        return super.func_70652_k(entity);
    }

    public EntityClassification getClassification(boolean forSpawnCount) {
        if (forSpawnCount && this.countAsMonsterForSpawn) {
            return EntityClassification.MONSTER;
        }
        return super.getClassification(forSpawnCount);
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.func_195064_c(new EffectInstance(Effects.field_76428_l, amt * 20));
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(IWorld iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    public CreatureAttribute func_70668_bt() {
        return VReference.VAMPIRE_CREATURE_ATTRIBUTE;
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (this.vulnerableToFire) {
            if (DamageSource.field_76372_a.equals(damageSource)) {
                return this.func_70097_a(VReference.VAMPIRE_IN_FIRE, this.calculateFireDamage(amount));
            }
            if (DamageSource.field_76370_b.equals(damageSource)) {
                return this.func_70097_a(VReference.VAMPIRE_ON_FIRE, this.calculateFireDamage(amount));
            }
        }
        return super.func_70097_a(damageSource, amount);
    }

    @Override
    public boolean isGettingSundamage(IWorld iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.field_70170_p.func_217381_Z());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.func_70644_a((Effect)ModEffects.SUNSCREEN.get());
    }

    public void setSpawnRestriction(SpawnRestriction r) {
        this.spawnRestriction = r;
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.func_195064_c(new EffectInstance(Effects.field_76437_t, amt * 20));
        return true;
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    protected float calculateFireDamage(float amount) {
        return amount;
    }

    protected void func_70609_aI() {
        if (this.field_70725_aQ == 19 && !this.field_70170_p.field_72995_K && this.dropSoul && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.field_70170_p.func_217376_c((Entity)new SoulOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoulOrbEntity.VARIANT.VAMPIRE));
        }
        super.func_70609_aI();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
    }

    private boolean getCanSpawnHereRestricted(IWorld iWorld) {
        boolean vampireBiome;
        boolean bl = vampireBiome = ((Biome)ModBiomes.VAMPIRE_FOREST.get()).getRegistryName().equals((Object)Helper.getBiomeId((IBiomeReader)iWorld, this.func_233580_cy_())) || ((Biome)ModBiomes.VAMPIRE_FOREST_HILLS.get()).getRegistryName().equals((Object)Helper.getBiomeId((IBiomeReader)iWorld, this.func_233580_cy_()));
        if (!vampireBiome) {
            return this.isLowLightLevel(iWorld);
        }
        BlockState iblockstate = iWorld.func_180495_p(this.func_233580_cy_().func_177977_b());
        return iblockstate.func_235714_a_(ModTags.Blocks.CURSEDEARTH);
    }

    public static enum SpawnRestriction {
        NONE(0),
        SIMPLE(1),
        NORMAL(2),
        SPECIAL(3);

        int level;

        private SpawnRestriction(int level) {
            this.level = level;
        }
    }
}

