/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModRecipes;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.world.World;

public class AlchemyTableContainer
extends Container {
    private final IInventory alchemyTable;
    private final IIntArray alchemyTableData;
    private final Slot ingredientSlot;

    public AlchemyTableContainer(int containerId, PlayerInventory playerInventory) {
        this(containerId, playerInventory.field_70458_d.field_70170_p, playerInventory, (IInventory)new Inventory(6), (IIntArray)new IntArray(3));
    }

    public AlchemyTableContainer(int containerId, World level, PlayerInventory playerInventory, IInventory inventory, IIntArray data) {
        super((ContainerType)ModContainer.ALCHEMICAL_TABLE.get(), containerId);
        AlchemyTableContainer.func_216962_a((IInventory)inventory, (int)5);
        AlchemyTableContainer.func_216959_a((IIntArray)data, (int)3);
        this.alchemyTable = inventory;
        this.alchemyTableData = data;
        this.func_75146_a(new OilSlot(level, inventory, 0, 55, 16));
        this.func_75146_a(new OilSlot(level, inventory, 1, 79, 16));
        this.func_75146_a(new ResultSlot(inventory, 2, 112, 72));
        this.func_75146_a(new ResultSlot(inventory, 3, 140, 44));
        this.ingredientSlot = this.func_75146_a(new IngredientSlot(level, inventory, 4, 15, 25));
        this.func_75146_a(new FuelSlot(inventory, 5, 34, 69));
        this.func_216961_a(data);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 101 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 159));
        }
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return this.alchemyTable.func_70300_a(player);
    }

    public int getFuel() {
        return this.alchemyTableData.func_221476_a(1);
    }

    public int getBrewingTicks() {
        return this.alchemyTableData.func_221476_a(0);
    }

    public int getColor() {
        return this.alchemyTableData.func_221476_a(2);
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotId) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slotId < 0 || slotId > 5) {
                if (FuelSlot.mayPlaceItem(itemstack) ? this.func_75135_a(itemstack1, 5, 6, false) || this.ingredientSlot.func_75214_a(itemstack1) && !this.func_75135_a(itemstack1, 4, 5, false) : (this.ingredientSlot.func_75214_a(itemstack1) ? !this.func_75135_a(itemstack1, 4, 5, false) : (OilSlot.mayPlaceItem(player.field_70170_p, itemstack) && itemstack.func_190916_E() == 1 ? !this.func_75135_a(itemstack1, 0, 2, false) : (slotId >= 6 && slotId < 33 ? !this.func_75135_a(itemstack1, 33, 42, false) : (slotId >= 33 && slotId < 42 ? !this.func_75135_a(itemstack1, 6, 33, false) : !this.func_75135_a(itemstack1, 6, 42, false)))))) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (!this.func_75135_a(itemstack1, 6, 42, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    static class ResultSlot
    extends Slot {
        public ResultSlot(IInventory inventory, int slotId, int xPos, int yPos) {
            super(inventory, slotId, xPos, yPos);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return false;
        }
    }

    static class FuelSlot
    extends Slot {
        public FuelSlot(IInventory inventory, int slotId, int xPos, int yPos) {
            super(inventory, slotId, xPos, yPos);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return FuelSlot.mayPlaceItem(stack);
        }

        public static boolean mayPlaceItem(ItemStack stack) {
            return stack.func_77973_b() == Items.field_151065_br;
        }

        public int func_75219_a() {
            return 64;
        }
    }

    static class IngredientSlot
    extends Slot {
        private final World world;

        public IngredientSlot(World worldPos, IInventory inventory, int slotId, int xPos, int yPos) {
            super(inventory, slotId, xPos, yPos);
            this.world = worldPos;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return this.world.func_199532_z().func_241447_a_(ModRecipes.ALCHEMICAL_TABLE_TYPE).stream().anyMatch(recipe -> recipe.isInput(stack));
        }

        public int func_75219_a() {
            return 64;
        }
    }

    static class OilSlot
    extends Slot {
        private final World world;

        public OilSlot(World worldPos, IInventory inventory, int slotId, int xPos, int yPos) {
            super(inventory, slotId, xPos, yPos);
            this.world = worldPos;
        }

        public static boolean mayPlaceItem(World world, ItemStack itemstack) {
            return world.func_199532_z().func_241447_a_(ModRecipes.ALCHEMICAL_TABLE_TYPE).stream().anyMatch(recipe -> recipe.isIngredient(itemstack));
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return OilSlot.mayPlaceItem(this.world, stack);
        }

        public int func_75219_a() {
            return 1;
        }

        @Nonnull
        public ItemStack func_190901_a(@Nonnull PlayerEntity player, @Nonnull ItemStack stack) {
            super.func_190901_a(player, stack);
            return stack;
        }
    }
}

