/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.inventory.container.TaskContainer;
import de.teamlapen.vampirism.network.CTaskActionPacket;
import de.teamlapen.vampirism.player.TaskManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VampirismContainer
extends InventoryContainer
implements TaskContainer {
    private static final Function<PlayerEntity, InventoryContainer.SelectorInfo[]> SELECTOR_INFOS = player -> {
        IFaction faction = FactionPlayerHandler.getCurrentFactionPlayer(player).orElseThrow(() -> new IllegalStateException("Opening vampirism container without faction")).getFaction();
        return new InventoryContainer.SelectorInfo[]{new InventoryContainer.SelectorInfo(arg_0 -> VampirismContainer.lambda$null$1((IPlayableFaction)faction, arg_0), 58, 8), new InventoryContainer.SelectorInfo(arg_0 -> VampirismContainer.lambda$null$2((IPlayableFaction)faction, arg_0), 58, 26), new InventoryContainer.SelectorInfo(arg_0 -> VampirismContainer.lambda$null$3((IPlayableFaction)faction, arg_0), 58, 44)};
    };
    private final IFactionPlayer<?> factionPlayer;
    private final TextFormatting factionColor;
    private final NonNullList<ItemStack> refinementStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public Map<UUID, TaskManager.TaskWrapper> taskWrapper = new HashMap<UUID, TaskManager.TaskWrapper>();
    public Map<UUID, Set<UUID>> completableTasks = new HashMap<UUID, Set<UUID>>();
    public Map<UUID, Map<UUID, Map<ResourceLocation, Integer>>> completedRequirements = new HashMap<UUID, Map<UUID, Map<ResourceLocation, Integer>>>();
    private Runnable listener;
    private final boolean refinementsAvailable;

    public VampirismContainer(int id, @Nonnull PlayerInventory playerInventory) {
        super((ContainerType<? extends InventoryContainer>)((ContainerType)ModContainer.VAMPIRISM.get()), id, playerInventory, IWorldPosCallable.field_221489_a, (IInventory)new Inventory(3), (IInventory x$0, int x$1, InventoryContainer.SelectorInfo x$2, Consumer<IInventory> x$3, Function<Integer, Boolean> x$4) -> new RemovingSelectorSlot(x$0, x$1, x$2, x$3, x$4), SELECTOR_INFOS.apply(playerInventory.field_70458_d));
        this.factionPlayer = FactionPlayerHandler.get(playerInventory.field_70458_d).getCurrentFactionPlayer().orElseThrow(() -> new IllegalStateException("Opening vampirism container without faction"));
        this.factionColor = this.factionPlayer.getFaction().getChatColor();
        this.refinementsAvailable = this.factionPlayer.getFaction().hasRefinements();
        this.addPlayerSlots(playerInventory, 37, 124);
        ItemStack[] sets = this.factionPlayer.getSkillHandler().createRefinementItems();
        for (int i = 0; i < sets.length; ++i) {
            if (sets[i] == null) continue;
            this.refinementStacks.set(i, (Object)sets[i]);
        }
    }

    @Override
    public boolean areRequirementsCompleted(@Nonnull ITaskInstance taskInfo, @Nonnull TaskRequirement.Type type) {
        if (this.completedRequirements != null && this.completedRequirements.containsKey(taskInfo.getTaskBoard()) && this.completedRequirements.get(taskInfo.getTaskBoard()).containsKey(taskInfo.getId())) {
            Map<ResourceLocation, Integer> data = this.completedRequirements.get(taskInfo.getTaskBoard()).get(taskInfo.getId());
            for (TaskRequirement.Requirement<?> requirement : taskInfo.getTask().getRequirement().requirements().get((Object)type)) {
                if (data.containsKey(requirement.getId()) && data.get(requirement.getId()) >= requirement.getAmount(this.factionPlayer)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public TaskContainer.TaskAction buttonAction(@Nonnull ITaskInstance taskInfo) {
        return taskInfo.isUnique() || this.factionPlayer.getRepresentingPlayer().field_70170_p.func_82737_E() < taskInfo.getTaskTimeStamp() ? TaskContainer.TaskAction.ABORT : TaskContainer.TaskAction.REMOVE;
    }

    @Override
    public boolean canCompleteTask(@Nonnull ITaskInstance taskInfo) {
        return this.completableTasks.containsKey(taskInfo.getTaskBoard()) && this.completableTasks.get(taskInfo.getTaskBoard()).contains(taskInfo.getId()) && (taskInfo.isUnique() || this.factionPlayer.getRepresentingPlayer().field_70170_p.func_82737_E() < taskInfo.getTaskTimeStamp());
    }

    @Override
    public TextFormatting getFactionColor() {
        return this.factionColor;
    }

    public NonNullList<ItemStack> getRefinementStacks() {
        return this.refinementStacks;
    }

    @Override
    protected boolean isSlotEnabled(int id) {
        return this.refinementsAvailable;
    }

    public boolean areRefinementsAvailable() {
        return this.refinementsAvailable;
    }

    @Override
    public int getRequirementStatus(@Nonnull ITaskInstance taskInfo, @Nonnull TaskRequirement.Requirement<?> requirement) {
        assert (this.completedRequirements != null);
        if (this.completedRequirements.containsKey(taskInfo.getTaskBoard())) {
            return this.completedRequirements.get(taskInfo.getTaskBoard()).get(taskInfo.getId()).get(requirement.getId());
        }
        return requirement.getAmount(this.factionPlayer);
    }

    public Collection<ITaskInstance> getTaskInfos() {
        return this.taskWrapper.values().stream().flatMap(t -> t.getTaskInstances().stream().filter(ITaskInstance::isAccepted)).collect(Collectors.toList());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void init(@Nonnull Map<UUID, TaskManager.TaskWrapper> taskWrapper, @Nonnull Map<UUID, Set<UUID>> completableTasks, @Nonnull Map<UUID, Map<UUID, Map<ResourceLocation, Integer>>> completedRequirements) {
        this.taskWrapper = taskWrapper;
        this.completedRequirements = completedRequirements;
        this.completableTasks = completableTasks;
        if (this.listener != null) {
            this.listener.run();
        }
    }

    @Override
    public boolean isCompleted(@Nonnull ITaskInstance item) {
        return false;
    }

    @Override
    public boolean isRequirementCompleted(@Nonnull ITaskInstance taskInfo, @Nonnull TaskRequirement.Requirement<?> requirement) {
        if (this.completedRequirements != null && this.completedRequirements.containsKey(taskInfo.getTaskBoard()) && this.completedRequirements.get(taskInfo.getTaskBoard()).containsKey(taskInfo.getId())) {
            Map<ResourceLocation, Integer> data = this.completedRequirements.get(taskInfo.getTaskBoard()).get(taskInfo.getId());
            return data.containsKey(requirement.getId()) && data.get(requirement.getId()) >= requirement.getAmount(this.factionPlayer);
        }
        return false;
    }

    @Override
    public boolean isTaskNotAccepted(@Nonnull ITaskInstance taskInfo) {
        return false;
    }

    @Override
    public void pressButton(@Nonnull ITaskInstance taskInfo) {
        VampirismMod.dispatcher.sendToServer(new CTaskActionPacket(taskInfo.getId(), taskInfo.getTaskBoard(), this.buttonAction(taskInfo)));
        this.taskWrapper.get(taskInfo.getTaskBoard()).removeTask(taskInfo, true);
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public void setRefinement(int slot, @Nonnull ItemStack stack) {
        this.factionPlayer.getSkillHandler().equipRefinementItem(stack);
        this.refinementStacks.set(slot, (Object)stack);
    }

    @Override
    public void setReloadListener(@Nullable Runnable listener) {
        this.listener = listener;
    }

    private static /* synthetic */ boolean lambda$null$3(IPlayableFaction faction, ItemStack stack) {
        return stack.func_77973_b() instanceof IRefinementItem && ((IRefinementItem)stack.func_77973_b()).getSlotType() == IRefinementItem.AccessorySlotType.OBI_BELT && ((IRefinementItem)stack.func_77973_b()).getExclusiveFaction().equals(faction);
    }

    private static /* synthetic */ boolean lambda$null$2(IPlayableFaction faction, ItemStack stack) {
        return stack.func_77973_b() instanceof IRefinementItem && ((IRefinementItem)stack.func_77973_b()).getSlotType() == IRefinementItem.AccessorySlotType.RING && ((IRefinementItem)stack.func_77973_b()).getExclusiveFaction().equals(faction);
    }

    private static /* synthetic */ boolean lambda$null$1(IPlayableFaction faction, ItemStack stack) {
        return stack.func_77973_b() instanceof IRefinementItem && ((IRefinementItem)stack.func_77973_b()).getSlotType() == IRefinementItem.AccessorySlotType.AMULET && ((IRefinementItem)stack.func_77973_b()).getExclusiveFaction().equals(faction);
    }

    public static class RemovingSelectorSlot
    extends InventoryContainer.SelectorSlot {
        private RemovingSelectorSlot(IInventory inventoryIn, int index, InventoryContainer.SelectorInfo info, Consumer<IInventory> refreshInvFunc, Function<Integer, Boolean> activeFunc) {
            super(inventoryIn, index, info, refreshInvFunc, activeFunc);
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            if (!stack.func_190926_b()) {
                ((VampirismContainer)this.getContainer()).setRefinement(this.getSlotIndex(), stack);
            }
        }
    }
}

