/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.inventory.recipes.AbstractBrewingRecipe;
import de.teamlapen.vampirism.inventory.recipes.VampirismRecipeHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AlchemyTableRecipe
extends AbstractBrewingRecipe {
    private final ISkill[] requiredSkills;

    public AlchemyTableRecipe(ResourceLocation id, String group, Ingredient ingredient, Ingredient input, ItemStack result, ISkill[] skills) {
        super(ModRecipes.ALCHEMICAL_TABLE_TYPE, id, group, ingredient, input, result);
        this.requiredSkills = skills;
    }

    public boolean isInput(@Nonnull ItemStack input) {
        return UtilLib.matchesItem(this.input, input);
    }

    public boolean isIngredient(@Nonnull ItemStack ingredient) {
        return this.ingredient.test(ingredient);
    }

    @Nonnull
    public ItemStack getResult(@Nonnull ItemStack input, @Nonnull ItemStack ingredient) {
        return this.isInput(input) && this.isIngredient(ingredient) ? this.result.func_77946_l() : ItemStack.field_190927_a;
    }

    public ISkill[] getRequiredSkills() {
        return this.requiredSkills;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.ALCHEMICAL_TABLE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AlchemyTableRecipe> {
        @Nonnull
        public AlchemyTableRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ISkill[] skills = VampirismRecipeHelper.deserializeSkills(JSONUtils.func_151213_a((JsonObject)json, (String)"skill", null));
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            Ingredient input = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new AlchemyTableRecipe(recipeId, group, ingredient, input, result, skills);
        }

        @Nullable
        public AlchemyTableRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
            String group = buffer.func_218666_n();
            ItemStack result = buffer.func_150791_c();
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ISkill[] skills = new ISkill[buffer.func_150792_a()];
            if (skills.length != 0) {
                for (int i = 0; i < skills.length; ++i) {
                    skills[i] = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE)));
                }
            }
            return new AlchemyTableRecipe(recipeId, group, ingredient, input, result, skills);
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull AlchemyTableRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            buffer.func_150788_a(recipe.func_77571_b());
            recipe.ingredient.func_199564_a(buffer);
            recipe.input.func_199564_a(buffer);
            buffer.func_150787_b(recipe.requiredSkills.length);
            if (recipe.requiredSkills.length != 0) {
                for (ISkill skill : recipe.requiredSkills) {
                    buffer.func_180714_a(skill.getRegistryName().toString());
                }
            }
        }
    }
}

