/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.Multimap;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismHunterArmor;
import de.teamlapen.vampirism.util.VampirismArmorMaterials;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArmorOfSwiftnessItem
extends VampirismHunterArmor
implements IItemWithTier,
IDyeableArmorItem {
    private final int[] DAMAGE_REDUCTION_ULTIMATE = new int[]{3, 6, 8, 3};
    private final int[] DAMAGE_REDUCTION_ENHANCED = new int[]{2, 5, 6, 2};
    private final int[] DAMAGE_REDUCTION_NORMAL = new int[]{1, 2, 3, 1};
    private final IItemWithTier.TIER tier;

    public ArmorOfSwiftnessItem(EquipmentSlotType equipmentSlotIn, IItemWithTier.TIER tier) {
        super(VampirismArmorMaterials.MASTERLY_LEATHER, equipmentSlotIn, new Item.Properties().func_200916_a(VampirismMod.creativeTab));
        this.tier = tier;
    }

    public int func_200886_f(ItemStack p_200886_1_) {
        CompoundNBT compoundnbt = p_200886_1_.func_179543_a("display");
        return compoundnbt != null && compoundnbt.func_150297_b("color", 99) ? compoundnbt.func_74762_e("color") : -1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        switch (this.getVampirismTier()) {
            case ENHANCED: {
                return this.getTextureLocation("armor_of_swiftness_enhanced", slot, type);
            }
            case ULTIMATE: {
                return this.getTextureLocation("armor_of_swiftness_ultimate", slot, type);
            }
        }
        return this.getTextureLocation("armor_of_swiftness_normal", slot, type);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        Multimap<Attribute, AttributeModifier> multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == this.func_185083_B_()) {
            multimap.put((Object)Attributes.field_233821_d_, (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[equipmentSlot.func_188454_b()], "Armor Swiftness", this.getSpeedBoost(this.tier), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        return multimap;
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @Override
    public void onArmorTick(ItemStack itemStack, World world, PlayerEntity player) {
        super.onArmorTick(itemStack, world, player);
        if (player.field_70173_aa % 45 == 3 && this.func_185083_B_() == EquipmentSlotType.CHEST) {
            boolean flag = true;
            int boost = Integer.MAX_VALUE;
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ArmorOfSwiftnessItem) {
                    int b = this.getJumpBoost(this.getVampirismTier());
                    if (b >= boost) continue;
                    boost = b;
                    continue;
                }
                flag = false;
                break;
            }
            if (flag && boost > -1) {
                player.func_195064_c(new EffectInstance(Effects.field_76430_j, 50, boost, false, false));
            }
        }
    }

    @Override
    protected int getDamageReduction(int slot, ItemStack stack) {
        switch (this.tier) {
            case ULTIMATE: {
                return this.DAMAGE_REDUCTION_ULTIMATE[slot];
            }
            case ENHANCED: {
                return this.DAMAGE_REDUCTION_ENHANCED[slot];
            }
        }
        return this.DAMAGE_REDUCTION_NORMAL[slot];
    }

    private int getJumpBoost(IItemWithTier.TIER tier) {
        switch (tier) {
            case ULTIMATE: {
                return 1;
            }
            case ENHANCED: {
                return 0;
            }
        }
        return -1;
    }

    private double getSpeedBoost(IItemWithTier.TIER tier) {
        switch (tier) {
            case ULTIMATE: {
                return 0.1;
            }
            case ENHANCED: {
                return 0.075;
            }
        }
        return 0.035;
    }

    private String getTextureLocationLeather(EquipmentSlotType slot) {
        return String.format("minecraft:textures/models/armor/leather_layer_%d.png", slot == EquipmentSlotType.LEGS ? 2 : 1);
    }
}

