/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class HolyWaterBottleItem
extends Item
implements IItemWithTier,
IFactionExclusiveItem {
    private final IItemWithTier.TIER tier;
    private String descriptionId;

    public HolyWaterBottleItem(IItemWithTier.TIER tier) {
        this(tier, new Item.Properties().func_200916_a(VampirismMod.creativeTab));
    }

    protected HolyWaterBottleItem(IItemWithTier.TIER tier, Item.Properties props) {
        super(props);
        this.tier = tier;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(tooltip);
    }

    @Override
    @Nonnull
    public IFaction<?> getExclusiveFaction() {
        return VReference.HUNTER_FACTION;
    }

    public EnumStrength getStrength(IItemWithTier.TIER tier) {
        switch (tier) {
            case NORMAL: {
                return EnumStrength.WEAK;
            }
            case ENHANCED: {
                return EnumStrength.MEDIUM;
            }
            case ULTIMATE: {
                return EnumStrength.STRONG;
            }
        }
        return EnumStrength.NONE;
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    protected String func_195935_o() {
        if (this.descriptionId == null) {
            this.descriptionId = super.func_195935_o().replaceAll("_normal|_enhanced|_ultimate", "");
        }
        return this.descriptionId;
    }
}

