/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items.crossbow;

import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.crossbow.VampirismCrossbowItem;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class TechCrossbowItem
extends VampirismCrossbowItem {
    public TechCrossbowItem(Item.Properties properties, float arrowVelocity, int chargeTime, ItemTier itemTier) {
        super(properties, arrowVelocity, chargeTime, itemTier);
    }

    @Override
    @Nullable
    public ISkill getRequiredSkill(@Nonnull ItemStack stack) {
        return (ISkill)HunterSkills.TECH_WEAPONS.get();
    }

    @Nonnull
    public Predicate<ItemStack> func_220004_b() {
        return stack -> stack.func_77973_b() == ModItems.TECH_CROSSBOW_AMMO_PACKAGE.get();
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World p_77659_1_, PlayerEntity p_77659_2_, @Nonnull Hand p_77659_3_) {
        ItemStack itemstack = p_77659_2_.func_184586_b(p_77659_3_);
        if (TechCrossbowItem.func_220012_d((ItemStack)itemstack)) {
            if (this.performShootingMod(p_77659_1_, (LivingEntity)p_77659_2_, p_77659_3_, itemstack, this.getShootingPowerMod(itemstack), 1.0f)) {
                TechCrossbowItem.func_220011_a((ItemStack)itemstack, (boolean)false);
            } else {
                p_77659_2_.func_184811_cZ().func_185145_a((Item)this, 10);
            }
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        if (!p_77659_2_.func_213356_f(itemstack).func_190926_b()) {
            if (!TechCrossbowItem.func_220012_d((ItemStack)itemstack)) {
                this.field_220034_c = false;
                this.field_220035_d = false;
                p_77659_2_.func_184598_c(p_77659_3_);
            }
            return ActionResult.func_226249_b_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    @Override
    public boolean performShootingMod(World p_220014_0_, LivingEntity p_220014_1_, Hand p_220014_2_, ItemStack p_220014_3_, float p_220014_4_, float p_220014_5_) {
        boolean flag;
        List list = TechCrossbowItem.func_220018_j((ItemStack)p_220014_3_);
        float[] afloat = TechCrossbowItem.func_220028_a((Random)p_220014_1_.func_70681_au());
        ItemStack itemstack = this.getProjectile(p_220014_1_, p_220014_3_, list);
        boolean bl = flag = p_220014_1_ instanceof PlayerEntity && ((PlayerEntity)p_220014_1_).field_71075_bZ.field_75098_d;
        if (!itemstack.func_190926_b()) {
            this.shootProjectileMod(p_220014_0_, p_220014_1_, p_220014_2_, p_220014_3_, itemstack, afloat[0], flag, p_220014_4_, p_220014_5_, 0.0f);
        }
        TechCrossbowItem.func_220015_a((World)p_220014_0_, (LivingEntity)p_220014_1_, (ItemStack)p_220014_3_);
        TechCrossbowItem.setChargedProjectiles(p_220014_3_, list);
        return list.isEmpty();
    }

    private static void setChargedProjectiles(ItemStack p_220014_0_, List<ItemStack> p_220014_1_) {
        CompoundNBT compoundnbt = p_220014_0_.func_196082_o();
        ListNBT list = new ListNBT();
        p_220014_1_.forEach(stack -> {
            CompoundNBT stackNbt = new CompoundNBT();
            stack.func_77955_b(stackNbt);
            list.add((Object)stackNbt);
        });
        compoundnbt.func_218657_a("ChargedProjectiles", (INBT)list);
    }

    @Override
    public boolean func_82789_a(@Nonnull ItemStack crossbow, ItemStack repairItem) {
        return Tags.Items.INGOTS_IRON.func_230235_a_((Object)repairItem.func_77973_b());
    }

    private ItemStack getProjectile(LivingEntity entity, ItemStack crossbow, List<ItemStack> projectiles) {
        int frugal = this.isFrugal(crossbow);
        if (frugal > 0 && field_77697_d.nextInt(Math.max(2, 4 - frugal)) == 0) {
            return projectiles.get(0).func_77946_l();
        }
        return projectiles.remove(0);
    }

    @Override
    protected boolean canBeInfinit(ItemStack crossbow) {
        return false;
    }

    @Override
    public int getChargeDurationMod(ItemStack crossbow) {
        return this.chargeTime;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.field_222193_H && enchantment != Enchantments.field_185312_x && super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

