/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide;

import de.maxanier.guideapi.api.IGuideBook;
import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.IRecipeRenderer;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.BookBinder;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.BookHelper;
import de.maxanier.guideapi.api.util.PageHelper;
import de.maxanier.guideapi.category.CategoryItemStack;
import de.maxanier.guideapi.entry.EntryItemStack;
import de.maxanier.guideapi.entry.EntryResourceLocation;
import de.maxanier.guideapi.page.PageEntity;
import de.maxanier.guideapi.page.PageHolderWithLinks;
import de.maxanier.guideapi.page.PageIRecipe;
import de.maxanier.guideapi.page.PageImage;
import de.maxanier.guideapi.page.PageText;
import de.maxanier.guideapi.page.PageTextImage;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.blocks.AltarPillarBlock;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModOils;
import de.teamlapen.vampirism.core.ModTasks;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.inventory.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.inventory.recipes.ShapedWeaponTableRecipe;
import de.teamlapen.vampirism.inventory.recipes.ShapelessWeaponTableRecipe;
import de.teamlapen.vampirism.items.BloodBottleItem;
import de.teamlapen.vampirism.items.MinionUpgradeItem;
import de.teamlapen.vampirism.items.OilBottle;
import de.teamlapen.vampirism.items.PureBloodItem;
import de.teamlapen.vampirism.modcompat.guide.EntryText;
import de.teamlapen.vampirism.modcompat.guide.GuideHelper;
import de.teamlapen.vampirism.modcompat.guide.VampirismGuideBookCategoriesEvent;
import de.teamlapen.vampirism.modcompat.guide.pages.PagePotionTableMix;
import de.teamlapen.vampirism.modcompat.guide.pages.PageTable;
import de.teamlapen.vampirism.modcompat.guide.recipes.AlchemicalCauldronRecipeRenderer;
import de.teamlapen.vampirism.modcompat.guide.recipes.ShapedWeaponTableRecipeRenderer;
import de.teamlapen.vampirism.modcompat.guide.recipes.ShapelessWeaponTableRecipeRenderer;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.player.hunter.actions.DisguiseHunterAction;
import de.teamlapen.vampirism.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.player.vampire.VampireLevelingConf;
import de.teamlapen.vampirism.player.vampire.actions.InfectAction;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import java.awt.Color;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@de.maxanier.guideapi.api.GuideBook
public class GuideBook
implements IGuideBook {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String IMAGE_BASE = "vampirismguide:textures/images/";
    private static Book guideBook;

    static void buildCategories(List<CategoryAbstract> categories) {
        LOGGER.debug("Building content");
        long start = System.currentTimeMillis();
        BookHelper helper = new BookHelper.Builder("vampirism").setBaseKey("guide.vampirism").setLocalizer(GuideBook::translateComponent).setRecipeRendererSupplier(GuideBook::getRenderer).build();
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildOverview(helper), (ITextComponent)GuideBook.translateComponent("guide.vampirism.overview.title", new Object[0]), new ItemStack((IItemProvider)ModItems.VAMPIRE_FANG.get())));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildVampire(helper), (ITextComponent)GuideBook.translateComponent("guide.vampirism.vampire.title", new Object[0]), BloodBottleItem.getStackWithDamage(9)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildHunter(helper), (ITextComponent)GuideBook.translateComponent("guide.vampirism.hunter.title", new Object[0]), new ItemStack((IItemProvider)ModItems.HUMAN_HEART.get())));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildCreatures(helper), (ITextComponent)GuideBook.translateComponent("guide.vampirism.entity.title", new Object[0]), new ItemStack((IItemProvider)Items.field_196186_dz)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildWorld(helper), (ITextComponent)GuideBook.translateComponent("guide.vampirism.world.title", new Object[0]), new ItemStack((IItemProvider)ModBlocks.CURSED_EARTH.get())));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildItems(helper), (ITextComponent)GuideBook.translateComponent("guide.vampirism.items.title", new Object[0]), new ItemStack((IItemProvider)Items.field_151034_e)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildBlocks(helper), (ITextComponent)GuideBook.translateComponent("guide.vampirism.blocks.title", new Object[0]), new ItemStack((IItemProvider)ModBlocks.CASTLE_BLOCK_DARK_BRICK.get())));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildChangelog(helper), (ITextComponent)GuideBook.translateComponent("guide.vampirism.changelog.title", new Object[0]), new ItemStack((IItemProvider)Items.field_151099_bA)));
        MinecraftForge.EVENT_BUS.post((Event)new VampirismGuideBookCategoriesEvent(categories));
        helper.registerLinkablePages(categories);
        LOGGER.debug("Built content in {} ms", (Object)(System.currentTimeMillis() - start));
    }

    @Nullable
    private static IRecipeRenderer getRenderer(IRecipe<?> recipe) {
        IRecipeRenderer recipeRenderer = PageIRecipe.getRenderer(recipe);
        if (recipeRenderer != null) {
            return recipeRenderer;
        }
        if (recipe instanceof ShapedWeaponTableRecipe) {
            return new ShapedWeaponTableRecipeRenderer((ShapedWeaponTableRecipe)recipe);
        }
        if (recipe instanceof ShapelessWeaponTableRecipe) {
            return new ShapelessWeaponTableRecipeRenderer((ShapelessWeaponTableRecipe)recipe);
        }
        if (recipe instanceof AlchemicalCauldronRecipe) {
            return new AlchemicalCauldronRecipeRenderer((AlchemicalCauldronRecipe)recipe);
        }
        LOGGER.warn("Did not find renderer for recipe {}", recipe);
        return null;
    }

    private static Map<ResourceLocation, EntryAbstract> buildOverview(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.overview.";
        ArrayList<IPage> introPages = new ArrayList<IPage>();
        introPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "intro.text", new Object[0])));
        entries.put(new ResourceLocation(base + "intro"), (EntryAbstract)new EntryText(introPages, (ITextComponent)GuideBook.translateComponent(base + "intro", new Object[0])));
        ArrayList<IPage> gettingStartedPages = new ArrayList<IPage>();
        PageText p = new PageText((ITextProperties)GuideBook.translateComponent(base + "getting_started.text", new Object[0]));
        p = new PageHolderWithLinks(helper, (IPage)p).addLink("guide.vampirism.vampire.getting_started").addLink("guide.vampirism.hunter.getting_started");
        gettingStartedPages.add((IPage)p);
        entries.put(new ResourceLocation(base + "getting_started"), (EntryAbstract)new EntryText(gettingStartedPages, (ITextComponent)GuideBook.translateComponent(base + "getting_started", new Object[0])));
        ArrayList<IPage> configPages = new ArrayList<IPage>();
        configPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "config.text", new Object[0])));
        configPages.addAll(PageHelper.pagesForLongText((ITextProperties)ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{GuideBook.translateComponent(base + "config.general.text", new Object[0]), GuideBook.translateComponent(base + "config.general.examples", new Object[0])})));
        configPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "config.balance.text", new Object[0])));
        entries.put(new ResourceLocation(base + "config"), (EntryAbstract)new EntryText(configPages, (ITextComponent)GuideBook.translateComponent(base + "config", new Object[0])));
        ArrayList<IPage> troublePages = new ArrayList<IPage>();
        troublePages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "trouble.text", new Object[0])));
        helper.addLinks(troublePages, new Object[]{new GuideHelper.URLLink((ITextComponent)GuideBook.translateComponent(base + "trouble", new Object[0]), URI.create("https://github.com/TeamLapen/Vampirism/wiki/Troubleshooting"))});
        entries.put(new ResourceLocation(base + "trouble"), (EntryAbstract)new EntryText(troublePages, (ITextComponent)GuideBook.translateComponent(base + "trouble", new Object[0])));
        ArrayList<IPage> devPages = new ArrayList<IPage>();
        GuideHelper.URLLink helpLink = new GuideHelper.URLLink((ITextComponent)new StringTextComponent("How to help"), URI.create("https://github.com/TeamLapen/Vampirism/wiki#how-you-can-help"));
        devPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "dev.text", new Object[0])), new Object[]{helpLink}));
        entries.put(new ResourceLocation(base + "dev"), (EntryAbstract)new EntryText(devPages, (ITextComponent)GuideBook.translateComponent(base + "dev", new Object[0])));
        ArrayList<IPage> supportPages = new ArrayList<IPage>();
        supportPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "support.text", new Object[0])));
        PageHolderWithLinks.URLLink linkCurseForge = new PageHolderWithLinks.URLLink("CurseForge", URI.create("https://minecraft.curseforge.com/projects/vampirism-become-a-vampire"));
        helper.addLinks(supportPages, new Object[]{linkCurseForge, new ResourceLocation(base + "dev")});
        entries.put(new ResourceLocation(base + "support"), (EntryAbstract)new EntryText(supportPages, (ITextComponent)GuideBook.translateComponent(base + "support", new Object[0])));
        ArrayList<IPage> creditsPages = new ArrayList<IPage>();
        String lang = VampLib.proxy.getActiveLanguage();
        String credits = "\u00a7lDeveloper:\u00a7r\nMaxanier\nCheaterpaul\n\u00a7lThanks to:\u00a7r\nMistadon\nwildbill22\n1LiterZinalco\nAlis\ndimensionpainter\nS_olace\nPiklach\n\n\u00a7lTranslators:\u00a7r\n\u00a7b" + lang + "\u00a7r\n" + GuideBook.translateComponent("text.vampirism.translators", new Object[0]).getString();
        creditsPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(credits, new Object[0])));
        entries.put(new ResourceLocation(base + "credits"), (EntryAbstract)new EntryText(creditsPages, (ITextComponent)GuideBook.translateComponent(base + "credits", new Object[0])));
        return entries;
    }

    private static String loc(Block b) {
        return UtilLib.translate(b.func_149739_a(), new Object[0]);
    }

    private static String loc(Item i) {
        return UtilLib.translate(i.func_77658_a(), new Object[0]);
    }

    private static Map<ResourceLocation, EntryAbstract> buildVampire(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.vampire.";
        ArrayList<IPage> gettingStarted = new ArrayList<IPage>();
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "getting_started.become", new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "getting_started.as_vampire", new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "getting_started.zombie", new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "getting_started.blood", new TranslationTextComponent(ModKeys.getKeyBinding(ModKeys.KEY.SUCK).func_197982_m()))));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "getting_started.infecting", ((InfectAction)VampireActions.INFECT.get()).getName())));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{GuideBook.translateComponent(base + "getting_started.level", new Object[0]), GuideBook.translateComponent(base + "getting_started.level2", new Object[0])})));
        entries.put(new ResourceLocation(base + "getting_started"), (EntryAbstract)new EntryText(gettingStarted, (ITextComponent)GuideBook.translateComponent(base + "getting_started", new Object[0])));
        ArrayList<IPage> bloodPages = new ArrayList<IPage>();
        bloodPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "blood.text", GuideBook.loc((Item)ModItems.BLOOD_BOTTLE.get()), GuideBook.loc(Items.field_151069_bo))));
        bloodPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "blood.storage", GuideBook.loc((Block)ModBlocks.BLOOD_CONTAINER.get()))), new Object[]{new ResourceLocation("guide.vampirism.blocks.blood_container")}));
        bloodPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "blood.biteable_creatures", new Object[0])), new Object[]{new PageHolderWithLinks.URLLink("Biteable Creatures", URI.create("https://github.com/TeamLapen/Vampirism/wiki/Biteable-Creatures"))}));
        entries.put(new ResourceLocation(base + "blood"), (EntryAbstract)new EntryText(bloodPages, (ITextComponent)GuideBook.translateComponent(base + "blood", new Object[0])));
        VampireLevelingConf levelingConf = VampireLevelingConf.getInstance();
        ArrayList<IPage> levelingPages = new ArrayList<IPage>();
        levelingPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "leveling.intro", new Object[0])));
        String altarOfInspiration = "\u00a7l" + GuideBook.loc((Block)ModBlocks.ALTAR_INSPIRATION.get()) + "\u00a7r\n\u00a7o" + GuideBook.translate(base + "leveling.inspiration.reach", new Object[0]) + "\u00a7r\n";
        altarOfInspiration = altarOfInspiration + GuideBook.translate(base + "leveling.inspiration.text", new Object[0]) + "\n";
        altarOfInspiration = altarOfInspiration + GuideBook.translate(base + "leveling.inspiration.requirements", levelingConf.getRequiredBloodForAltarInspiration(2), levelingConf.getRequiredBloodForAltarInspiration(3), levelingConf.getRequiredBloodForAltarInspiration(4));
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(altarOfInspiration)), new Object[]{new ResourceLocation("guide.vampirism.blocks.altar_inspiration")}));
        String altarOfInfusion = "\u00a7l" + GuideBook.loc((Block)ModBlocks.ALTAR_INFUSION.get()) + "\u00a7r\n\u00a7o" + GuideBook.translate(base + "leveling.infusion.reach", new Object[0]) + "\u00a7r\n";
        altarOfInfusion = altarOfInfusion + GuideBook.translate(base + "leveling.infusion.intro", GuideBook.loc((Block)ModBlocks.ALTAR_INFUSION.get()), GuideBook.loc((Block)ModBlocks.ALTAR_PILLAR.get()), GuideBook.loc((Block)ModBlocks.ALTAR_TIP.get()));
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(altarOfInfusion)), new Object[]{new ResourceLocation("guide.vampirism.blocks.altar_infusion")}));
        StringBuilder blocks = new StringBuilder();
        for (AltarPillarBlock.EnumPillarType t : AltarPillarBlock.EnumPillarType.values()) {
            if (t == AltarPillarBlock.EnumPillarType.NONE) continue;
            blocks.append(GuideBook.translate(t.fillerBlock.func_149739_a(), new Object[0])).append("(").append(t.getValue()).append("),");
        }
        levelingPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "leveling.infusion.structure", blocks.toString())));
        String items = GuideBook.loc((Item)ModItems.HUMAN_HEART.get()) + ", " + GuideBook.loc((Item)ModItems.PURE_BLOOD_0.get()) + ", " + GuideBook.loc((Item)ModItems.VAMPIRE_BOOK.get());
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "leveling.infusion.items", items)), new Object[]{new ResourceLocation("guide.vampirism.items.human_heart"), new ResourceLocation("guide.vampirism.items.pure_blood_0"), new ResourceLocation("guide.vampirism.items.vampire_book")}));
        PageTable.Builder requirementsBuilder = new PageTable.Builder(5);
        requirementsBuilder.addUnlocLine("text.vampirism.level_short", base + "leveling.infusion.req.structure_points", ((PureBloodItem)ModItems.PURE_BLOOD_0.get()).func_77658_a(), base + "leveling.infusion.req.heart", base + "leveling.infusion.req.book");
        requirementsBuilder.addLine("5", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(5), "0", "5", "1");
        requirementsBuilder.addLine("6", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(6), "1 Purity(1)", "5", "1");
        requirementsBuilder.addLine("7", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(7), "1 Purity(1)", "10", "1");
        requirementsBuilder.addLine("8", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(8), "1 Purity(2)", "10", "1");
        requirementsBuilder.addLine("9", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(9), "1 Purity(2)", "10", "1");
        requirementsBuilder.addLine("10", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(10), "1 Purity(3)", "15", "1");
        requirementsBuilder.addLine("11", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(11), "1 Purity(3)", "15", "1");
        requirementsBuilder.addLine("12", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(12), "1 Purity(4)", "20", "1");
        requirementsBuilder.addLine("13", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(13), "2 Purity(4)", "20", "1");
        requirementsBuilder.addLine("14", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(14), "2 Purity(5)", "25", "1");
        requirementsBuilder.setHeadline(GuideBook.translateComponent(base + "leveling.infusion.req", new Object[0]));
        PageHolderWithLinks requirementTable = new PageHolderWithLinks(helper, (IPage)requirementsBuilder.build());
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.human_heart"));
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.vampire_book"));
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.pure_blood_0"));
        levelingPages.add((IPage)requirementTable);
        levelingPages.add((IPage)new PageTextImage((ITextProperties)GuideBook.translateComponent(base + "leveling.infusion.image1", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion1.png"), false));
        levelingPages.add((IPage)new PageTextImage((ITextProperties)GuideBook.translateComponent(base + "leveling.infusion.image2", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion2.png"), false));
        levelingPages.add((IPage)new PageTextImage((ITextProperties)GuideBook.translateComponent(base + "leveling.infusion.image3", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion3.png"), false));
        levelingPages.add((IPage)new PageTextImage((ITextProperties)GuideBook.translateComponent(base + "leveling.infusion.image4", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion4.png"), false));
        levelingPages.add((IPage)new PageTextImage((ITextProperties)GuideBook.translateComponent(base + "leveling.infusion.image5", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion5.png"), false));
        entries.put(new ResourceLocation(base + "leveling"), (EntryAbstract)new EntryText(levelingPages, (ITextComponent)GuideBook.translateComponent(base + "leveling", new Object[0])));
        ArrayList<IPage> skillPages = new ArrayList<IPage>();
        skillPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "skills.text", new Object[0])), new Object[]{new ResourceLocation(base + "vampirism_menu")}));
        skillPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "skills.actions", UtilLib.translate(ModKeys.getKeyBinding(ModKeys.KEY.ACTION).func_197982_m(), new Object[0]))));
        skillPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent("guide.vampirism.skills.bind_action", new Object[0])));
        skillPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "skills.actions2", new Object[0])));
        skillPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "skills.refinements", new Object[0])), new Object[]{new ResourceLocation("guide.vampirism.items.accessories")}));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, (ITextComponent)GuideBook.translateComponent(base + "skills", new Object[0])));
        ArrayList<IPage> armorPages = new ArrayList<IPage>(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "armor.text", new Object[0])), new Object[]{new ResourceLocation("guide.vampirism.items.accessories")}));
        entries.put(new ResourceLocation(base + "armor"), (EntryAbstract)new EntryText(armorPages, (ITextComponent)GuideBook.translateComponent(base + "armor", new Object[0])));
        ArrayList<IPage> dbnoPages = new ArrayList<IPage>(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "dbno.text", ((VampirismEffect)ModEffects.NEONATAL.get()).func_199286_c())));
        entries.put(new ResourceLocation(base + "dbno"), (EntryAbstract)new EntryText(dbnoPages, (ITextComponent)GuideBook.translateComponent(base + "dbno", new Object[0])));
        ArrayList<IPage> lordPages = new ArrayList<IPage>();
        lordPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "lord.text", ((EntityType)ModEntities.TASK_MASTER_VAMPIRE.get()).func_212546_e().getString(), VReference.VAMPIRE_FACTION.getLordTitle(1, false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(1, true).getString(), VReference.VAMPIRE_FACTION.getLordTitle(VReference.VAMPIRE_FACTION.getHighestLordLevel(), false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(VReference.VAMPIRE_FACTION.getHighestLordLevel(), true).getString())), new Object[]{new ResourceLocation("guide.vampirism.entity.taskmaster")}));
        PageTable.Builder lordTitleBuilder = new PageTable.Builder(3).setHeadline(GuideBook.translateComponent(base + "lord.titles", new Object[0]));
        lordTitleBuilder.addUnlocLine("text.vampirism.level", "text.vampirism.title", "text.vampirism.title");
        lordTitleBuilder.addLine(1, VReference.VAMPIRE_FACTION.getLordTitle(1, false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(1, true).getString());
        lordTitleBuilder.addLine(2, VReference.VAMPIRE_FACTION.getLordTitle(2, false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(2, true).getString());
        lordTitleBuilder.addLine(3, VReference.VAMPIRE_FACTION.getLordTitle(3, false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(3, true).getString());
        lordTitleBuilder.addLine(4, VReference.VAMPIRE_FACTION.getLordTitle(4, false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(4, true).getString());
        lordTitleBuilder.addLine(5, VReference.VAMPIRE_FACTION.getLordTitle(5, false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(5, true).getString());
        lordPages.add((IPage)lordTitleBuilder.build());
        lordPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "lord.minion", GuideBook.loc((Item)ModItems.VAMPIRE_MINION_BINDING.get()), GuideBook.loc((Item)ModItems.VAMPIRE_MINION_UPGRADE_SIMPLE.get()), GuideBook.loc((Item)ModItems.VAMPIRE_MINION_UPGRADE_ENHANCED.get()), GuideBook.loc((Item)ModItems.VAMPIRE_MINION_UPGRADE_SPECIAL.get()))), new Object[]{new ResourceLocation("guide.vampirism.items.vampire_minion_binding")}));
        lordPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent("guide.vampirism.common.minion_control", GuideBook.translate(ModKeys.getKeyBinding(ModKeys.KEY.MINION).func_197982_m(), new Object[0]), GuideBook.translate("text.vampirism.minion.call_single", new Object[0]), GuideBook.translate("text.vampirism.minion.respawn", new Object[0]))), new Object[0]));
        entries.put(new ResourceLocation(base + "lord"), (EntryAbstract)new EntryText(lordPages, (ITextComponent)new TranslationTextComponent(base + "lord")));
        ArrayList<IPage> vampirismMenu = new ArrayList<IPage>(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent("guide.vampirism.overview.vampirism_menu.text", GuideBook.translateComponent(ModKeys.getKeyBinding(ModKeys.KEY.SKILL).func_197982_m(), new Object[0])).func_230529_a_((ITextComponent)GuideBook.translateComponent("guide.vampirism.overview.vampirism_menu.text_vampire", GuideBook.translateComponent("guide.vampirism.items.accessories", new Object[0])))));
        entries.put(new ResourceLocation(base + "vampirism_menu"), (EntryAbstract)new EntryText(vampirismMenu, (ITextComponent)GuideBook.translateComponent("guide.vampirism.overview.vampirism_menu", new Object[0])));
        ArrayList<IPage> unvampirePages = new ArrayList<IPage>();
        unvampirePages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "unvampire.text", GuideBook.loc((Block)ModBlocks.CHURCH_ALTAR.get()))));
        entries.put(new ResourceLocation(base + "unvampire"), (EntryAbstract)new EntryText(unvampirePages, (ITextComponent)GuideBook.translateComponent(base + "unvampire", new Object[0])));
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildHunter(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.hunter.";
        ArrayList<IPage> gettingStarted = new ArrayList<IPage>();
        IFormattableTextComponent become = GuideBook.translateComponent(base + "getting_started.become", GuideBook.translateComponent(((EntityType)ModEntities.HUNTER_TRAINER.get()).func_210760_d(), new Object[0]), GuideBook.loc((Item)ModItems.INJECTION_GARLIC.get()));
        gettingStarted.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)become), new Object[]{new ResourceLocation("guide.vampirism.items.injection_empty")}));
        gettingStarted.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/hunter_trainer.png")));
        gettingStarted.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "getting_started.as_hunter", new Object[0])));
        entries.put(new ResourceLocation(base + "getting_started"), (EntryAbstract)new EntryText(gettingStarted, (ITextComponent)GuideBook.translateComponent(base + "getting_started", new Object[0])));
        HunterLevelingConf levelingConf = HunterLevelingConf.instance();
        ArrayList<IPage> levelingPages = new ArrayList<IPage>();
        levelingPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "leveling.intro", new Object[0])));
        String train1 = "\u00a7l" + GuideBook.translate(base + "leveling.to_reach", "2-4") + "\u00a7r\n";
        train1 = train1 + GuideBook.translate(base + "leveling.train1.text", levelingConf.getVampireBloodCountForBasicHunter(2), levelingConf.getVampireBloodCountForBasicHunter(3), levelingConf.getVampireBloodCountForBasicHunter(4));
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(train1)), new Object[]{new ResourceLocation("guide.vampirism.items.stake"), new ResourceLocation("guide.vampirism.items.vampire_blood_bottle")}));
        String train2 = "\u00a7l" + GuideBook.translate(base + "leveling.to_reach", "5+") + "\u00a7r\n";
        train2 = train2 + GuideBook.translate(base + "leveling.train2.text", GuideBook.loc((Block)ModBlocks.HUNTER_TABLE.get()), GuideBook.loc((Block)ModBlocks.WEAPON_TABLE.get()), GuideBook.loc((Block)ModBlocks.POTION_TABLE.get()), GuideBook.loc((Block)ModBlocks.ALCHEMICAL_CAULDRON.get()));
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)new TranslationTextComponent(train2)), new Object[]{new ResourceLocation("guide.vampirism.blocks.hunter_table"), new ResourceLocation("guide.vampirism.blocks.weapon_table"), new ResourceLocation("guide.vampirism.blocks.alchemical_cauldron"), new ResourceLocation("guide.vampirism.blocks.potion_table")}));
        PageTable.Builder builder = new PageTable.Builder(4);
        builder.addUnlocLine("text.vampirism.level", base + "leveling.train2.fang", GuideBook.loc((Item)ModItems.PURE_BLOOD_0.get()), GuideBook.loc((Item)ModItems.VAMPIRE_BOOK.get()));
        for (int i = levelingConf.TABLE_MIN_LEVEL; i <= levelingConf.TABLE_MAX_LEVEL; ++i) {
            int[] req = levelingConf.getItemRequirementsForTable(i);
            String pure = "";
            if (req[1] > 0) {
                pure = "" + req[1] + " Purity(" + (req[2] + 1) + ")";
            }
            builder.addLine(i, req[0], pure, req[3]);
        }
        builder.setHeadline(GuideBook.translateComponent(base + "leveling.train2.req", new Object[0]));
        PageHolderWithLinks requirementsTable = new PageHolderWithLinks(helper, (IPage)builder.build());
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.vampire_fang"));
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.pure_blood_0"));
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.vampire_book"));
        levelingPages.add((IPage)requirementsTable);
        entries.put(new ResourceLocation(base + "leveling"), (EntryAbstract)new EntryText(levelingPages, (ITextComponent)GuideBook.translateComponent(base + "leveling", new Object[0])));
        ArrayList<IPage> skillPages = new ArrayList<IPage>();
        skillPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "skills.intro", new Object[0])), new Object[]{new ResourceLocation(base + "vampirism_menu")}));
        String disguise = String.format("\u00a7l%s\u00a7r\n", ((DisguiseHunterAction)HunterActions.DISGUISE_HUNTER.get()).getName().getString());
        disguise = disguise + GuideBook.translate(base + "skills.disguise.text", ModKeys.getKeyBinding(ModKeys.KEY.ACTION).func_197982_m());
        skillPages.addAll(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(disguise)));
        String weaponTable = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc((Block)ModBlocks.WEAPON_TABLE.get()));
        weaponTable = weaponTable + GuideBook.translate(base + "skills.weapon_table.text", new Object[0]);
        skillPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(weaponTable)), new Object[]{new ResourceLocation("guide.vampirism.blocks.weapon_table")}));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, (ITextComponent)GuideBook.translateComponent(base + "skills", new Object[0])));
        String potionTable = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc((Block)ModBlocks.POTION_TABLE.get()));
        potionTable = potionTable + GuideBook.translate(base + "skills.potion_table.text", new Object[0]);
        ArrayList<IPage> potionTablePages = new ArrayList<IPage>(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(potionTable)));
        potionTablePages.addAll(Arrays.asList(GuideBook.generatePotionMixes()));
        skillPages.addAll(helper.addLinks(potionTablePages, new Object[]{new ResourceLocation("guide.vampirism.blocks.potion_table")}));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, (ITextComponent)new TranslationTextComponent(base + "skills")));
        ArrayList<IPage> vampSlayerPages = new ArrayList<IPage>();
        vampSlayerPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "vamp_slayer.intro", new Object[0])));
        String garlic = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc((Item)ModItems.ITEM_GARLIC.get()));
        garlic = garlic + GuideBook.translate(base + "vamp_slayer.garlic", new Object[0]) + "\n" + GuideBook.translate(base + "vamp_slayer.garlic2", new Object[0]) + "\n" + GuideBook.translate(base + "vamp_slayer.garlic.diffusor", new Object[0]);
        vampSlayerPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(garlic)), new Object[]{new ResourceLocation("guide.vampirism.blocks.garlic_beacon_normal")}));
        String holyWater = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc((Item)ModItems.HOLY_WATER_BOTTLE_NORMAL.get()));
        holyWater = holyWater + GuideBook.translate(base + "vamp_slayer.holy_water", new Object[0]);
        vampSlayerPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(holyWater)), new Object[]{new ResourceLocation("guide.vampirism.items.holy_water_bottle")}));
        String fire = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc(Blocks.field_150480_ab));
        fire = fire + GuideBook.translate(base + "vamp_slayer.fire", new Object[0]);
        vampSlayerPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)new StringTextComponent(fire)), new Object[]{new ResourceLocation("guide.vampirism.items.item_alchemical_fire"), new ResourceLocation("guide.vampirism.items.crossbow_arrow_normal")}));
        entries.put(new ResourceLocation(base + "vamp_slayer"), (EntryAbstract)new EntryText(vampSlayerPages, (ITextComponent)GuideBook.translateComponent(base + "vamp_slayer", new Object[0])));
        ArrayList<IPage> lordPages = new ArrayList<IPage>();
        lordPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "lord.text", ((EntityType)ModEntities.TASK_MASTER_HUNTER.get()).func_212546_e().getString(), VReference.HUNTER_FACTION.getLordTitle(1, false).getString(), VReference.HUNTER_FACTION.getLordTitle(VReference.HUNTER_FACTION.getHighestLordLevel(), false).getString())), new Object[]{new ResourceLocation("guide.vampirism.entity.taskmaster")}));
        PageTable.Builder lordTitleBuilder = new PageTable.Builder(2);
        lordTitleBuilder.setHeadline(GuideBook.translateComponent(base + "lord.titles", new Object[0]));
        lordTitleBuilder.addUnlocLine("text.vampirism.level", "text.vampirism.title");
        lordTitleBuilder.addLine(1, VReference.HUNTER_FACTION.getLordTitle(1, false).getString());
        lordTitleBuilder.addLine(2, VReference.HUNTER_FACTION.getLordTitle(2, false).getString());
        lordTitleBuilder.addLine(3, VReference.HUNTER_FACTION.getLordTitle(3, false).getString());
        lordTitleBuilder.addLine(4, VReference.HUNTER_FACTION.getLordTitle(4, false).getString());
        lordTitleBuilder.addLine(5, VReference.HUNTER_FACTION.getLordTitle(5, false).getString());
        lordPages.add((IPage)lordTitleBuilder.build());
        lordPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "lord.minion", GuideBook.loc((Item)ModItems.HUNTER_MINION_EQUIPMENT.get()), GuideBook.loc((Item)ModItems.HUNTER_MINION_UPGRADE_SIMPLE.get()), GuideBook.loc((Item)ModItems.HUNTER_MINION_UPGRADE_ENHANCED.get()), GuideBook.loc((Item)ModItems.HUNTER_MINION_UPGRADE_SPECIAL.get()))), new Object[]{new ResourceLocation("guide.vampirism.items.hunter_minion_equipment")}));
        lordPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent("guide.vampirism.common.minion_control", GuideBook.translate(ModKeys.getKeyBinding(ModKeys.KEY.MINION).func_197982_m(), new Object[0]), GuideBook.translate("text.vampirism.minion.call_single", new Object[0]), GuideBook.translate("text.vampirism.minion.respawn", new Object[0]))), new Object[0]));
        entries.put(new ResourceLocation(base + "lord"), (EntryAbstract)new EntryText(lordPages, (ITextComponent)new TranslationTextComponent(base + "lord")));
        ArrayList<IPage> vampirismMenu = new ArrayList<IPage>(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent("guide.vampirism.overview.vampirism_menu.text", GuideBook.translate(ModKeys.getKeyBinding(ModKeys.KEY.SKILL).func_197982_m(), new Object[0]))));
        entries.put(new ResourceLocation(base + "vampirism_menu"), (EntryAbstract)new EntryText(vampirismMenu, (ITextComponent)GuideBook.translateComponent("guide.vampirism.overview.vampirism_menu", new Object[0])));
        ArrayList<IPage> unHunterPages = new ArrayList<IPage>();
        unHunterPages.addAll(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "unhunter.text", GuideBook.loc((Item)ModItems.INJECTION_SANGUINARE.get()), GuideBook.loc((Block)ModBlocks.MED_CHAIR.get()))), new Object[]{new ResourceLocation("guide.vampirism.items.injection_empty"), new ResourceLocation("guide.vampirism.blocks.item_med_chair")}));
        entries.put(new ResourceLocation(base + "unhunter"), (EntryAbstract)new EntryText(unHunterPages, (ITextComponent)GuideBook.translateComponent(base + "unhunter", new Object[0])));
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildCreatures(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.entity.";
        ArrayList<IPage> generalPages = new ArrayList<IPage>(PageHelper.pagesForLongText((ITextProperties)ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{GuideBook.translateComponent(base + "general.text", new Object[0]), GuideBook.translateComponent(base + "general.text2", new Object[0])})));
        entries.put(new ResourceLocation(base + "general"), (EntryAbstract)new EntryText(generalPages, (ITextComponent)GuideBook.translateComponent(base + "general", new Object[0])));
        ArrayList<IPage> hunterPages = new ArrayList<IPage>();
        hunterPages.add((IPage)new PageEntity(world -> {
            BasicHunterEntity entity = (BasicHunterEntity)((EntityType)ModEntities.HUNTER.get()).func_200721_a(world);
            entity.setLevel(1);
            return entity;
        }));
        hunterPages.add((IPage)new PageEntity(world -> {
            BasicHunterEntity entity = (BasicHunterEntity)((EntityType)ModEntities.HUNTER.get()).func_200721_a(world);
            entity.setLevel(0);
            return entity;
        }));
        hunterPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "hunter.text", GuideBook.loc((Item)ModItems.HUMAN_HEART.get()))));
        entries.put(new ResourceLocation(base + "hunter"), (EntryAbstract)new EntryText(hunterPages, ((EntityType)ModEntities.HUNTER.get()).func_212546_e()));
        ArrayList<IPage> vampirePages = new ArrayList<IPage>();
        vampirePages.add((IPage)new PageEntity((EntityType)ModEntities.VAMPIRE.get()));
        vampirePages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "vampire.text", GuideBook.loc((Item)ModItems.VAMPIRE_FANG.get()), GuideBook.loc((Item)ModItems.VAMPIRE_BLOOD_BOTTLE.get()), GuideBook.loc((Item)ModItems.STAKE.get()))));
        entries.put(new ResourceLocation(base + "vampire"), (EntryAbstract)new EntryText(vampirePages, ((EntityType)ModEntities.VAMPIRE.get()).func_212546_e()));
        ArrayList<IPage> advancedHunterPages = new ArrayList<IPage>();
        advancedHunterPages.add((IPage)new PageEntity((EntityType)ModEntities.ADVANCED_HUNTER.get()));
        advancedHunterPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "advanced_hunter.text", new Object[0])));
        entries.put(new ResourceLocation(base + "advanced_hunter"), (EntryAbstract)new EntryText(advancedHunterPages, ((EntityType)ModEntities.ADVANCED_HUNTER.get()).func_212546_e()));
        ArrayList<IPage> advancedVampirePages = new ArrayList<IPage>();
        advancedVampirePages.add((IPage)new PageEntity((EntityType)ModEntities.ADVANCED_VAMPIRE.get()));
        advancedVampirePages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "advanced_vampire.text", GuideBook.loc((Item)ModItems.BLOOD_BOTTLE.get()), GuideBook.loc((Item)ModItems.VAMPIRE_BLOOD_BOTTLE.get()))));
        entries.put(new ResourceLocation(base + "advanced_vampire"), (EntryAbstract)new EntryText(advancedVampirePages, ((EntityType)ModEntities.ADVANCED_VAMPIRE.get()).func_212546_e()));
        ArrayList<IPage> vampireBaronPages = new ArrayList<IPage>();
        vampireBaronPages.add((IPage)new PageEntity((EntityType)ModEntities.VAMPIRE_BARON.get()));
        vampireBaronPages.add((IPage)new PageEntity(world -> {
            VampireBaronEntity baron = (VampireBaronEntity)((EntityType)ModEntities.VAMPIRE_BARON.get()).func_200721_a(world);
            baron.setLady(true);
            return baron;
        }, ((EntityType)ModEntities.VAMPIRE_BARON.get()).func_212546_e()));
        vampireBaronPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "vampire_baron.text", GuideBook.loc((Item)ModItems.PURE_BLOOD_0.get()))));
        helper.addLinks(vampireBaronPages, new Object[]{new ResourceLocation("guide.vampirism.world.vampire_forest")});
        entries.put(new ResourceLocation(base + "vampire_baron"), (EntryAbstract)new EntryText(vampireBaronPages, ((EntityType)ModEntities.VAMPIRE_BARON.get()).func_212546_e()));
        ArrayList<IPage> hunterTrainerPages = new ArrayList<IPage>();
        hunterTrainerPages.add((IPage)new PageEntity((EntityType)ModEntities.HUNTER_TRAINER.get()));
        hunterTrainerPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "hunter_trainer.text", new Object[0])));
        entries.put(new ResourceLocation(base + "hunter_trainer"), (EntryAbstract)new EntryText(hunterTrainerPages, ((EntityType)ModEntities.HUNTER_TRAINER.get()).func_212546_e()));
        ArrayList<IPage> taskMasterPages = new ArrayList<IPage>();
        taskMasterPages.add((IPage)new PageEntity((EntityType)ModEntities.TASK_MASTER_VAMPIRE.get()));
        taskMasterPages.add((IPage)new PageEntity((EntityType)ModEntities.TASK_MASTER_HUNTER.get()));
        taskMasterPages.addAll(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "taskmaster.text", new Object[0])));
        taskMasterPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/taskscreen.png")));
        entries.put(new ResourceLocation(base + "taskmaster"), (EntryAbstract)new EntryText(taskMasterPages, (ITextComponent)new TranslationTextComponent(base + "taskmaster")));
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildWorld(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.world.";
        ArrayList<IPage> vampireForestPages = new ArrayList<IPage>(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "vampire_forest.text", new Object[0])));
        entries.put(new ResourceLocation(base + "vampire_forest"), (EntryAbstract)new EntryText(vampireForestPages, (ITextComponent)GuideBook.translateComponent(base + "vampire_forest", new Object[0])));
        ArrayList<IPage> villagePages = new ArrayList<IPage>(helper.addLinks(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "villages.text", new Object[0]).func_240702_b_("\n").func_230529_a_((ITextComponent)GuideBook.translateComponent(base + "villages.raids", new Object[0]))), new Object[]{new ResourceLocation("guide.vampirism.blocks.totem_base"), new ResourceLocation("guide.vampirism.blocks.totem_top_crafted")}));
        entries.put(new ResourceLocation(base + "villages"), (EntryAbstract)new EntryText(villagePages, (ITextComponent)GuideBook.translateComponent(base + "villages", new Object[0])));
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildItems(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.items.";
        helper.info(new Item[]{(Item)ModItems.VAMPIRE_FANG.get()}).build(entries);
        helper.info(new Item[]{(Item)ModItems.HUMAN_HEART.get()}).build(entries);
        helper.info(new Item[]{(Item)ModItems.PURE_BLOOD_0.get(), (Item)ModItems.PURE_BLOOD_1.get(), (Item)ModItems.PURE_BLOOD_2.get(), (Item)ModItems.PURE_BLOOD_3.get(), (Item)ModItems.PURE_BLOOD_4.get()}).setFormats(new Object[]{GuideBook.translateComponent(((EntityType)ModEntities.VAMPIRE_BARON.get()).func_210760_d(), new Object[0])}).build(entries);
        helper.info(new Item[]{(Item)ModItems.VAMPIRE_BLOOD_BOTTLE.get()}).setFormats(new Object[]{GuideBook.translateComponent(((EntityType)ModEntities.VAMPIRE.get()).func_210760_d(), new Object[0]), GuideBook.translateComponent(((EntityType)ModEntities.ADVANCED_VAMPIRE.get()).func_210760_d(), GuideBook.loc((Item)ModItems.STAKE.get()))}).build(entries);
        helper.info(new Item[]{(Item)ModItems.VAMPIRE_BOOK.get()}).build(entries);
        helper.info(new Item[]{(Item)ModItems.OBLIVION_POTION.get()}).customPages(new IPage[]{GuideHelper.createItemTaskDescription((Task)ModTasks.OBLIVION_POTION.get())}).build(entries);
        helper.info(false, new ItemStack[]{BloodBottleItem.getStackWithDamage(9)}).build(entries);
        helper.info(new Item[]{(Item)ModItems.BLOOD_INFUSED_IRON_INGOT.get()}).recipes(new String[]{"vampire/blood_infused_iron_ingot", "vampire/blood_infused_enhanced_iron_ingot"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.HEART_SEEKER_NORMAL.get(), (Item)ModItems.HEART_SEEKER_ENHANCED.get(), (Item)ModItems.HEART_SEEKER_ULTIMATE.get()}).recipes(new String[]{"vampire/heart_seeker_normal", "vampire/heart_seeker_enhanced"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.HEART_STRIKER_NORMAL.get(), (Item)ModItems.HEART_STRIKER_ENHANCED.get(), (Item)ModItems.HEART_STRIKER_ULTIMATE.get()}).recipes(new String[]{"vampire/heart_striker_normal", "vampire/heart_striker_normal"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.FEEDING_ADAPTER.get()}).customPages(new IPage[]{GuideHelper.createItemTaskDescription((Task)ModTasks.FEEDING_ADAPTER.get())}).build(entries);
        helper.info(new Item[]{(Item)ModItems.VAMPIRE_MINION_BINDING.get(), (Item)ModItems.VAMPIRE_MINION_UPGRADE_SIMPLE.get(), (Item)ModItems.VAMPIRE_MINION_UPGRADE_ENHANCED.get(), (Item)ModItems.VAMPIRE_MINION_UPGRADE_SPECIAL.get()}).setFormats(new Object[]{GuideBook.loc((Item)ModItems.VAMPIRE_MINION_BINDING.get()), GuideBook.loc((Item)ModItems.VAMPIRE_MINION_UPGRADE_SIMPLE.get()), ((MinionUpgradeItem)ModItems.VAMPIRE_MINION_UPGRADE_SIMPLE.get()).getMinLevel() + 1, ((MinionUpgradeItem)ModItems.VAMPIRE_MINION_UPGRADE_SIMPLE.get()).getMaxLevel() + 1, GuideBook.loc((Item)ModItems.VAMPIRE_MINION_UPGRADE_ENHANCED.get()), ((MinionUpgradeItem)ModItems.VAMPIRE_MINION_UPGRADE_ENHANCED.get()).getMinLevel() + 1, ((MinionUpgradeItem)ModItems.VAMPIRE_MINION_UPGRADE_ENHANCED.get()).getMaxLevel() + 1, GuideBook.loc((Item)ModItems.VAMPIRE_MINION_UPGRADE_SPECIAL.get()), ((MinionUpgradeItem)ModItems.VAMPIRE_MINION_UPGRADE_SPECIAL.get()).getMinLevel() + 1, ((MinionUpgradeItem)ModItems.VAMPIRE_MINION_UPGRADE_SPECIAL.get()).getMaxLevel() + 1, GuideBook.translate(((EntityType)ModEntities.TASK_MASTER_VAMPIRE.get()).func_210760_d(), new Object[0])}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.entity.taskmaster"), new ResourceLocation("guide.vampirism.vampire.lord")}).build(entries);
        helper.info(new Item[]{(Item)ModItems.GARLIC_FINDER.get()}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.blocks.garlic_diffusor")}).recipes(new String[]{"vampire/garlic_finder"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.VAMPIRE_CLOTHING_CROWN.get(), (Item)ModItems.VAMPIRE_CLOTHING_HAT.get(), (Item)ModItems.VAMPIRE_CLOTHING_LEGS.get(), (Item)ModItems.VAMPIRE_CLOTHING_BOOTS.get(), (Item)ModItems.VAMPIRE_CLOAK_RED_BLACK.get(), (Item)ModItems.VAMPIRE_CLOAK_BLACK_RED.get(), (Item)ModItems.VAMPIRE_CLOAK_BLACK_BLUE.get(), (Item)ModItems.VAMPIRE_CLOAK_RED_BLACK.get(), (Item)ModItems.VAMPIRE_CLOAK_BLACK_WHITE.get(), (Item)ModItems.VAMPIRE_CLOAK_WHITE_BLACK.get()}).useCustomEntryName().setKeyName("vampire_clothing").recipes(new String[]{"vampire/vampire_clothing_legs", "vampire/vampire_clothing_boots", "vampire/vampire_clothing_hat", "vampire/vampire_clothing_crown", "vampire/vampire_cloak_black_red", "vampire/vampire_cloak_black_blue", "vampire/vampire_cloak_black_white", "vampire/vampire_cloak_red_black", "vampire/vampire_cloak_white_black"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.AMULET.get(), (Item)ModItems.RING.get(), (Item)ModItems.OBI_BELT.get()}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.vampire.vampirism_menu")}).useCustomEntryName().setKeyName("accessories").build(entries);
        helper.info(new Item[]{(Item)ModItems.INJECTION_EMPTY.get(), (Item)ModItems.INJECTION_GARLIC.get(), (Item)ModItems.INJECTION_SANGUINARE.get()}).recipes(new String[]{"general/injection_0", "general/injection_1", "general/injection_2"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.HUNTER_INTEL_0.get()}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.blocks.hunter_table")}).setFormats(new Object[]{GuideBook.loc((Block)ModBlocks.HUNTER_TABLE.get())}).build(entries);
        helper.info(new Item[]{(Item)ModItems.ITEM_GARLIC.get()}).build(entries);
        helper.info(new Item[]{(Item)ModItems.PURIFIED_GARLIC.get()}).setFormats(new Object[]{GuideBook.loc((Block)ModBlocks.GARLIC_BEACON_NORMAL.get())}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.blocks.garlic_beacon_normal")}).recipes(new String[]{"alchemical_cauldron/purified_garlic"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.PITCHFORK.get()}).recipes(new String[]{"weapontable/pitchfork"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.STAKE.get()}).setFormats(new Object[]{(int)((Double)VampirismConfig.BALANCE.hsInstantKill1MaxHealth.get() * 100.0) + "%"}).recipes(new String[]{"hunter/stake"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.BASIC_CROSSBOW.get(), (Item)ModItems.ENHANCED_CROSSBOW.get(), (Item)ModItems.BASIC_DOUBLE_CROSSBOW.get(), (Item)ModItems.ENHANCED_DOUBLE_CROSSBOW.get(), (Item)ModItems.BASIC_TECH_CROSSBOW.get(), (Item)ModItems.ENHANCED_TECH_CROSSBOW.get()}).setFormats(new Object[]{GuideBook.loc((Item)ModItems.CROSSBOW_ARROW_NORMAL.get()), GuideBook.loc((Item)ModItems.TECH_CROSSBOW_AMMO_PACKAGE.get())}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.items.crossbow_arrow_normal")}).recipes(new String[]{"weapontable/basic_crossbow", "weapontable/enhanced_crossbow", "weapontable/basic_double_crossbow", "weapontable/enhanced_double_crossbow", "weapontable/basic_tech_crossbow", "weapontable/enhanced_tech_crossbow", "weapontable/tech_crossbow_ammo_package"}).useCustomEntryName().setKeyName("crossbows").build(entries);
        helper.info(new Item[]{(Item)ModItems.CROSSBOW_ARROW_NORMAL.get(), (Item)ModItems.CROSSBOW_ARROW_SPITFIRE.get(), (Item)ModItems.CROSSBOW_ARROW_VAMPIRE_KILLER.get()}).recipes(new String[]{"hunter/crossbow_arrow_normal", "weapontable/crossbow_arrow_spitfire", "weapontable/crossbow_arrow_vampire_killer"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.HOLY_WATER_BOTTLE_NORMAL.get(), (Item)ModItems.HOLY_WATER_BOTTLE_ENHANCED.get(), (Item)ModItems.HOLY_WATER_BOTTLE_ULTIMATE.get()}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.hunter.vamp_slayer"), new ResourceLocation("guide.vampirism.items.pure_salt")}).setFormats(new Object[]{GuideBook.loc((Item)ModItems.PURE_SALT_WATER.get()), GuideBook.loc((Item)ModItems.PURE_SALT_WATER.get()), GuideBook.loc((Item)ModItems.PURE_SALT.get())}).brewingItems(new Item[]{(Item)ModItems.PURE_SALT_WATER.get(), (Item)ModItems.HOLY_WATER_SPLASH_BOTTLE_NORMAL.get()}).setKeyName("holy_water_bottle").build(entries);
        helper.info(new Item[]{(Item)ModItems.PURE_SALT.get()}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.items.holy_water_bottle")}).setFormats(new Object[]{GuideBook.loc((Item)ModItems.PURE_SALT.get()), GuideBook.loc((Item)ModItems.PURE_SALT.get()), GuideBook.loc((Block)ModBlocks.ALCHEMICAL_CAULDRON.get())}).recipes(new String[]{"alchemical_cauldron/pure_salt"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.ITEM_ALCHEMICAL_FIRE.get()}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.items.crossbow_arrow_normal")}).recipes(new String[]{"alchemical_cauldron/alchemical_fire_4", "alchemical_cauldron/alchemical_fire_5", "alchemical_cauldron/alchemical_fire_6"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get()}).recipes(new String[]{"weapontable/armor_of_swiftness_chest_normal", "weapontable/armor_of_swiftness_legs_normal", "weapontable/armor_of_swiftness_head_normal", "weapontable/armor_of_swiftness_feet_normal", "weapontable/armor_of_swiftness_chest_enhanced", "weapontable/armor_of_swiftness_legs_enhanced", "weapontable/armor_of_swiftness_head_enhanced", "weapontable/armor_of_swiftness_feet_enhanced"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.HUNTER_COAT_CHEST_NORMAL.get(), (Item)ModItems.HUNTER_COAT_CHEST_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_CHEST_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_LEGS_NORMAL.get(), (Item)ModItems.HUNTER_COAT_LEGS_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_LEGS_ULTIMATE.get(), (Item)ModItems.HUNTER_COAT_HEAD_NORMAL.get(), (Item)ModItems.HUNTER_COAT_HEAD_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_HEAD_ULTIMATE.get(), (Item)ModItems.HUNTER_COAT_FEET_NORMAL.get(), (Item)ModItems.HUNTER_COAT_FEET_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_FEET_ULTIMATE.get()}).recipes(new String[]{"weapontable/hunter_coat_chest_normal", "weapontable/hunter_coat_legs_normal", "weapontable/hunter_coat_head_normal", "weapontable/hunter_coat_feet_normal", "weapontable/hunter_coat_chest_enhanced", "weapontable/hunter_coat_legs_enhanced", "weapontable/hunter_coat_head_enhanced", "weapontable/hunter_coat_feet_enhanced"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.HUNTER_AXE_NORMAL.get(), (Item)ModItems.HUNTER_AXE_ENHANCED.get(), (Item)ModItems.HUNTER_AXE_ULTIMATE.get()}).recipes(new String[]{"weapontable/hunter_axe_normal", "weapontable/hunter_axe_enhanced"}).build(entries);
        helper.info(new Item[]{(Item)ModItems.HUNTER_MINION_EQUIPMENT.get(), (Item)ModItems.HUNTER_MINION_UPGRADE_SIMPLE.get(), (Item)ModItems.HUNTER_MINION_UPGRADE_ENHANCED.get(), (Item)ModItems.HUNTER_MINION_UPGRADE_SPECIAL.get()}).setFormats(new Object[]{GuideBook.loc((Item)ModItems.HUNTER_MINION_EQUIPMENT.get()), GuideBook.loc((Item)ModItems.HUNTER_MINION_UPGRADE_SIMPLE.get()), ((MinionUpgradeItem)ModItems.HUNTER_MINION_UPGRADE_SIMPLE.get()).getMinLevel() + 1, ((MinionUpgradeItem)ModItems.HUNTER_MINION_UPGRADE_SIMPLE.get()).getMaxLevel() + 1, GuideBook.loc((Item)ModItems.HUNTER_MINION_UPGRADE_ENHANCED.get()), ((MinionUpgradeItem)ModItems.HUNTER_MINION_UPGRADE_ENHANCED.get()).getMinLevel() + 1, ((MinionUpgradeItem)ModItems.HUNTER_MINION_UPGRADE_ENHANCED.get()).getMaxLevel() + 1, GuideBook.loc((Item)ModItems.HUNTER_MINION_UPGRADE_SPECIAL.get()), ((MinionUpgradeItem)ModItems.HUNTER_MINION_UPGRADE_SPECIAL.get()).getMinLevel() + 1, ((MinionUpgradeItem)ModItems.HUNTER_MINION_UPGRADE_SPECIAL.get()).getMaxLevel() + 1, GuideBook.translate(((EntityType)ModEntities.TASK_MASTER_HUNTER.get()).func_210760_d(), new Object[0])}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.entity.taskmaster"), new ResourceLocation("guide.vampirism.hunter.lord")}).build(entries);
        helper.info(new Item[]{(Item)ModItems.CRUCIFIX_NORMAL.get(), (Item)ModItems.CRUCIFIX_ENHANCED.get(), (Item)ModItems.CRUCIFIX_ULTIMATE.get()}).setKeyName("crucifix").recipes(new String[]{"hunter/crucifix", "weapontable/crucifix_enhanced", "weapontable/crucifix_ultimate"}).build(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildBlocks(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.blocks.";
        helper.info(new Block[]{(Block)ModBlocks.CASTLE_BLOCK_DARK_BRICK.get()}).recipes(new String[]{"general/castle_block_dark_brick_0", "general/castle_block_dark_brick_1", "general/castle_block_dark_stone", "general/castle_block_normal_brick", "general/castle_block_purple_brick", "general/castle_slab_dark_brick", "general/castle_stairs_dark_brick"}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.VAMPIRE_ORCHID.get()}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.BLOOD_CONTAINER.get()}).recipes(new String[]{"vampire/blood_container"}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.ALTAR_INSPIRATION.get()}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.vampire.leveling")}).recipes(new String[]{"vampire/altar_inspiration"}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.ALTAR_INFUSION.get()}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.vampire.leveling")}).recipes(new String[]{"vampire/altar_infusion", "vampire/altar_pillar", "vampire/altar_tip"}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.COFFIN_RED.get()}).recipes(new String[]{"vampire/coffin_red"}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.CHURCH_ALTAR.get()}).build(entries);
        helper.info(true, new ItemStack[]{new ItemStack((IItemProvider)ModBlocks.MED_CHAIR.get())}).setFormats(new Object[]{GuideBook.loc((Item)ModItems.INJECTION_GARLIC.get()), GuideBook.loc((Item)ModItems.INJECTION_SANGUINARE.get())}).recipes(new String[]{"hunter/item_med_chair"}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.HUNTER_TABLE.get()}).setFormats(new Object[]{GuideBook.loc((Item)ModItems.HUNTER_INTEL_0.get())}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.hunter.leveling"), new ResourceLocation("guide.vampirism.items.hunter_intel")}).recipes(new String[]{"hunter/hunter_table"}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.WEAPON_TABLE.get()}).recipes(new String[]{"hunter/weapon_table"}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.ALCHEMICAL_CAULDRON.get()}).recipes(new String[]{"hunter/alchemical_cauldron"}).build(entries);
        int cn = (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorNormalDist.get() * 2 + 1;
        int ce = (Integer)VampirismConfig.BALANCE.hsGarlicDiffusorEnhancedDist.get() * 2 + 1;
        helper.info(new Block[]{(Block)ModBlocks.GARLIC_BEACON_NORMAL.get(), (Block)ModBlocks.GARLIC_BEACON_WEAK.get(), (Block)ModBlocks.GARLIC_BEACON_WEAK.get()}).setFormats(new Object[]{cn, cn, ce, ce, GuideBook.loc((Item)ModItems.PURIFIED_GARLIC.get())}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.items.item_garlic"), new ResourceLocation("guide.vampirism.items.purified_garlic"), new ResourceLocation("guide.vampirism.items.holy_water_bottle")}).recipes(new String[]{"hunter/garlic_beacon_normal", "hunter/garlic_beacon_improved", "alchemical_cauldron/garlic_beacon_core", "alchemical_cauldron/garlic_beacon_core_improved"}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.BLOOD_PEDESTAL.get()}).recipes(new String[]{"vampire/blood_pedestal"}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.BLOOD_GRINDER.get()}).recipes(new String[]{"general/blood_grinder"}).setFormats(new Object[]{GuideBook.loc((Item)ModItems.HUMAN_HEART.get()), GuideBook.loc(Items.field_151082_bd), GuideBook.loc((Block)ModBlocks.BLOOD_SIEVE.get())}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.BLOOD_SIEVE.get()}).recipes(new String[]{"general/blood_sieve"}).setFormats(new Object[]{GuideBook.translateComponent(((Fluid)ModFluids.IMPURE_BLOOD.get()).getAttributes().getTranslationKey(), new Object[0]), GuideBook.loc((Block)ModBlocks.BLOOD_GRINDER.get())}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.blocks.blood_grinder")}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.TOTEM_TOP_CRAFTED.get(), (Block)ModBlocks.TOTEM_TOP.get()}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.blocks.totem_base"), new ResourceLocation("guide.vampirism.world.villages")}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.TOTEM_BASE.get()}).recipes(new String[]{"general/totem_base"}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.blocks.totem_top_crafted"), new ResourceLocation("guide.vampirism.world.villages")}).build(entries);
        helper.info(new Block[]{(Block)ModBlocks.POTION_TABLE.get()}).recipes(new String[]{"hunter/potion_table"}).customPages(GuideBook.generatePotionMixes()).build(entries);
        ItemStack activatedOil = ((OilBottle)ModItems.OIL_BOTTLE.get()).withOil((IOil)ModOils.VAMPIRE_BLOOD.get());
        helper.info(new Block[]{(Block)ModBlocks.ALCHEMY_TABLE.get()}).recipes(new String[]{"alchemy_table"}).setFormats(new Object[]{((OilBottle)ModItems.OIL_BOTTLE.get()).func_200295_i(activatedOil)}).build(entries);
        ArrayList<IPage> decorativeBlocks = new ArrayList<IPage>(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base + "decorative.text", new Object[0]), (Item)((Item)ModItems.ITEM_CANDELABRA.get())));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "vampire/candelabra")));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "vampire/chandelier")));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "hunter/cross")));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "general/tombstone1")));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "general/tombstone2")));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "general/tombstone3")));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "general/grave_cage")));
        entries.put(new ResourceLocation(base + "decorative"), (EntryAbstract)new EntryItemStack(decorativeBlocks, (ITextComponent)new TranslationTextComponent(base + "decorative.title"), new ItemStack((IItemProvider)ModItems.ITEM_CANDELABRA.get())));
        return entries;
    }

    public static Map<ResourceLocation, EntryAbstract> buildChangelog(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.changelog.";
        entries.put(new ResourceLocation(base + "v1_8"), GuideBook.buildChangelog1_8());
        entries.put(new ResourceLocation(base + "v1_9"), GuideBook.buildChangelog1_9());
        return entries;
    }

    public static EntryAbstract buildChangelog1_8() {
        String base = "guide.vampirism.changelog.";
        String base1_8 = base + "v1_8.";
        ArrayList v1_8 = new ArrayList(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_8 + "overview.text", new Object[0])));
        List vampirism_menu = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_8 + "vampirism_menu.text", ModKeys.getKeyBinding(ModKeys.KEY.SKILL).func_238171_j_()));
        vampirism_menu.add(new PageTextImage((ITextProperties)GuideBook.translateComponent(base1_8 + "vampirism_menu.image", new Object[0]), new ResourceLocation("vampirismguide:textures/images/vampirism_menu.png"), false));
        v1_8.addAll(vampirism_menu);
        List accessories = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_8 + "accessories.text", new Object[0]));
        accessories.add(new PageTextImage((ITextProperties)GuideBook.translateComponent(base1_8 + "accessories.image", new Object[0]), new ResourceLocation("vampirismguide:textures/images/vampire_accessories.png"), false));
        v1_8.addAll(accessories);
        List armor = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_8 + "vampire_armor.text", new Object[0]));
        v1_8.addAll(armor);
        List immortality = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_8 + "vampire_immortality.text", new Object[0]));
        v1_8.addAll(immortality);
        List task_changes = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_8 + "tasks.text", new Object[0]));
        v1_8.addAll(task_changes);
        List raids = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_8 + "raids.text", new Object[0]));
        v1_8.addAll(raids);
        List skills = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_8 + "skills.text", new Object[0]));
        skills.add(new PageTextImage((ITextProperties)GuideBook.translateComponent(base1_8 + "skills.vista.image", new Object[0]), new ResourceLocation("vampirism", "textures/skills/vampire_forest_fog.png"), false));
        skills.add(new PageTextImage((ITextProperties)GuideBook.translateComponent(base1_8 + "skills.neonatal.image", new Object[0]), new ResourceLocation("vampirism", "textures/skills/neonatal_decrease.png"), false));
        skills.add(new PageTextImage((ITextProperties)GuideBook.translateComponent(base1_8 + "skills.dbno.image", new Object[0]), new ResourceLocation("vampirism", "textures/skills/dbno_duration.png"), false));
        skills.add(new PageTextImage((ITextProperties)GuideBook.translateComponent(base1_8 + "skills.hissing.image", new Object[0]), new ResourceLocation("vampirism", "textures/actions/hissing.png"), false));
        v1_8.addAll(skills);
        List balancing = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_8 + "balancing.text", new Object[0]));
        v1_8.addAll(balancing);
        List misc = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_8 + "misc.text", new Object[0]));
        v1_8.addAll(misc);
        return new EntryResourceLocation(v1_8, (ITextComponent)new StringTextComponent("Vampirism 1.8"), new ResourceLocation("textures/item/writable_book.png"));
    }

    public static EntryAbstract buildChangelog1_9() {
        String base = "guide.vampirism.changelog.";
        String base1_9 = base + "v1_9.";
        ArrayList v1_9 = new ArrayList(PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_9 + "overview.text", new Object[0])));
        List general = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_9 + "general.text", new Object[0]));
        v1_9.addAll(general);
        List oils = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_9 + "oils.text", new Object[0]));
        v1_9.addAll(oils);
        List skills = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_9 + "skills.text", new Object[0]));
        v1_9.addAll(skills);
        List blessing = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_9 + "blessing.text", new Object[0]));
        v1_9.addAll(blessing);
        List crucifix = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_9 + "crucifix.text", new Object[0]));
        v1_9.addAll(crucifix);
        List infection = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_9 + "infection.text", new Object[0]));
        v1_9.addAll(infection);
        List crossbows = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_9 + "crossbows.text", new Object[0]));
        v1_9.addAll(crossbows);
        List curing = PageHelper.pagesForLongText((ITextProperties)GuideBook.translateComponent(base1_9 + "curing.text", new Object[0]));
        v1_9.addAll(curing);
        return new EntryResourceLocation(v1_9, (ITextComponent)new StringTextComponent("Vampirism 1.9"), new ResourceLocation("textures/item/writable_book.png"));
    }

    private static IPage[] generatePotionMixes() {
        IPage[] pages = new IPage[]{new PagePotionTableMix(((ISkill)HunterSkills.DURABLE_BREWING.get()).getName(), (ExtendedPotionMix[])VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().filter(mix -> mix.durable && !mix.concentrated && !mix.efficient).toArray(ExtendedPotionMix[]::new)), new PagePotionTableMix(((ISkill)HunterSkills.CONCENTRATED_BREWING.get()).getName(), (ExtendedPotionMix[])VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().filter(mix -> mix.concentrated && !mix.durable && !mix.efficient).toArray(ExtendedPotionMix[]::new)), new PagePotionTableMix((ITextComponent)((ISkill)HunterSkills.DURABLE_BREWING.get()).getName().func_230532_e_().func_240702_b_("\n").func_230529_a_(((ISkill)HunterSkills.EFFICIENT_BREWING.get()).getName()), (ExtendedPotionMix[])VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().filter(mix -> mix.durable && !mix.concentrated && mix.efficient).toArray(ExtendedPotionMix[]::new)), new PagePotionTableMix((ITextComponent)((ISkill)HunterSkills.CONCENTRATED_BREWING.get()).getName().func_230532_e_().func_240702_b_("\n").func_230529_a_(((ISkill)HunterSkills.EFFICIENT_BREWING.get()).getName()), (ExtendedPotionMix[])VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().filter(mix -> mix.concentrated && !mix.durable && mix.efficient).toArray(ExtendedPotionMix[]::new)), new PagePotionTableMix(((ISkill)HunterSkills.MASTER_BREWER.get()).getName(), (ExtendedPotionMix[])VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().filter(mix -> mix.master && !mix.durable && !mix.concentrated && !mix.efficient).toArray(ExtendedPotionMix[]::new)), new PagePotionTableMix((ITextComponent)((ISkill)HunterSkills.MASTER_BREWER.get()).getName().func_230532_e_().func_240702_b_("\n").func_230529_a_(((ISkill)HunterSkills.EFFICIENT_BREWING.get()).getName()), (ExtendedPotionMix[])VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().filter(mix -> mix.master && !mix.durable && !mix.concentrated && mix.efficient).toArray(ExtendedPotionMix[]::new))};
        return pages;
    }

    public static IFormattableTextComponent translateComponent(String key, Object ... format) {
        String result = UtilLib.translate(key, format);
        return new StringTextComponent(result.replaceAll("\\\\n", Matcher.quoteReplacement("\n")));
    }

    public static String translate(String key, Object ... format) {
        String result = UtilLib.translate(key, format);
        return result.replaceAll("\\\\n", Matcher.quoteReplacement("\n"));
    }

    @Nullable
    public Book buildBook() {
        BookBinder binder = new BookBinder(new ResourceLocation("vampirism", "guidebook"));
        binder.setGuideTitleKey("guide.vampirism.title");
        binder.setItemNameKey("guide.vampirism");
        binder.setHeaderKey("guide.vampirism.welcome");
        binder.setAuthor((ITextComponent)new StringTextComponent("Maxanier"));
        binder.setColor(Color.WHITE);
        binder.setOutlineTexture(new ResourceLocation("vampirismguide", "textures/gui/book_violet_border.png"));
        binder.setSpawnWithBook();
        binder.setContentProvider(GuideBook::buildCategories);
        guideBook = binder.build();
        return guideBook;
    }

    @Nullable
    public ResourceLocation getModel() {
        return new ResourceLocation("vampirism", "guidebook");
    }
}

