/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide;

import de.maxanier.guideapi.page.PageHolderWithLinks;
import de.maxanier.guideapi.page.PageItemStack;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.player.tasks.reward.ItemReward;
import java.net.URI;
import java.util.ArrayList;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuideHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static String append(String ... unlocalized) {
        StringBuilder s = new StringBuilder();
        for (String u : unlocalized) {
            s.append(UtilLib.translate(u, new Object[0])).append("\n\n");
        }
        return s.toString();
    }

    public static PageItemStack createItemTaskDescription(Task task) {
        assert (task.getReward() instanceof ItemReward);
        Ingredient ingredient = Ingredient.func_234819_a_(((ItemReward)task.getReward()).getAllPossibleRewards().stream());
        ArrayList<Object> text = new ArrayList<Object>();
        StringTextComponent newLine = new StringTextComponent("\n");
        IPlayableFaction<?> f = task.getFaction();
        String type = f == null ? "" : f.getName().getString() + " ";
        text.add(new TranslationTextComponent("text.vampirism.task.reward_obtain", new Object[]{type}));
        text.add(newLine);
        text.add(newLine);
        text.add(task.getTranslation());
        text.add(newLine);
        text.add(new TranslationTextComponent("text.vampirism.task.prerequisites"));
        text.add(newLine);
        TaskUnlocker[] unlockers = task.getUnlocker();
        if (unlockers.length > 0) {
            for (TaskUnlocker u : unlockers) {
                text.add(new StringTextComponent("- ").func_230529_a_(u.getDescription()).func_230529_a_((ITextComponent)newLine));
            }
        } else {
            text.add(new TranslationTextComponent("text.vampirism.task.prerequisites.none"));
        }
        return new PageItemStack(ITextProperties.func_240654_a_(text), ingredient);
    }

    public static class URLLink
    extends PageHolderWithLinks.URLLink {
        private final ITextComponent name;

        public URLLink(ITextComponent name, URI link) {
            super("dummy", link);
            this.name = name;
        }

        public ITextComponent getDisplayName() {
            return this.name;
        }
    }
}

