/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.SubTexture;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Page;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.api.util.PageHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PagePotionTableMix
extends Page {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SubTexture POTION_GRID = new SubTexture(new ResourceLocation("vampirismguide", "textures/gui/potion_table.png"), 0, 0, 89, 75);
    private final ITextComponent description;
    private final ExtendedPotionMix[] recipes;
    private long lastCycle = -1L;
    private ItemStack input;
    private ItemStack output;
    private ItemStack in1;
    private ItemStack in2;
    private int recipeCycle;
    private int currentIngredient1Index;
    @Nonnull
    private ItemStack[] ingredients1 = new ItemStack[0];
    private int currentIngredient2Index;
    @Nonnull
    private ItemStack[] ingredients2 = new ItemStack[0];

    public PagePotionTableMix(ITextComponent description, ExtendedPotionMix ... recipes) {
        assert (recipes.length > 0);
        this.description = description;
        this.recipes = recipes;
        this.deriveItemStacks(recipes[0]);
        this.in1 = this.ingredients1[0];
        this.in2 = this.ingredients2[0];
    }

    public PagePotionTableMix(ITextComponent description, List<ExtendedPotionMix> recipes) {
        this(description, recipes.toArray(new ExtendedPotionMix[0]));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack stack, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, FontRenderer fontRendererObj) {
        long time;
        long l = time = guiBase.getMinecraft().field_71441_e != null ? guiBase.getMinecraft().field_71441_e.func_82737_E() : 0L;
        if (this.lastCycle < 0L || this.lastCycle < time - 60L) {
            if (this.lastCycle > 0L) {
                this.cycle();
            }
            this.lastCycle = time;
        }
        int xStart = guiLeft + guiBase.xSize / 2 - 44;
        int yStart = guiTop + 20;
        POTION_GRID.draw(stack, xStart, yStart);
        List tooltip = null;
        int x = xStart + 7;
        int y = yStart + 55;
        GuiHelper.drawItemStack((MatrixStack)stack, (ItemStack)this.input, (int)x, (int)y);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)x, (int)y, (int)15, (int)15)) {
            tooltip = GuiHelper.getTooltip((ItemStack)this.input);
        }
        GuiHelper.drawItemStack((MatrixStack)stack, (ItemStack)this.input, (int)(x += 21), (int)y);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)x, (int)y, (int)15, (int)15)) {
            tooltip = GuiHelper.getTooltip((ItemStack)this.input);
        }
        GuiHelper.drawItemStack((MatrixStack)stack, (ItemStack)this.input, (int)(x += 21), (int)y);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)x, (int)y, (int)15, (int)15)) {
            tooltip = GuiHelper.getTooltip((ItemStack)this.input);
        }
        x = xStart + 29;
        y = yStart + 4;
        GuiHelper.drawItemStack((MatrixStack)stack, (ItemStack)this.in1, (int)x, (int)y);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)x, (int)y, (int)15, (int)15)) {
            tooltip = GuiHelper.getTooltip((ItemStack)this.in1);
        }
        x = xStart + 4;
        y = yStart + 12;
        GuiHelper.drawItemStack((MatrixStack)stack, (ItemStack)this.in2, (int)x, (int)y);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)x, (int)y, (int)15, (int)15)) {
            tooltip = GuiHelper.getTooltip((ItemStack)this.in2);
        }
        x = xStart + 71;
        y = yStart + 29;
        GuiHelper.drawItemStack((MatrixStack)stack, (ItemStack)this.output, (int)x, (int)y);
        if (GuiHelper.isMouseBetween((double)mouseX, (double)mouseY, (int)x, (int)y, (int)15, (int)15)) {
            tooltip = GuiHelper.getTooltip((ItemStack)this.output);
        }
        PageHelper.drawFormattedText((MatrixStack)stack, (int)(guiLeft + 43), (int)(yStart + 80), (BaseScreen)guiBase, (ITextProperties)this.description);
        if (tooltip != null) {
            guiBase.func_243308_b(stack, tooltip, mouseX, mouseY);
        }
    }

    private void cycle() {
        if (++this.currentIngredient2Index >= this.ingredients2.length) {
            this.currentIngredient2Index = 0;
            if (++this.currentIngredient1Index >= this.ingredients1.length) {
                this.currentIngredient1Index = 0;
                if (++this.recipeCycle >= this.recipes.length) {
                    this.recipeCycle = 0;
                }
                this.deriveItemStacks(this.recipes[this.recipeCycle]);
            }
        }
        this.in1 = this.ingredients1[this.currentIngredient1Index];
        this.in2 = this.ingredients2[this.currentIngredient2Index];
    }

    private void deriveItemStacks(ExtendedPotionMix recipe) {
        this.input = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)((Potion)recipe.input.get()));
        this.output = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)((Potion)recipe.output.get()));
        this.ingredients1 = (ItemStack[])recipe.reagent1.map(Ingredient::func_193365_a).map(Arrays::stream).orElseGet(Stream::empty).map(ItemStack::func_77946_l).peek(stack -> stack.func_190920_e(recipe.reagent1Count)).toArray(ItemStack[]::new);
        this.ingredients2 = (ItemStack[])recipe.reagent2.map(Ingredient::func_193365_a).map(Arrays::stream).orElseGet(Stream::empty).map(ItemStack::func_77946_l).peek(stack -> stack.func_190920_e(recipe.reagent2Count)).toArray(ItemStack[]::new);
        if (this.ingredients1.length == 0) {
            this.ingredients1 = new ItemStack[]{ItemStack.field_190927_a};
        }
        if (this.ingredients2.length == 0) {
            this.ingredients2 = new ItemStack[]{ItemStack.field_190927_a};
        }
    }
}

