/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.blocks.AlchemyTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.inventory.recipes.AlchemyTableRecipe;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import de.teamlapen.vampirism.util.OilUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AlchemyTableRecipeCategory
implements IRecipeCategory<AlchemyTableRecipe> {
    private static final ResourceLocation location = new ResourceLocation("vampirism", "textures/gui/container/alchemy_table.png");
    private final String localizedName = UtilLib.translate(((AlchemyTableBlock)ModBlocks.ALCHEMY_TABLE.get()).func_149739_a(), new Object[0]);
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawableStatic blazeHeat;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated pool;

    public AlchemyTableRecipeCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(location, 11, 12, 149, 80).addPadding(0, 30, 0, 0).build();
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.ALCHEMY_TABLE.get()));
        this.blazeHeat = helper.createDrawable(location, 176, 9, 18, 4);
        this.arrow = helper.drawableBuilder(location, 176, 1, 28, 8).buildAnimated(600, IDrawableAnimated.StartDirection.LEFT, false);
        this.pool = helper.drawableBuilder(location, 176, 13, 32, 32).buildAnimated(600, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return VampirismJEIPlugin.ALCHEMY_TABLE_UID;
    }

    @Nonnull
    public Class<? extends AlchemyTableRecipe> getRecipeClass() {
        return AlchemyTableRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(AlchemyTableRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> ingredientList = new ArrayList<Ingredient>();
        ingredientList.add(recipe.getInput());
        ingredientList.addAll((Collection<Ingredient>)recipe.func_192400_c());
        ingredients.setInputIngredients(ingredientList);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull AlchemyTableRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.init(0, true, 3, 12);
        group.init(1, true, 43, 3);
        group.init(2, true, 67, 3);
        group.init(3, false, 100, 59);
        group.init(4, false, 128, 31);
        group.init(5, true, 22, 56);
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        for (int i = 0; i < inputs.size(); ++i) {
            if (i == 0) {
                group.set(i, (List)inputs.get(i));
                continue;
            }
            if (i != 1) continue;
            group.set(1, (List)inputs.get(i));
            group.set(2, (List)inputs.get(i));
        }
        for (List output : outputs) {
            for (ItemStack stack : output) {
                group.set(3, stack);
                group.set(4, stack);
            }
        }
        group.set(5, new ItemStack((IItemProvider)Items.field_151065_br));
    }

    public void draw(@Nonnull AlchemyTableRecipe recipe, @Nonnull MatrixStack matrixStack, double mouseX, double mouseY) {
        this.blazeHeat.draw(matrixStack, 22, 48);
        this.arrow.draw(matrixStack, 62, 45);
        int color = OilUtils.getOil(recipe.func_77571_b()).getColor();
        RenderSystem.color4f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        this.pool.draw(matrixStack, 93, 24);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = 2;
        int y = 80;
        Minecraft minecraft = Minecraft.func_71410_x();
        ISkill[] requiredSkills = recipe.getRequiredSkills();
        if (requiredSkills.length > 0) {
            TranslationTextComponent skillText = new TranslationTextComponent("gui.vampirism.hunter_weapon_table.skill", new Object[]{" "});
            for (ISkill skill : recipe.getRequiredSkills()) {
                skillText.func_230529_a_(skill.getName()).func_240702_b_(" ");
            }
            y += UtilLib.renderMultiLine(minecraft.field_71466_p, matrixStack, (ITextComponent)skillText, 132, x, y, Color.gray.getRGB());
        }
    }
}

