/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.blocks.PotionTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.modcompat.jei.JEIPotionMix;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class PotionTableRecipeCategory
implements IRecipeCategory<JEIPotionMix> {
    private static final ResourceLocation backgroundLocation = new ResourceLocation("vampirism", "textures/gui/potion_table.png");
    private final String localizedName = UtilLib.translate(((PotionTableBlock)ModBlocks.POTION_TABLE.get()).func_149739_a(), new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotDrawable;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated bubbles;
    private final IDrawableStatic blazeHeat;

    PotionTableRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.POTION_TABLE.get()));
        this.background = guiHelper.drawableBuilder(backgroundLocation, 65, 6, 103, 73).addPadding(0, 33, 0, 25).build();
        this.slotDrawable = guiHelper.getSlotDrawable();
        BrewingBubblesTickTimer bubblesTickTimer = new BrewingBubblesTickTimer(guiHelper);
        this.bubbles = guiHelper.drawableBuilder(backgroundLocation, 185, 0, 12, 29).buildAnimated((ITickTimer)bubblesTickTimer, IDrawableAnimated.StartDirection.BOTTOM);
        this.blazeHeat = guiHelper.createDrawable(backgroundLocation, 176, 29, 18, 4);
        this.arrow = guiHelper.drawableBuilder(backgroundLocation, 176, 0, 9, 28).buildAnimated(400, IDrawableAnimated.StartDirection.TOP, false);
    }

    public void draw(JEIPotionMix recipe, MatrixStack stack, double mouseX, double mouseY) {
        this.blazeHeat.draw(stack, 1, 35);
        this.bubbles.draw(stack, 3, 4);
        this.arrow.draw(stack, 80, 10);
        int y = 75;
        int x = 5;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (recipe.getOriginal().durable && recipe.getOriginal().concentrated) {
            minecraft.field_71466_p.func_243248_b(stack, ((ISkill)HunterSkills.CONCENTRATED_DURABLE_BREWING.get()).getName(), (float)x, (float)y, Color.gray.getRGB());
            minecraft.field_71466_p.getClass();
            y += 9;
        } else if (recipe.getOriginal().durable) {
            minecraft.field_71466_p.func_243248_b(stack, ((ISkill)HunterSkills.DURABLE_BREWING.get()).getName(), (float)x, (float)y, Color.gray.getRGB());
            minecraft.field_71466_p.getClass();
            y += 9;
        } else if (recipe.getOriginal().concentrated) {
            minecraft.field_71466_p.func_243248_b(stack, ((ISkill)HunterSkills.CONCENTRATED_BREWING.get()).getName(), (float)x, (float)y, Color.gray.getRGB());
            minecraft.field_71466_p.getClass();
            y += 9;
        }
        if (recipe.getOriginal().master) {
            minecraft.field_71466_p.func_243248_b(stack, ((ISkill)HunterSkills.MASTER_BREWER.get()).getName(), (float)x, (float)y, Color.gray.getRGB());
            minecraft.field_71466_p.getClass();
            y += 9;
        }
        if (recipe.getOriginal().efficient) {
            minecraft.field_71466_p.func_243248_b(stack, ((ISkill)HunterSkills.EFFICIENT_BREWING.get()).getName(), (float)x, (float)y, Color.gray.getRGB());
            minecraft.field_71466_p.getClass();
            y += 9;
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends JEIPotionMix> getRecipeClass() {
        return JEIPotionMix.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public ResourceLocation getUid() {
        return VampirismJEIPlugin.POTION_RECIPE_UID;
    }

    public void setIngredients(JEIPotionMix extendedPotionMix, IIngredients iIngredients) {
        iIngredients.setInputLists(VanillaTypes.ITEM, extendedPotionMix.getInputs());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)extendedPotionMix.getPotionOutput());
    }

    public void setRecipe(IRecipeLayout recipeLayout, JEIPotionMix extendedPotionMix, IIngredients iIngredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 38, 52);
        itemStacks.init(1, true, 60, 52);
        itemStacks.init(2, true, 82, 52);
        itemStacks.init(3, true, 60, 1);
        itemStacks.init(4, true, 35, 9);
        itemStacks.init(5, false, 103, 13);
        itemStacks.setBackground(5, this.slotDrawable);
        itemStacks.set(iIngredients);
    }

    private static class BrewingBubblesTickTimer
    implements ITickTimer {
        private static final int[] BUBBLE_LENGTHS = new int[]{29, 23, 18, 13, 9, 5, 0};
        private final ITickTimer internalTimer;

        public BrewingBubblesTickTimer(IGuiHelper guiHelper) {
            this.internalTimer = guiHelper.createTickTimer(14, BUBBLE_LENGTHS.length - 1, false);
        }

        public int getMaxValue() {
            return BUBBLE_LENGTHS[0];
        }

        public int getValue() {
            int timerValue = this.internalTimer.getValue();
            return BUBBLE_LENGTHS[timerValue];
        }
    }
}

