/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.client.gui.AlchemicalCauldronScreen;
import de.teamlapen.vampirism.client.gui.AlchemyTableScreen;
import de.teamlapen.vampirism.client.gui.PotionTableScreen;
import de.teamlapen.vampirism.client.gui.WeaponTableScreen;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.inventory.container.AlchemicalCauldronContainer;
import de.teamlapen.vampirism.inventory.container.WeaponTableContainer;
import de.teamlapen.vampirism.items.BlessableItem;
import de.teamlapen.vampirism.modcompat.jei.AlchemicalCauldronRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.AlchemyTableRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.BlessingRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.JEIPotionMix;
import de.teamlapen.vampirism.modcompat.jei.PotionTableRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.TaskRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.WeaponTableRecipeCategory;
import de.teamlapen.vampirism.player.tasks.TaskUtil;
import de.teamlapen.vampirism.util.OilUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class VampirismJEIPlugin
implements IModPlugin {
    static final ResourceLocation WEAPON_TABLE_RECIPE_ID = new ResourceLocation("vampirism", "hunter_weapon");
    static final ResourceLocation ALCHEMICAL_CAULDRON_RECIPE_UID = new ResourceLocation("vampirism", "alchemical_cauldron");
    static final ResourceLocation TASK_RECIPE_UID = new ResourceLocation("vampirism", "task");
    static final ResourceLocation BLESSING_RECIPE_UID = new ResourceLocation("vampirism", "blessing");
    static final ResourceLocation POTION_RECIPE_UID = new ResourceLocation("vampirism", "potion");
    static final ResourceLocation ALCHEMY_TABLE_UID = new ResourceLocation("vampirism", "alchemy_table");
    private static final ResourceLocation ID = new ResourceLocation("vampirism", "plugin");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new AlchemicalCauldronRecipeCategory(helper), new WeaponTableRecipeCategory(helper), new TaskRecipeCategory(helper), new PotionTableRecipeCategory(helper), new AlchemyTableRecipeCategory(helper), new BlessingRecipeCategory(helper)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(AlchemicalCauldronScreen.class, 80, 34, 20, 15, new ResourceLocation[]{ALCHEMICAL_CAULDRON_RECIPE_UID});
        registration.addRecipeClickArea(WeaponTableScreen.class, 114, 46, 20, 15, new ResourceLocation[]{WEAPON_TABLE_RECIPE_ID});
        registration.addRecipeClickArea(PotionTableScreen.class, 145, 17, 9, 28, new ResourceLocation[]{POTION_RECIPE_UID});
        registration.addRecipeClickArea(AlchemyTableScreen.class, 73, 57, 28, 8, new ResourceLocation[]{ALCHEMY_TABLE_UID});
        registration.addRecipeClickArea(AlchemyTableScreen.class, 104, 36, 32, 32, new ResourceLocation[]{ALCHEMY_TABLE_UID});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(AlchemicalCauldronContainer.class, ALCHEMICAL_CAULDRON_RECIPE_UID, 0, 2, 4, 36);
        registration.addRecipeTransferHandler(AlchemicalCauldronContainer.class, VanillaRecipeCategoryUid.FUEL, 3, 1, 4, 36);
        registration.addRecipeTransferHandler(WeaponTableContainer.class, WEAPON_TABLE_RECIPE_ID, 1, 16, 17, 36);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.OIL_BOTTLE.get(), (IIngredientSubtypeInterpreter)OilNBT.INSTANCE);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RecipeManager recipeManager = world.func_199532_z();
        registration.addRecipes(recipeManager.func_215366_a(ModRecipes.ALCHEMICAL_CAULDRON_TYPE).values(), ALCHEMICAL_CAULDRON_RECIPE_UID);
        registration.addRecipes(recipeManager.func_215366_a(ModRecipes.WEAPONTABLE_CRAFTING_TYPE).values(), WEAPON_TABLE_RECIPE_ID);
        registration.addRecipes(TaskUtil.getItemRewardTasks(), TASK_RECIPE_UID);
        registration.addRecipes((Collection)VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().map(JEIPotionMix::createFromMix).flatMap(Collection::stream).collect(Collectors.toList()), POTION_RECIPE_UID);
        registration.addRecipes(this.getRepairRecipes(registration.getVanillaRecipeFactory()), VanillaRecipeCategoryUid.ANVIL);
        registration.addRecipes(recipeManager.func_215366_a(ModRecipes.ALCHEMICAL_TABLE_TYPE).values(), ALCHEMY_TABLE_UID);
        registration.addRecipes(this.getApplicableOilRecipes(), VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipes(BlessableItem.getBlessableRecipes(), BLESSING_RECIPE_UID);
        registration.addRecipes(this.getCleanOilRecipes(), VanillaRecipeCategoryUid.CRAFTING);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
    }

    private Collection<Object> getRepairRecipes(IVanillaRecipeFactory factory) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        HashMap items = Maps.newHashMap();
        Ingredient ironIngredient = ItemTier.IRON.func_200924_f();
        items.put(ironIngredient, Lists.newArrayList((Object[])new Item[]{(Item)ModItems.HUNTER_AXE_NORMAL.get(), (Item)ModItems.HUNTER_AXE_ENHANCED.get(), (Item)ModItems.HUNTER_AXE_ULTIMATE.get(), (Item)ModItems.BASIC_TECH_CROSSBOW.get(), (Item)ModItems.ENHANCED_TECH_CROSSBOW.get(), (Item)ModItems.HUNTER_COAT_CHEST_NORMAL.get(), (Item)ModItems.HUNTER_COAT_CHEST_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_CHEST_ULTIMATE.get(), (Item)ModItems.HUNTER_COAT_HEAD_NORMAL.get(), (Item)ModItems.HUNTER_COAT_HEAD_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_HEAD_ULTIMATE.get(), (Item)ModItems.HUNTER_COAT_LEGS_NORMAL.get(), (Item)ModItems.HUNTER_COAT_LEGS_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_LEGS_ULTIMATE.get(), (Item)ModItems.HUNTER_COAT_FEET_NORMAL.get(), (Item)ModItems.HUNTER_COAT_FEET_ENHANCED.get(), (Item)ModItems.HUNTER_COAT_FEET_ULTIMATE.get()}));
        Ingredient stringIngredient = Ingredient.func_199805_a((ITag)Tags.Items.STRING);
        items.put(stringIngredient, Lists.newArrayList((Object[])new Item[]{(Item)ModItems.BASIC_CROSSBOW.get(), (Item)ModItems.BASIC_DOUBLE_CROSSBOW.get(), (Item)ModItems.ENHANCED_CROSSBOW.get(), (Item)ModItems.ENHANCED_DOUBLE_CROSSBOW.get()}));
        Ingredient leather = Ingredient.func_199805_a((ITag)Tags.Items.LEATHER);
        items.put(leather, Lists.newArrayList((Object[])new Item[]{(Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_NORMAL.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_ENHANCED.get(), (Item)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get()}));
        Ingredient bloodIngot = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.BLOOD_INFUSED_IRON_INGOT.get()});
        items.put(bloodIngot, Lists.newArrayList((Object[])new Item[]{(Item)ModItems.HEART_SEEKER_NORMAL.get(), (Item)ModItems.HEART_STRIKER_NORMAL.get()}));
        Ingredient enhancedBloodIngot = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.BLOOD_INFUSED_ENHANCED_IRON_INGOT.get()});
        items.put(enhancedBloodIngot, Lists.newArrayList((Object[])new Item[]{(Item)ModItems.HEART_SEEKER_ENHANCED.get(), (Item)ModItems.HEART_SEEKER_ULTIMATE.get(), (Item)ModItems.HEART_STRIKER_ENHANCED.get(), (Item)ModItems.HEART_STRIKER_ULTIMATE.get()}));
        Ingredient human_heart = Ingredient.func_199805_a(ModTags.Items.HEART);
        items.put(human_heart, Lists.newArrayList((Object[])new Item[]{(Item)ModItems.VAMPIRE_CLOTHING_CROWN.get(), (Item)ModItems.VAMPIRE_CLOTHING_HAT.get(), (Item)ModItems.VAMPIRE_CLOTHING_LEGS.get(), (Item)ModItems.VAMPIRE_CLOTHING_BOOTS.get(), (Item)ModItems.VAMPIRE_CLOAK_RED_BLACK.get(), (Item)ModItems.VAMPIRE_CLOAK_BLACK_RED.get(), (Item)ModItems.VAMPIRE_CLOAK_BLACK_WHITE.get(), (Item)ModItems.VAMPIRE_CLOAK_WHITE_BLACK.get(), (Item)ModItems.VAMPIRE_CLOAK_BLACK_BLUE.get()}));
        for (Map.Entry entry : items.entrySet()) {
            ArrayList repairMaterials = Lists.newArrayList((Object[])((Ingredient)entry.getKey()).func_193365_a());
            for (Item ingredientItem : (List)entry.getValue()) {
                ItemStack ingredient = new ItemStack((IItemProvider)ingredientItem);
                ItemStack damaged1 = ingredient.func_77946_l();
                damaged1.func_196085_b(damaged1.func_77958_k());
                ItemStack damaged2 = ingredient.func_77946_l();
                damaged2.func_196085_b(damaged2.func_77958_k() * 3 / 4);
                ItemStack damaged3 = ingredient.func_77946_l();
                damaged3.func_196085_b(damaged3.func_77958_k() * 2 / 4);
                if (!repairMaterials.isEmpty()) {
                    Object repairWithMaterial = factory.createAnvilRecipe(damaged1, (List)repairMaterials, Collections.singletonList(damaged2));
                    recipes.add(repairWithMaterial);
                }
                Object repairWithSame = factory.createAnvilRecipe(damaged2, Collections.singletonList(damaged2), Collections.singletonList(damaged3));
                recipes.add(repairWithSame);
            }
        }
        return recipes;
    }

    private List<ShapelessRecipe> getApplicableOilRecipes() {
        return ModRegistries.OILS.getValues().stream().filter(IApplicableOil.class::isInstance).map(IApplicableOil.class::cast).flatMap(oil -> ForgeRegistries.ITEMS.getValues().stream().filter(item -> !(item instanceof IFactionExclusiveItem) || ((IFactionExclusiveItem)item).getExclusiveFaction() == VReference.HUNTER_FACTION).map(Item::func_190903_i).filter(oil::canBeApplied).map(stack -> new ShapelessRecipe(new ResourceLocation("vampirism", (oil.getRegistryName().toString() + stack.func_77973_b().getRegistryName().toString()).replace(':', '_')), "", OilUtils.setAppliedOil(stack.func_77946_l(), oil), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{OilUtils.createOilItem(oil)})})))).collect(Collectors.toList());
    }

    private List<ShapelessRecipe> getCleanOilRecipes() {
        return this.getApplicableOilRecipes().stream().map(recipe -> {
            ItemStack item = recipe.func_77571_b();
            IApplicableOil oil = OilUtils.getAppliedOil(item).get();
            return new ShapelessRecipe(new ResourceLocation("vampirism", ("clean_" + oil.getRegistryName().toString() + "_from_" + item.func_77973_b().getRegistryName().toString()).replace(':', '_')), "", OilUtils.removeAppliedOil(item.func_77946_l()), NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151121_aF}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{item})}));
        }).collect(Collectors.toList());
    }

    private static class OilNBT
    implements IIngredientSubtypeInterpreter<ItemStack> {
        public static final OilNBT INSTANCE = new OilNBT();

        private OilNBT() {
        }

        public String apply(ItemStack itemStack, UidContext context) {
            CompoundNBT nbtTagCompound = itemStack.func_77978_p();
            if (nbtTagCompound == null || nbtTagCompound.isEmpty()) {
                return "";
            }
            return OilUtils.getOil(itemStack).getRegistryName().toString();
        }
    }
}

