/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class CAppearancePacket
implements IMessage {
    public final int entityId;
    public final String name;
    public final int[] data;

    static void encode(CAppearancePacket msg, PacketBuffer buf) {
        buf.func_150787_b(msg.entityId);
        buf.func_180714_a(msg.name);
        buf.func_150787_b(msg.data.length);
        for (int value : msg.data) {
            buf.func_150787_b(value);
        }
    }

    static CAppearancePacket decode(PacketBuffer buf) {
        int entityId = buf.func_150792_a();
        String newName = buf.func_150789_c(15);
        int[] data = new int[buf.func_150792_a()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = buf.func_150792_a();
        }
        return new CAppearancePacket(entityId, newName, data);
    }

    public static void handle(CAppearancePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            Entity entity = player.field_70170_p.func_73045_a(msg.entityId);
            if (entity instanceof PlayerEntity) {
                VampirePlayer.getOpt((PlayerEntity)player).ifPresent(vampire -> vampire.setSkinData(msg.data));
            } else if (entity instanceof MinionEntity) {
                ((MinionEntity)entity).getMinionData().ifPresent(minionData -> minionData.handleMinionAppearanceConfig(msg.name, msg.data));
                HelperLib.sync((MinionEntity)entity);
            }
        });
        ctx.setPacketHandled(true);
    }

    public CAppearancePacket(int entityId, String newName, int ... data) {
        this.entityId = entityId;
        this.name = newName;
        this.data = data;
    }
}

