/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.inventory.container.TaskContainer;
import de.teamlapen.vampirism.player.TaskManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class CTaskActionPacket
implements IMessage {
    public final UUID task;
    public final UUID entityId;
    public final TaskContainer.TaskAction action;

    static void encode(CTaskActionPacket msg, PacketBuffer buf) {
        buf.func_179252_a(msg.task);
        buf.func_179252_a(msg.entityId);
        buf.func_150787_b(msg.action.ordinal());
    }

    static CTaskActionPacket decode(PacketBuffer buf) {
        return new CTaskActionPacket(buf.func_179253_g(), buf.func_179253_g(), TaskContainer.TaskAction.values()[buf.func_150792_a()]);
    }

    public static void handle(CTaskActionPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> FactionPlayerHandler.getCurrentFactionPlayer((PlayerEntity)player).map(IFactionPlayer::getTaskManager).ifPresent(m -> ((TaskManager)m).handleTaskActionMessage(msg)));
        ctx.setPacketHandled(true);
    }

    public CTaskActionPacket(UUID task, UUID entityId, TaskContainer.TaskAction action) {
        this.task = task;
        this.entityId = entityId;
        this.action = action;
    }
}

