/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CUnlockSkillPacket
implements IMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResourceLocation skillId;

    static void encode(CUnlockSkillPacket msg, PacketBuffer buf) {
        buf.func_192572_a(msg.skillId);
    }

    static CUnlockSkillPacket decode(PacketBuffer buf) {
        return new CUnlockSkillPacket(buf.func_192575_l());
    }

    static void handle(CUnlockSkillPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            Optional factionPlayerOpt = FactionPlayerHandler.getOpt((PlayerEntity)player).map(FactionPlayerHandler::getCurrentFactionPlayer).orElseGet(Optional::empty);
            factionPlayerOpt.ifPresent(factionPlayer -> {
                ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(msg.skillId);
                if (skill != null) {
                    ISkillHandler skillHandler = factionPlayer.getSkillHandler();
                    ISkillHandler.Result result = skillHandler.canSkillBeEnabled(skill);
                    if (result == ISkillHandler.Result.OK) {
                        skillHandler.enableSkill(skill);
                        if (factionPlayer instanceof ISyncable.ISyncableEntityCapabilityInst && skillHandler instanceof SkillHandler) {
                            CompoundNBT sync = new CompoundNBT();
                            ((SkillHandler)skillHandler).writeUpdateForClient(sync);
                            HelperLib.sync((ISyncable.ISyncableEntityCapabilityInst)((Object)factionPlayer), sync, (Entity)factionPlayer.getRepresentingPlayer(), false);
                        }
                    } else {
                        LOGGER.warn("Skill {} cannot be activated for {} ({})", (Object)skill, (Object)player, (Object)result);
                    }
                } else {
                    LOGGER.warn("Skill {} was not found so {} cannot activate it", (Object)msg.skillId, (Object)player);
                }
            });
        });
        ctx.setPacketHandled(true);
    }

    public CUnlockSkillPacket(ResourceLocation skillId) {
        this.skillId = skillId;
    }
}

