/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.player.skills.SkillNode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class SSkillTreePacket
implements IMessage {
    private final Map<ResourceLocation, SkillNode.Builder> nodes;

    static void encode(SSkillTreePacket msg, PacketBuffer buf) {
        buf.func_150787_b(msg.nodes.size());
        for (Map.Entry<ResourceLocation, SkillNode.Builder> e : msg.nodes.entrySet()) {
            buf.func_192572_a(e.getKey());
            e.getValue().writeTo(buf);
        }
    }

    static SSkillTreePacket decode(PacketBuffer buf) {
        SSkillTreePacket pkt = new SSkillTreePacket();
        int count = buf.func_150792_a();
        for (int i = 0; i < count; ++i) {
            ResourceLocation id = buf.func_192575_l();
            SkillNode.Builder b = SkillNode.Builder.readFrom(buf);
            pkt.nodes.put(id, b);
        }
        return pkt;
    }

    public static void handle(SSkillTreePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleSkillTreePacket(msg));
        ctx.setPacketHandled(true);
    }

    public SSkillTreePacket(Map<ResourceLocation, SkillNode.Builder> nodes) {
        this.nodes = nodes;
    }

    private SSkillTreePacket() {
        this.nodes = new HashMap<ResourceLocation, SkillNode.Builder>();
    }

    public Map<ResourceLocation, SkillNode.Builder> getNodes() {
        return this.nodes;
    }
}

