/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player;

import com.google.common.collect.Maps;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.ITaskManager;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.inventory.container.TaskBoardContainer;
import de.teamlapen.vampirism.inventory.container.TaskContainer;
import de.teamlapen.vampirism.inventory.container.VampirismContainer;
import de.teamlapen.vampirism.network.CTaskActionPacket;
import de.teamlapen.vampirism.network.STaskPacket;
import de.teamlapen.vampirism.network.STaskStatusPacket;
import de.teamlapen.vampirism.player.tasks.TaskInstance;
import de.teamlapen.vampirism.player.tasks.req.ItemRequirement;
import de.teamlapen.vampirism.player.tasks.reward.ItemRewardInstance;
import de.teamlapen.vampirism.player.tasks.reward.LordLevelReward;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.OilUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

public class TaskManager
implements ITaskManager {
    private static final UUID UNIQUE_TASKS = UUID.fromString("e2c6068a-8f0e-4d5b-822a-38ad6ecf98c9");
    private static final Map<ResourceLocation, Pair<Function<CompoundNBT, ITaskRewardInstance>, Function<PacketBuffer, ITaskRewardInstance>>> TASK_REWARD_SUPPLIER = new HashMap<ResourceLocation, Pair<Function<CompoundNBT, ITaskRewardInstance>, Function<PacketBuffer, ITaskRewardInstance>>>(){
        {
            this.put(LordLevelReward.ID, Pair.of(LordLevelReward::readNbt, LordLevelReward::decode));
            this.put(ItemRewardInstance.ID, Pair.of(ItemRewardInstance::readNbt, ItemRewardInstance::decode));
        }
    };
    @Nonnull
    private final IPlayableFaction<?> faction;
    @Nonnull
    private final ServerPlayerEntity player;
    @Nonnull
    private final IFactionPlayer<?> factionPlayer;
    @Nonnull
    private final Set<Task> completedTasks = new HashSet<Task>();
    @Nonnull
    private final Map<UUID, TaskWrapper> taskWrapperMap = new HashMap<UUID, TaskWrapper>();

    public static void registerTaskReward(ResourceLocation id, Pair<Function<CompoundNBT, ITaskRewardInstance>, Function<PacketBuffer, ITaskRewardInstance>> functions) {
        if (TASK_REWARD_SUPPLIER.containsKey(id)) {
            throw new IllegalStateException("This id is already registered: " + id);
        }
        TASK_REWARD_SUPPLIER.put(id, functions);
    }

    public static ITaskRewardInstance createReward(ResourceLocation id, CompoundNBT nbt) {
        return (ITaskRewardInstance)((Function)TASK_REWARD_SUPPLIER.get(id).getKey()).apply(nbt);
    }

    public static ITaskRewardInstance createReward(ResourceLocation id, PacketBuffer buffer) {
        return (ITaskRewardInstance)((Function)TASK_REWARD_SUPPLIER.get(id).getValue()).apply(buffer);
    }

    public TaskManager(@Nonnull ServerPlayerEntity player, @Nonnull IFactionPlayer<?> factionPlayer, @Nonnull IPlayableFaction<?> faction) {
        this.faction = faction;
        this.player = player;
        this.factionPlayer = factionPlayer;
    }

    @Override
    public void abortTask(UUID taskBoardId, @Nonnull UUID taskInstance, boolean remove) {
        this.taskWrapperMap.get(taskBoardId).removeTask(taskInstance, remove);
    }

    @Override
    @Deprecated
    public void abortTask(UUID taskBoardId, @Nonnull ITaskInstance taskInstance, boolean remove) {
        TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(taskInstance.isUnique() ? UNIQUE_TASKS : taskBoardId, TaskWrapper::new);
        wrapper.removeTask(taskInstance, remove);
    }

    @Override
    @Deprecated
    public void abortTask(UUID taskBoardId, @Nonnull Task task) {
        this.taskWrapperMap.get(task.isUnique() ? UNIQUE_TASKS : taskBoardId).getTaskInstances().stream().filter(ins -> ins.getTask() == task).forEach(ins -> this.abortTask(taskBoardId, (ITaskInstance)ins, false));
    }

    @Override
    public void acceptTask(UUID taskBoardId, @Nonnull UUID taskInstance) {
        ITaskInstance ins = this.taskWrapperMap.get(taskBoardId).acceptTask(taskInstance, this.player.field_70170_p.func_82737_E() + (long)this.getTaskTimeConfig() * 1200L);
        this.updateStats(ins);
    }

    public void handleTaskActionMessage(CTaskActionPacket msg) {
        switch (msg.action) {
            case COMPLETE: {
                this.completeTask(msg.entityId, msg.task);
                break;
            }
            case ACCEPT: {
                this.acceptTask(msg.entityId, msg.task);
                break;
            }
            default: {
                this.abortTask(msg.entityId, msg.task, msg.action == TaskContainer.TaskAction.REMOVE);
            }
        }
    }

    public void applyRewards(@Nonnull ITaskInstance taskInstance) {
        taskInstance.getReward().applyReward(this.factionPlayer);
    }

    public boolean canCompleteTask(@Nonnull ITaskInstance taskInstance) {
        if (!this.isTaskUnlocked(taskInstance.getTask())) {
            return false;
        }
        if (!this.isTimeEnough(taskInstance, this.player.field_70170_p.func_82737_E())) {
            return false;
        }
        for (TaskRequirement.Requirement<?> requirement : taskInstance.getTask().getRequirement().getAll()) {
            if (this.checkStat(taskInstance, requirement)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void completeTask(UUID taskBoardId, @Nonnull UUID taskInstance) {
        TaskWrapper wrapper = this.taskWrapperMap.get(taskBoardId);
        ITaskInstance ins = wrapper.getTaskInstance(taskInstance);
        if (!this.canCompleteTask(ins)) {
            return;
        }
        this.completedTasks.add(ins.getTask());
        wrapper.removeTask(ins, true);
        if (!ins.isUnique()) {
            ++wrapper.lessTasks;
        }
        this.removeRequirements(ins);
        this.applyRewards(ins);
    }

    @Nonnull
    public Map<UUID, Map<ResourceLocation, Integer>> getCompletedRequirements(@Nonnull Collection<ITaskInstance> taskInstances) {
        HashMap completedRequirements = Maps.newHashMap();
        taskInstances.forEach(task -> {
            Map<ResourceLocation, Integer> completed = this.getCompletedRequirements((ITaskInstance)task);
            if (!completed.isEmpty()) {
                completedRequirements.put(task.getId(), completed);
            }
        });
        return completedRequirements;
    }

    public int getTaskTimeConfig() {
        if (ServerLifecycleHooks.getCurrentServer().func_71262_S()) {
            return (Integer)VampirismConfig.BALANCE.taskDurationDedicatedServer.get();
        }
        return (Integer)VampirismConfig.BALANCE.taskDurationSinglePlayer.get();
    }

    @Override
    public boolean hasAvailableTasks(UUID taskBoardId) {
        return !this.getTasks(taskBoardId).isEmpty() || !this.getUniqueTasks().isEmpty();
    }

    public boolean isTaskUnlocked(@Nonnull Task task) {
        if (!this.matchesFaction(task)) {
            return false;
        }
        for (TaskUnlocker taskUnlocker : task.getUnlocker()) {
            if (taskUnlocker.isUnlocked(this.factionPlayer)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void openTaskMasterScreen(UUID taskBoardId) {
        if (this.player.field_71070_bA instanceof TaskBoardContainer) {
            TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(taskBoardId, TaskWrapper::new);
            HashSet<ITaskInstance> selectedTasks = new HashSet<ITaskInstance>(this.getTasks(taskBoardId));
            selectedTasks.addAll(this.getUniqueTasks());
            VampirismMod.dispatcher.sendTo(new STaskStatusPacket(selectedTasks, this.getCompletableTasks(selectedTasks), this.getCompletedRequirements(selectedTasks), this.player.field_71070_bA.field_75152_c, taskBoardId), this.player);
            wrapper.lastSeenPos = this.player.func_233580_cy_();
        }
    }

    @Override
    public void openVampirismMenu() {
        if (!this.player.func_70089_S()) {
            return;
        }
        this.player.func_213829_a(new INamedContainerProvider(){

            @Nonnull
            public Container createMenu(int i, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerEntity) {
                return new VampirismContainer(i, playerInventory);
            }

            @Nonnull
            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("");
            }
        });
        if (this.player.field_71070_bA instanceof TaskContainer) {
            VampirismMod.dispatcher.sendTo(new STaskPacket(this.player.field_71070_bA.field_75152_c, this.taskWrapperMap, this.taskWrapperMap.entrySet().stream().map(entry -> Pair.of(entry.getKey(), this.getCompletableTasks(((TaskWrapper)entry.getValue()).getAcceptedTasks()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)), this.taskWrapperMap.values().stream().map(wrapper -> Pair.of((Object)((TaskWrapper)wrapper).id, this.getCompletedRequirements(((TaskWrapper)wrapper).tasks.values()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue))), this.player);
        }
    }

    public void readNBT(@Nonnull CompoundNBT compoundNBT) {
        TaskWrapper wrapper;
        if (compoundNBT.func_74764_b("taskWrapper")) {
            ListNBT infos = compoundNBT.func_150295_c("taskWrapper", 10);
            for (int i = 0; i < infos.size(); ++i) {
                CompoundNBT nbt = infos.func_150305_b(i);
                wrapper = TaskWrapper.readNBT(nbt);
                this.taskWrapperMap.put(wrapper.id, wrapper);
            }
        }
        if (compoundNBT.func_74764_b("completedTasks")) {
            compoundNBT.func_74775_l("completedTasks").func_150296_c().forEach(taskId -> {
                Task task = (Task)ModRegistries.TASKS.getValue(new ResourceLocation(taskId));
                if (task != null) {
                    this.completedTasks.add(task);
                }
            });
        }
        if (compoundNBT.func_74764_b("tasks")) {
            compoundNBT.func_74775_l("tasks").func_150296_c().forEach(taskBoardIdStr -> {
                TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(UUID.fromString(taskBoardIdStr), TaskWrapper::new);
                CompoundNBT entityIdNBT = compoundNBT.func_74775_l("tasks").func_74775_l(taskBoardIdStr);
                HashSet tasks = new HashSet();
                entityIdNBT.func_150296_c().forEach(taskId -> {
                    Task task = (Task)ModRegistries.TASKS.getValue(new ResourceLocation(taskId));
                    if (task != null) {
                        tasks.add(task);
                    }
                });
                wrapper.tasks.putAll(tasks.stream().map(t -> new TaskInstance((Task)((Object)((Object)t)), wrapper.id, this.factionPlayer, (long)this.getTaskTimeConfig() * 1200L * 4L)).collect(Collectors.toMap(TaskInstance::getId, t -> t)));
            });
        }
        if (compoundNBT.func_74764_b("lessTasks")) {
            CompoundNBT lessTasksNBT = compoundNBT.func_74775_l("lessTasks");
            lessTasksNBT.func_150296_c().forEach(taskBoardId -> {
                TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(UUID.fromString(taskBoardId), TaskWrapper::new);
                wrapper.lessTasks = lessTasksNBT.func_74762_e(taskBoardId);
            });
        }
        if (compoundNBT.func_74764_b("acceptedTasks")) {
            compoundNBT.func_74775_l("acceptedTasks").func_150296_c().forEach(taskBoardId -> {
                TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(UUID.fromString(taskBoardId), TaskWrapper::new);
                CompoundNBT entityIdNBT = compoundNBT.func_74775_l("acceptedTasks").func_74775_l(taskBoardId);
                entityIdNBT.func_150296_c().forEach(taskId -> {
                    Task task = (Task)ModRegistries.TASKS.getValue(new ResourceLocation(taskId));
                    if (task != null) {
                        wrapper.acceptTask(task, this.player.field_70170_p.func_82737_E() + (long)this.getTaskTimeConfig() * 1200L * 4L);
                    }
                });
            });
        }
        if (compoundNBT.func_74764_b("stats")) {
            CompoundNBT stats = compoundNBT.func_74775_l("stats");
            for (String taskBoardId2 : stats.func_150296_c()) {
                wrapper = this.taskWrapperMap.computeIfAbsent(UUID.fromString(taskBoardId2), TaskWrapper::new);
                CompoundNBT taskBoardNBT = stats.func_74775_l(taskBoardId2);
                for (String taskRegistryName : taskBoardNBT.func_150296_c()) {
                    CompoundNBT taskNBT = taskBoardNBT.func_74775_l(taskRegistryName);
                    HashMap<ResourceLocation, Integer> requirements = new HashMap<ResourceLocation, Integer>();
                    for (String requirementString : taskNBT.func_150296_c()) {
                        requirements.put(new ResourceLocation(requirementString), taskNBT.func_74762_e(requirementString));
                    }
                    Task task = (Task)ModRegistries.TASKS.getValue(new ResourceLocation(taskRegistryName));
                    if (task == null) continue;
                    wrapper.getTaskInstances().stream().filter(ins -> ins.getTask() == task).forEach(ins -> ins.setStats(requirements));
                }
            }
        }
    }

    public void removeRequirements(@Nonnull ITaskInstance taskInstance) {
        taskInstance.getTask().getRequirement().removeRequirement(this.factionPlayer);
    }

    @Override
    public void reset() {
        this.completedTasks.clear();
        this.taskWrapperMap.values().forEach(wrapper -> {
            ((TaskWrapper)wrapper).lessTasks = 0;
            ((TaskWrapper)wrapper).tasks.clear();
        });
    }

    @Override
    public void resetTaskLists() {
        this.taskWrapperMap.values().forEach(rec$ -> ((TaskWrapper)rec$).reset());
        this.updateTaskLists();
    }

    @Override
    public void resetUniqueTask(Task task) {
        if (!task.isUnique()) {
            return;
        }
        this.completedTasks.remove((Object)task);
        TaskWrapper wrapper = this.taskWrapperMap.get(UNIQUE_TASKS);
        if (wrapper != null) {
            wrapper.tasks.values().removeIf(ins -> ins.getTask() == task);
        }
    }

    public void tick() {
        if (this.player.func_130014_f_().func_82737_E() % 24000L == 0L) {
            this.updateTaskLists();
        }
    }

    @Override
    public void updateTaskLists() {
        for (TaskWrapper value : this.taskWrapperMap.values()) {
            if (value.id == UNIQUE_TASKS) continue;
            if (value.getAcceptedTasks().isEmpty()) {
                value.tasks.clear();
                continue;
            }
            value.tasks.values().removeIf(task -> !value.getAcceptedTasks().contains(task));
        }
    }

    @Override
    public boolean wasTaskCompleted(@Nonnull Task task) {
        return this.completedTasks.contains((Object)task);
    }

    public void writeNBT(@Nonnull CompoundNBT compoundNBT) {
        if (!this.completedTasks.isEmpty()) {
            CompoundNBT tasksNBT = new CompoundNBT();
            this.completedTasks.forEach(task -> tasksNBT.func_74757_a(Objects.requireNonNull(task.getRegistryName()).toString(), true));
            compoundNBT.func_218657_a("completedTasks", (INBT)tasksNBT);
        }
        if (!this.taskWrapperMap.isEmpty()) {
            ListNBT infos = new ListNBT();
            this.taskWrapperMap.forEach((a, b) -> infos.add((Object)b.writeNBT(new CompoundNBT())));
            compoundNBT.func_218657_a("taskWrapper", (INBT)infos);
        }
    }

    private boolean checkStat(@Nonnull ITaskInstance taskInstance, @Nonnull TaskRequirement.Requirement<?> requirement) {
        return this.getStat(taskInstance, requirement) >= requirement.getAmount(this.factionPlayer);
    }

    private Set<UUID> getCompletableTasks(@Nonnull Set<ITaskInstance> taskInstances) {
        return taskInstances.stream().filter(this::canCompleteTask).map(ITaskInstance::getId).collect(Collectors.toSet());
    }

    private Map<ResourceLocation, Integer> getCompletedRequirements(@Nonnull ITaskInstance taskInstance) {
        HashMap<ResourceLocation, Integer> completed = new HashMap<ResourceLocation, Integer>();
        for (TaskRequirement.Requirement<?> requirement : taskInstance.getTask().getRequirement().getAll()) {
            completed.put(requirement.getId(), this.getStat(taskInstance, requirement));
        }
        return completed;
    }

    private int getStat(@Nonnull ITaskInstance taskInstance, @Nonnull TaskRequirement.Requirement<?> requirement) {
        Map<ResourceLocation, Integer> stats = taskInstance.getStats();
        if (!taskInstance.isAccepted()) {
            return 0;
        }
        int neededStat = 0;
        int actualStat = 0;
        switch (requirement.getType()) {
            case STATS: {
                actualStat = this.player.func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)((ResourceLocation)requirement.getStat(this.factionPlayer))));
                neededStat = stats.get(requirement.getId()) + requirement.getAmount(this.factionPlayer);
                break;
            }
            case ENTITY: {
                actualStat = this.player.func_147099_x().func_77444_a(Stats.field_199090_h.func_199076_b((Object)((EntityType)requirement.getStat(this.factionPlayer))));
                neededStat = stats.get(requirement.getId()) + requirement.getAmount(this.factionPlayer);
                break;
            }
            case ENTITY_TAG: {
                for (EntityType type : ((ITag.INamedTag)requirement.getStat(this.factionPlayer)).func_230236_b_()) {
                    actualStat += this.player.func_147099_x().func_77444_a(Stats.field_199090_h.func_199076_b((Object)type));
                }
                neededStat = stats.get(requirement.getId()) + requirement.getAmount(this.factionPlayer);
                break;
            }
            case ITEMS: {
                ItemStack stack = ((ItemRequirement)requirement).getItemStack();
                neededStat = stack.func_190916_E();
                actualStat = TaskManager.countItem((IInventory)this.player.field_71071_by, stack);
                break;
            }
            case BOOLEAN: {
                if (!((Boolean)requirement.getStat(this.factionPlayer)).booleanValue()) {
                    return 0;
                }
                return 1;
            }
        }
        return Math.min(requirement.getAmount(this.factionPlayer) - (neededStat - actualStat), requirement.getAmount(this.factionPlayer));
    }

    private Collection<ITaskInstance> getTasks(UUID taskBoardId) {
        TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(taskBoardId, TaskWrapper::new);
        if (!wrapper.tasks.isEmpty()) {
            this.removeLockedTasks(wrapper.getTaskInstances());
        }
        wrapper.taskAmount = wrapper.taskAmount < 0 ? this.player.func_70681_au().nextInt((Integer)VampirismConfig.BALANCE.taskMasterMaxTaskAmount.get()) + 1 - wrapper.lessTasks : wrapper.taskAmount;
        if (wrapper.tasks.size() < wrapper.taskAmount) {
            ArrayList tasks = new ArrayList(ModRegistries.TASKS.getValues());
            Collections.shuffle(tasks);
            wrapper.tasks.putAll(tasks.stream().filter(this::matchesFaction).filter(task -> !task.isUnique()).filter(this::isTaskUnlocked).limit(wrapper.taskAmount - wrapper.tasks.size()).map(task -> new TaskInstance((Task)((Object)task), taskBoardId, this.factionPlayer, (long)this.getTaskTimeConfig() * 1200L)).collect(Collectors.toMap(TaskInstance::getId, t -> t)));
        }
        this.updateStats(wrapper.getTaskInstances());
        return wrapper.getTaskInstances();
    }

    private Collection<ITaskInstance> getUniqueTasks() {
        TaskWrapper wrapper = this.taskWrapperMap.computeIfAbsent(UNIQUE_TASKS, TaskWrapper::new);
        Map uniqueTasks = wrapper.tasks;
        if (!uniqueTasks.isEmpty()) {
            this.removeLockedTasks(uniqueTasks.values());
        }
        Collection tasks = uniqueTasks.values().stream().map(ITaskInstance::getTask).collect(Collectors.toSet());
        uniqueTasks.putAll(ModRegistries.TASKS.getValues().stream().filter(this::matchesFaction).filter(Task::isUnique).filter(task -> !tasks.contains(task)).filter(task -> !this.completedTasks.contains(task)).filter(this::isTaskUnlocked).map(task -> new TaskInstance((Task)((Object)task), UNIQUE_TASKS, this.factionPlayer, 0L)).collect(Collectors.toMap(TaskInstance::getId, a -> a)));
        wrapper.tasks.putAll(uniqueTasks);
        this.updateStats(uniqueTasks.values());
        return uniqueTasks.values();
    }

    private boolean isTimeEnough(ITaskInstance taskInstance, long gameTime) {
        if (!taskInstance.isUnique()) {
            return taskInstance.getTaskTimeStamp() >= gameTime;
        }
        return true;
    }

    private boolean matchesFaction(@Nonnull Task task) {
        return task.getFaction() == this.faction || task.getFaction() == null;
    }

    private void removeLockedTasks(@Nonnull Collection<ITaskInstance> taskInstances) {
        taskInstances.removeIf(task -> {
            if (!this.isTaskUnlocked(task.getTask())) {
                task.aboardTask();
                return true;
            }
            return false;
        });
    }

    private static int countItem(IInventory inventory, ItemStack stack) {
        int i = 0;
        for (int j = 0; j < inventory.func_70302_i_(); ++j) {
            ItemStack itemstack = inventory.func_70301_a(j);
            if (!ItemStack.func_179545_c((ItemStack)itemstack, (ItemStack)stack) || !TaskManager.checkPotionEqual(itemstack, stack) || !TaskManager.checkOilEqual(itemstack, stack)) continue;
            i += itemstack.func_190916_E();
        }
        return i;
    }

    public static boolean checkPotionEqual(ItemStack stack1, ItemStack stack2) {
        return PotionUtils.func_185191_c((ItemStack)stack1) == PotionUtils.func_185191_c((ItemStack)stack2);
    }

    public static boolean checkOilEqual(ItemStack stack1, ItemStack stack2) {
        return OilUtils.getOil(stack1) == OilUtils.getOil(stack2);
    }

    private void updateStats(@Nonnull Collection<ITaskInstance> taskInstances) {
        taskInstances.forEach(this::updateStats);
    }

    private void updateStats(@Nonnull ITaskInstance taskInstance) {
        if (!taskInstance.isAccepted()) {
            return;
        }
        if (!taskInstance.getTask().getRequirement().isHasStatBasedReq()) {
            return;
        }
        Map<ResourceLocation, Integer> reqStats = taskInstance.getStats();
        for (TaskRequirement.Requirement<?> requirement : taskInstance.getTask().getRequirement().getAll()) {
            switch (requirement.getType()) {
                case STATS: {
                    reqStats.putIfAbsent(requirement.getId(), this.player.func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)((ResourceLocation)requirement.getStat(this.factionPlayer)))));
                    break;
                }
                case ENTITY: {
                    reqStats.putIfAbsent(requirement.getId(), this.player.func_147099_x().func_77444_a(Stats.field_199090_h.func_199076_b((Object)((EntityType)requirement.getStat(this.factionPlayer)))));
                    break;
                }
                case ENTITY_TAG: {
                    int amount = 0;
                    for (EntityType type : ((ITag.INamedTag)requirement.getStat(this.factionPlayer)).func_230236_b_()) {
                        amount += this.player.func_147099_x().func_77444_a(Stats.field_199090_h.func_199076_b((Object)type));
                    }
                    reqStats.putIfAbsent(requirement.getId(), amount);
                    break;
                }
            }
        }
    }

    public static class TaskWrapper {
        private final UUID id;
        @Nonnull
        private final Map<UUID, ITaskInstance> tasks;
        private int lessTasks;
        private int taskAmount;
        @Nullable
        private BlockPos lastSeenPos;

        public static TaskWrapper readNBT(@Nonnull CompoundNBT nbt) {
            UUID id = nbt.func_186857_a("id");
            int lessTasks = nbt.func_74762_e("lessTasks");
            int taskAmount = nbt.func_74762_e("taskAmount");
            HashMap<UUID, ITaskInstance> tasks = new HashMap<UUID, ITaskInstance>();
            BlockPos taskBoardInfo = null;
            if (nbt.func_74764_b("pos")) {
                ListNBT pos = nbt.func_150295_c("pos", 6);
                taskBoardInfo = new BlockPos(pos.func_150309_d(0), pos.func_150309_d(1), pos.func_150309_d(2));
            }
            int taskSize = nbt.func_74762_e("tasksSize");
            ListNBT tasksNBT = nbt.func_150295_c("tasks", 10);
            for (int i = 0; i < taskSize; ++i) {
                TaskInstance ins = TaskInstance.readNBT(tasksNBT.func_150305_b(i));
                if (ins == null) continue;
                tasks.put(ins.getId(), ins);
            }
            return new TaskWrapper(id, lessTasks, taskAmount, tasks, taskBoardInfo);
        }

        public static TaskWrapper decode(PacketBuffer buffer) {
            UUID id = buffer.func_179253_g();
            int lessTasks = buffer.func_150792_a();
            int taskAmount = buffer.func_150792_a();
            BlockPos pos = null;
            if (buffer.readBoolean()) {
                pos = buffer.func_179259_c();
            }
            int tasksSize = buffer.func_150792_a();
            HashMap<UUID, ITaskInstance> tasks = new HashMap<UUID, ITaskInstance>();
            for (int i = 0; i < tasksSize; ++i) {
                TaskInstance ins = TaskInstance.decode(buffer);
                tasks.put(ins.getId(), ins);
            }
            return new TaskWrapper(id, lessTasks, taskAmount, tasks, pos);
        }

        public TaskWrapper(UUID id) {
            this.id = id;
            this.lessTasks = 0;
            this.taskAmount = -1;
            this.tasks = new HashMap<UUID, ITaskInstance>();
            this.lastSeenPos = null;
        }

        private TaskWrapper(UUID id, int lessTasks, int taskAmount, @Nonnull Map<UUID, ITaskInstance> tasks, @Nullable BlockPos lastSeenPos) {
            this.id = id;
            this.lessTasks = lessTasks;
            this.taskAmount = taskAmount;
            this.tasks = tasks;
            this.lastSeenPos = lastSeenPos;
        }

        @Deprecated
        public void acceptTask(Task task, long timeStamp) {
            this.tasks.values().stream().filter(ins -> ins.getTask() == task).forEach(ins -> this.acceptTask(ins.getId(), timeStamp));
        }

        public ITaskInstance acceptTask(UUID taskInstance, long timeStamp) {
            ITaskInstance ins = this.tasks.get(taskInstance);
            ins.startTask(timeStamp);
            return ins;
        }

        public void encode(PacketBuffer buffer) {
            buffer.func_179252_a(this.id);
            buffer.func_150787_b(this.lessTasks);
            buffer.func_150787_b(this.taskAmount);
            buffer.writeBoolean(this.lastSeenPos != null);
            if (this.lastSeenPos != null) {
                buffer.func_179255_a(this.lastSeenPos);
            }
            buffer.func_150787_b(this.tasks.size());
            this.tasks.values().forEach(taskInstance -> taskInstance.encode(buffer));
        }

        @Nonnull
        public Set<ITaskInstance> getAcceptedTasks() {
            return this.tasks.values().stream().filter(ITaskInstance::isAccepted).collect(Collectors.toSet());
        }

        public UUID getId() {
            return this.id;
        }

        @Nonnull
        public Optional<BlockPos> getLastSeenPos() {
            return Optional.ofNullable(this.lastSeenPos);
        }

        public ITaskInstance getTaskInstance(UUID taskInstance) {
            return this.tasks.get(taskInstance);
        }

        @Nonnull
        public Collection<ITaskInstance> getTaskInstances() {
            return this.tasks.values();
        }

        public void removeTask(ITaskInstance taskInstance, boolean delete) {
            if (delete) {
                this.tasks.remove(taskInstance.getId());
            }
            taskInstance.aboardTask();
        }

        public void removeTask(UUID taskInstance, boolean delete) {
            this.removeTask(this.tasks.get(taskInstance), delete);
        }

        public CompoundNBT writeNBT(@Nonnull CompoundNBT nbt) {
            nbt.func_186854_a("id", this.id);
            nbt.func_74768_a("lessTasks", this.lessTasks);
            nbt.func_74768_a("taskAmount", this.taskAmount);
            ListNBT tasks = new ListNBT();
            this.tasks.forEach((id, task) -> tasks.add((Object)task.writeNBT(new CompoundNBT())));
            nbt.func_218657_a("tasks", (INBT)tasks);
            nbt.func_74768_a("tasksSize", this.tasks.size());
            BlockPos pos = this.lastSeenPos;
            if (pos != null) {
                nbt.func_218657_a("pos", (INBT)Helper.newDoubleNBTList(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            }
            return nbt;
        }

        private void reset() {
            this.tasks.clear();
            this.lessTasks = 0;
            this.taskAmount = -1;
        }
    }
}

