/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.actions;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.DefaultAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.IVampirismPlayer;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class LordRangeEffectAction<T extends IFactionPlayer>
extends DefaultAction<T> {
    private final Supplier<Effect> effect;
    private final IPlayableFaction faction;

    public LordRangeEffectAction(Supplier<Effect> effect, IPlayableFaction faction) {
        this.effect = effect;
        this.faction = faction;
    }

    @Override
    protected boolean activate(T player, IAction.ActivationContext context) {
        int lordLevel = FactionPlayerHandler.getOpt(player.getRepresentingPlayer()).map(FactionPlayerHandler::getLordLevel).orElse(0);
        List entitiesOfClass = player.getRepresentingPlayer().field_70170_p.func_175647_a(LivingEntity.class, new AxisAlignedBB(player.getRepresentingPlayer().func_233580_cy_()).func_72314_b(10.0, 10.0, 10.0), e -> player.getFaction() == VampirismAPI.factionRegistry().getFaction((Entity)e));
        for (LivingEntity entity : entitiesOfClass) {
            if (entity instanceof PlayerEntity && FactionPlayerHandler.getOpt((PlayerEntity)entity).map(FactionPlayerHandler::getLordLevel).filter(l -> l >= lordLevel).isPresent()) continue;
            entity.func_195064_c(new EffectInstance(this.effect.get(), this.getEffectDuration((IFactionPlayer)player), this.getEffectAmplifier((IFactionPlayer)player)));
        }
        return !entitiesOfClass.isEmpty();
    }

    protected abstract int getEffectDuration(IFactionPlayer var1);

    @Override
    public int getCooldown(IFactionPlayer player) {
        return this.getEffectDuration(player);
    }

    protected int getEffectAmplifier(IFactionPlayer player) {
        return ((IVampirismPlayer)player.getRepresentingPlayer()).getVampAtts().lordLevel - 1;
    }

    @Override
    @Nonnull
    public IPlayableFaction getFaction() {
        return this.faction;
    }
}

