/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.hunter;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.advancements.VampireActionTrigger;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.items.HunterCoatItem;
import de.teamlapen.vampirism.player.IVampirismPlayer;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.actions.ActionHandler;
import de.teamlapen.vampirism.player.hunter.HunterPlayerDefaultImpl;
import de.teamlapen.vampirism.player.hunter.HunterPlayerSpecialAttribute;
import de.teamlapen.vampirism.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.OilUtils;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HunterPlayer
extends VampirismPlayer<IHunterPlayer>
implements IHunterPlayer {
    private static final Logger LOGGER = LogManager.getLogger(HunterPlayer.class);
    @CapabilityInject(value=IHunterPlayer.class)
    public static Capability<IHunterPlayer> CAP = (Capability)UtilLib.getNull();
    private final ActionHandler<IHunterPlayer> actionHandler = new ActionHandler<HunterPlayer>(this);
    private final SkillHandler<IHunterPlayer> skillHandler = new SkillHandler<IHunterPlayer>(this, VReference.HUNTER_FACTION);

    @Deprecated
    public static HunterPlayer get(@Nonnull PlayerEntity player) {
        return (HunterPlayer)player.getCapability(CAP, null).orElseThrow(() -> new IllegalStateException("Cannot get HunterPlayer from player " + player));
    }

    public static LazyOptional<HunterPlayer> getOpt(@Nonnull PlayerEntity player) {
        LazyOptional opt = player.getCapability(CAP, null).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Hunter player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IHunterPlayer.class, (Capability.IStorage)new Storage(), HunterPlayerDefaultImpl::new);
    }

    public static ICapabilityProvider createNewCapability(final PlayerEntity player) {
        return new ICapabilitySerializable<CompoundNBT>(){
            final IHunterPlayer inst;
            final LazyOptional<IHunterPlayer> opt;
            {
                this.inst = new HunterPlayer(player);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundNBT nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (INBT)nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    public HunterPlayer(PlayerEntity player) {
        super(player);
    }

    @Override
    public void breakDisguise() {
        this.actionHandler.deactivateAction((ILastingAction)HunterActions.DISGUISE_HUNTER.get());
    }

    @Override
    public boolean canLeaveFaction() {
        return true;
    }

    @Override
    public IActionHandler<IHunterPlayer> getActionHandler() {
        return this.actionHandler;
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.HUNTER_PLAYER_KEY;
    }

    @Override
    public IFaction getDisguisedAs() {
        return this.player.func_70644_a((Effect)ModEffects.DISGUISE_AS_VAMPIRE.get()) ? VReference.VAMPIRE_FACTION : this.getFaction();
    }

    @Override
    public int getLevel() {
        return ((IVampirismPlayer)this.player).getVampAtts().hunterLevel;
    }

    @Override
    public int getMaxLevel() {
        return 14;
    }

    @Override
    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    @Override
    @Nonnull
    public ISkillHandler<IHunterPlayer> getSkillHandler() {
        return this.skillHandler;
    }

    @Nonnull
    public HunterPlayerSpecialAttribute getSpecialAttributes() {
        return ((IVampirismPlayer)this.player).getVampAtts().getHuntSpecial();
    }

    @Override
    public int getTheEntityID() {
        return this.player.func_145782_y();
    }

    @Override
    public boolean isDisguised() {
        return this.player.func_70644_a((Effect)ModEffects.DISGUISE_AS_VAMPIRE.get());
    }

    @Override
    public void loadData(CompoundNBT compound) {
        super.loadData(compound);
        this.actionHandler.loadFromNbt(compound);
        this.skillHandler.loadFromNbt(compound);
    }

    @Override
    public void onChangedDimension(RegistryKey<World> from, RegistryKey<World> to) {
    }

    @Override
    public void onDeath(DamageSource src) {
        super.onDeath(src);
        this.actionHandler.deactivateAllActions();
        if (src.func_76346_g() instanceof ServerPlayerEntity && Helper.isVampire((PlayerEntity)src.func_76346_g()) && this.getRepresentingPlayer().func_70660_b((Effect)ModEffects.FREEZE.get()) != null) {
            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayerEntity)src.func_76346_g(), VampireActionTrigger.Action.KILL_FROZEN_HUNTER);
        }
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        return false;
    }

    @Override
    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
        }
    }

    @Override
    public void onLevelChanged(int level, int oldLevel) {
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard(this.player, ScoreboardUtil.HUNTER_LEVEL_CRITERIA, level);
            LevelAttributeModifier.applyModifier(this.player, Attributes.field_233823_f_, "Hunter", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.hpStrengthMaxMod.get(), (Double)VampirismConfig.BALANCE.hpStrengthType.get(), AttributeModifier.Operation.MULTIPLY_BASE, false);
            if (level <= 0) {
                this.skillHandler.disableAllSkills();
                this.actionHandler.resetTimers();
                this.skillHandler.resetRefinements();
            }
        } else if (level == 0) {
            this.actionHandler.resetTimers();
            this.skillHandler.resetRefinements();
        }
    }

    @Override
    public void onPlayerLoggedIn() {
    }

    @Override
    public void onPlayerLoggedOut() {
    }

    @Override
    public void onUpdate() {
        this.player.func_130014_f_().func_217381_Z().func_76320_a("vampirism_hunterPlayer");
        super.onUpdate();
        int level = this.getLevel();
        if (level > 0) {
            if (!this.isRemote()) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundNBT syncPacket = new CompoundNBT();
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
            } else {
                if (this.getSpecialAttributes().blessingSoundReference != null && !this.player.func_184587_cr()) {
                    this.getSpecialAttributes().blessingSoundReference.stopPlaying();
                    this.getSpecialAttributes().blessingSoundReference = null;
                }
                this.actionHandler.updateActions();
                VampirismMod.proxy.handleSleepClient(this.player);
            }
        } else if (this.player.field_70170_p.func_82737_E() % 100L == 16L && OilUtils.getEquippedArmorOils(this.player).size() > 0) {
            this.player.func_195064_c(new EffectInstance((Effect)ModEffects.POISON.get(), 120, 0, false, false));
        }
        this.getSpecialAttributes().fullHunterCoat = level > 0 ? HunterCoatItem.isFullyEquipped(this.player) : null;
        this.player.func_130014_f_().func_217381_Z().func_76319_b();
    }

    @Override
    public void onUpdatePlayer(TickEvent.Phase phase) {
    }

    @Override
    public void saveData(CompoundNBT compound) {
        super.saveData(compound);
        this.actionHandler.saveToNbt(compound);
        this.skillHandler.saveToNbt(compound);
    }

    @Override
    protected VampirismPlayer copyFromPlayer(PlayerEntity old) {
        HunterPlayer oldHunter = HunterPlayer.get(old);
        CompoundNBT nbt = new CompoundNBT();
        oldHunter.saveData(nbt);
        this.loadData(nbt);
        return oldHunter;
    }

    @Override
    protected void loadUpdate(CompoundNBT nbt) {
        super.loadUpdate(nbt);
        this.actionHandler.readUpdateFromServer(nbt);
        this.skillHandler.readUpdateFromServer(nbt);
    }

    @Override
    protected void writeFullUpdate(CompoundNBT nbt) {
        super.writeFullUpdate(nbt);
        this.actionHandler.writeUpdateForClient(nbt);
        this.skillHandler.writeUpdateForClient(nbt);
    }

    @Override
    public void updateMinionAttributes(boolean increasedStats) {
        MinionWorldData.getData(this.player.field_70170_p).flatMap(a -> FactionPlayerHandler.getOpt(this.player).map(a::getOrCreateController)).ifPresent(controller -> controller.contactMinions(minion -> {
            minion.getMinionData().ifPresent(b -> ((HunterMinionEntity.HunterMinionData)b).setIncreasedStats(increasedStats));
            HelperLib.sync(minion);
        }));
    }

    private static class Storage
    implements Capability.IStorage<IHunterPlayer> {
        private Storage() {
        }

        public void readNBT(Capability<IHunterPlayer> capability, IHunterPlayer instance, Direction side, INBT nbt) {
            ((HunterPlayer)instance).loadData((CompoundNBT)nbt);
        }

        public INBT writeNBT(Capability<IHunterPlayer> capability, IHunterPlayer instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            ((HunterPlayer)instance).saveData(nbt);
            return nbt;
        }
    }
}

