/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.refinements;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.WeightedRandomItem;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class RefinementSet
extends ForgeRegistryEntry<IRefinementSet>
implements IRefinementSet {
    private final Set<RegistryObject<? extends IRefinement>> refinements;
    private final IRefinementSet.Rarity rarity;
    private final int color;
    private final WeightedRandomItem<IRefinementSet> weightedRandom;
    private ITextComponent name;
    private ITextComponent desc;
    @Nullable
    private IRefinementItem.AccessorySlotType restrictedType;

    public RefinementSet(IRefinementSet.Rarity rarity, int color, Set<RegistryObject<? extends IRefinement>> refinements) {
        this.refinements = refinements;
        this.rarity = rarity;
        this.weightedRandom = new WeightedRandomItem<RefinementSet>(this, this.rarity.weight);
        this.color = color;
    }

    @SafeVarargs
    public RefinementSet(IRefinementSet.Rarity rarity, int color, RegistryObject<? extends IRefinement> ... refinements) {
        this(rarity, color, UtilLib.newSortedSet(refinements));
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    @Nonnull
    public ITextComponent getName() {
        return this.name != null ? this.name : (this.name = new TranslationTextComponent("refinement_set." + this.getRegistryName().func_110624_b() + "." + this.getRegistryName().func_110623_a()));
    }

    @Override
    @Nonnull
    public IRefinementSet.Rarity getRarity() {
        return this.rarity;
    }

    @Override
    @Nonnull
    public Set<IRefinement> getRefinements() {
        return this.refinements.stream().map(RegistryObject::get).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public Set<RegistryObject<? extends IRefinement>> getRefinementRegistryObjects() {
        return this.refinements;
    }

    @Override
    public Optional<IRefinementItem.AccessorySlotType> getSlotType() {
        return Optional.ofNullable(this.restrictedType);
    }

    public WeightedRandomItem<IRefinementSet> getWeightedRandom() {
        return this.weightedRandom;
    }

    public RefinementSet onlyFor(IRefinementItem.AccessorySlotType restrictedType) {
        this.restrictedType = restrictedType;
        return this;
    }

    public static class VampireRefinementSet
    extends RefinementSet {
        public VampireRefinementSet(IRefinementSet.Rarity rarity, int color, Set<RegistryObject<? extends IRefinement>> refinements) {
            super(rarity, color, refinements);
        }

        @SafeVarargs
        public VampireRefinementSet(IRefinementSet.Rarity rarity, int color, RegistryObject<? extends IRefinement> ... refinements) {
            super(rarity, color, refinements);
        }

        @Override
        @Nonnull
        public IFaction<?> getFaction() {
            return VReference.VAMPIRE_FACTION;
        }
    }
}

