/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.player.skills.VampirismSkill;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ActionSkill<T extends IFactionPlayer>
extends VampirismSkill<T> {
    private final IAction action;
    private final ISkillType type;

    public ActionSkill(IAction action) {
        this(action, false);
    }

    public ActionSkill(IAction action, boolean customDescription) {
        this(action, SkillType.LEVEL, false);
    }

    public ActionSkill(IAction action, ISkillType type, boolean customDescription) {
        this.action = action;
        this.type = type;
        if (customDescription) {
            this.setHasDefaultDescription();
        } else {
            this.setDescription(() -> new TranslationTextComponent("text.vampirism.skill.unlocks_action"));
        }
    }

    public ResourceLocation getActionID() {
        return this.action.getRegistryName();
    }

    @Override
    @Nonnull
    public IPlayableFaction getFaction() {
        return this.action.getFaction();
    }

    @Override
    public ITextComponent getName() {
        return this.action.getName();
    }

    @Override
    @Deprecated
    public String getTranslationKey() {
        return this.action.getTranslationKey();
    }

    @Override
    protected void getActions(Collection<IAction> list) {
        list.add(this.action);
    }

    @Override
    public ISkillType getType() {
        return this.type;
    }
}

