/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillManager;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillManager
implements ISkillManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, ISkillType> skillTypes = new HashMap<ResourceLocation, ISkillType>();

    @Deprecated
    @Nonnull
    ISkill getRootSkill(IPlayableFaction faction) {
        return this.getRootSkill(faction, (ISkillType)SkillType.LEVEL);
    }

    @Deprecated
    @Nonnull
    public ISkill getRootSkill(ResourceLocation factionId, ISkillType type) {
        return this.getRootSkill((IPlayableFaction)VampirismAPI.factionRegistry().getFactionByID(factionId), type);
    }

    @Nonnull
    public ISkill getRootSkill(IPlayableFaction faction, ISkillType type) {
        if (!type.isForFaction(faction)) {
            throw new IllegalStateException("The skilltype " + type + " is not applicable for the faction " + faction.getID());
        }
        ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(type.createIdForFaction(faction.getID()));
        if (skill == null) {
            LOGGER.warn("No root skill exists for faction {}", (Object)faction.getID());
            throw new IllegalStateException("You need to register a root skill for your faction " + faction.getID());
        }
        return skill;
    }

    @Override
    public List<ISkill> getSkillsForFaction(IPlayableFaction faction) {
        ArrayList list = Lists.newArrayList((Iterable)ModRegistries.SKILLS.getValues());
        list.removeIf(skill -> !faction.equals(skill.getFaction()));
        return list;
    }

    @Override
    public Collection<ISkillType> getSkillTypes() {
        return this.skillTypes.values();
    }

    public void printSkills(IPlayableFaction faction, CommandSource sender) {
        for (ISkill s : this.getSkillsForFaction(faction)) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("ID: " + ModRegistries.SKILLS.getKey((IForgeRegistryEntry)s) + " Skill: ").func_230529_a_(s.getName()), true);
        }
    }

    @Override
    @Nullable
    public ISkillType getSkillType(@Nonnull ResourceLocation id) {
        return this.skillTypes.get(id);
    }

    @Override
    @Nonnull
    public ISkillType registerSkillType(@Nonnull ISkillType type) {
        if (this.skillTypes.containsKey(type.getRegistryName())) {
            throw new IllegalStateException("A skill type with the id " + type.getRegistryName() + " has already been registered");
        }
        this.skillTypes.put(type.getRegistryName(), type);
        return type;
    }
}

