/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.actions;

import de.teamlapen.vampirism.advancements.VampireActionTrigger;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.UmbrellaItem;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BatVampireAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    public static final float BAT_EYE_HEIGHT = 0.51000005f;
    public static final EntitySize BAT_SIZE = EntitySize.func_220311_c((float)0.8f, (float)0.6f);
    private final UUID armorModifierUUID = UUID.fromString("4392fccb-4bfd-4290-b2e6-5cc91439053c");
    private final UUID armorToughnessModifierUUID = UUID.fromString("6d3df16d-85e4-4b99-b2fc-301818697a6d");
    private final float PLAYER_WIDTH = 0.6f;
    private final float PLAYER_HEIGHT = 1.8f;

    @Override
    public boolean activate(IVampirePlayer vampire) {
        PlayerEntity player = vampire.getRepresentingPlayer();
        this.setModifier(player, true);
        this.updatePlayer((VampirePlayer)vampire, true);
        if (player instanceof ServerPlayerEntity) {
            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayerEntity)player, VampireActionTrigger.Action.BAT);
        }
        return true;
    }

    @Override
    public boolean canBeUsedBy(IVampirePlayer vampire) {
        return !vampire.isGettingSundamage((IWorld)vampire.getRepresentingEntity().field_70170_p) && !((Object)((Object)((UmbrellaItem)ModItems.UMBRELLA.get()))).equals(vampire.getRepresentingEntity().func_184614_ca().func_77973_b()) && vampire.isGettingGarlicDamage((IWorld)vampire.getRepresentingEntity().field_70170_p) == EnumStrength.NONE && !vampire.getActionHandler().isActionActive((ILastingAction)VampireActions.VAMPIRE_RAGE.get()) && !vampire.getRepresentingPlayer().func_70090_H() && ((Boolean)VampirismConfig.SERVER.batModeInEnd.get() != false || vampire.getRepresentingPlayer().func_130014_f_().func_234923_W_() != World.field_234920_i_) && !((List)VampirismConfig.SERVER.batDimensionBlacklist.get()).contains(vampire.getRepresentingPlayer().func_130014_f_().func_234923_W_().func_240901_a_().toString()) && vampire.getRepresentingEntity().func_184187_bx() == null;
    }

    @Override
    public int getCooldown() {
        return (Integer)VampirismConfig.BALANCE.vaBatCooldown.get() * 20 + 1;
    }

    @Override
    public int getDuration(int level) {
        return MathHelper.func_76125_a((int)((Integer)VampirismConfig.BALANCE.vaBatDuration.get()), (int)10, (int)0x6666665) * 20;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaBatEnabled.get();
    }

    @Override
    public void onActivatedClient(IVampirePlayer vampire) {
        if (!((VampirePlayer)vampire).getSpecialAttributes().bat) {
            this.updatePlayer((VampirePlayer)vampire, true);
        }
    }

    @Override
    public void onDeactivated(IVampirePlayer vampire) {
        PlayerEntity player = vampire.getRepresentingPlayer();
        this.setModifier(player, false);
        if (!player.func_233570_aj_()) {
            player.func_195064_c(new EffectInstance(Effects.field_76429_m, 20, 100, false, false));
        }
        this.updatePlayer((VampirePlayer)vampire, false);
    }

    @Override
    public void onReActivated(IVampirePlayer vampire) {
        this.setModifier(vampire.getRepresentingPlayer(), true);
        if (!((VampirePlayer)vampire).getSpecialAttributes().bat) {
            this.updatePlayer((VampirePlayer)vampire, true);
        }
    }

    @Override
    public boolean onUpdate(IVampirePlayer vampire) {
        if (vampire.isGettingSundamage((IWorld)vampire.getRepresentingEntity().field_70170_p) && !vampire.isRemote()) {
            vampire.getRepresentingPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_day"), Util.field_240973_b_);
            return true;
        }
        if (((Object)((Object)((UmbrellaItem)ModItems.UMBRELLA.get()))).equals(vampire.getRepresentingEntity().func_184614_ca().func_77973_b()) && !vampire.isRemote()) {
            vampire.getRepresentingPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_umbrella"), Util.field_240973_b_);
            return true;
        }
        if (vampire.isGettingGarlicDamage((IWorld)vampire.getRepresentingEntity().field_70170_p) != EnumStrength.NONE && !vampire.isRemote()) {
            vampire.getRepresentingEntity().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_garlic"), Util.field_240973_b_);
            return true;
        }
        if (((List)VampirismConfig.SERVER.batDimensionBlacklist.get()).contains(vampire.getRepresentingPlayer().func_130014_f_().func_234923_W_().func_240901_a_().toString()) || !((Boolean)VampirismConfig.SERVER.batModeInEnd.get()).booleanValue() && vampire.getRepresentingPlayer().func_130014_f_().func_234923_W_() == World.field_234920_i_) {
            vampire.getRepresentingPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.cant_fly_dimension"), Util.field_240973_b_);
            return true;
        }
        float exhaustion = ((Double)VampirismConfig.BALANCE.vaBatExhaustion.get()).floatValue();
        if (exhaustion > 0.0f) {
            vampire.addExhaustion(exhaustion);
        }
        return vampire.getRepresentingPlayer().func_70090_H();
    }

    private void setFlightSpeed(PlayerEntity player, float speed) {
        player.field_71075_bZ.field_75096_f = speed;
    }

    private void setModifier(PlayerEntity player, boolean enabled) {
        if (enabled) {
            ModifiableAttributeInstance armorToughnessAttributeInst;
            ModifiableAttributeInstance armorAttributeInst = player.func_110148_a(Attributes.field_233826_i_);
            if (armorAttributeInst.func_111127_a(this.armorModifierUUID) == null) {
                armorAttributeInst.func_233769_c_(new AttributeModifier(this.armorModifierUUID, "Bat Armor Disabled", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if ((armorToughnessAttributeInst = player.func_110148_a(Attributes.field_233827_j_)).func_111127_a(this.armorToughnessModifierUUID) == null) {
                armorToughnessAttributeInst.func_233769_c_(new AttributeModifier(this.armorToughnessModifierUUID, "Bat Armor Disabled", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            player.field_71075_bZ.field_75101_c = true;
            player.field_71075_bZ.field_75100_b = true;
            this.setFlightSpeed(player, ((Double)VampirismConfig.BALANCE.vaBatFlightSpeed.get()).floatValue());
        } else {
            ModifiableAttributeInstance armorToughnessAttributeInst;
            AttributeModifier m2;
            ModifiableAttributeInstance armorAttributeInst = player.func_110148_a(Attributes.field_233826_i_);
            AttributeModifier m = armorAttributeInst.func_111127_a(this.armorModifierUUID);
            if (m != null) {
                armorAttributeInst.func_111124_b(m);
            }
            if ((m2 = (armorToughnessAttributeInst = player.func_110148_a(Attributes.field_233827_j_)).func_111127_a(this.armorToughnessModifierUUID)) != null) {
                armorToughnessAttributeInst.func_111124_b(m2);
            }
            boolean spectator = player.func_175149_v();
            boolean creative = player.func_184812_l_();
            player.field_71075_bZ.field_75101_c = spectator || creative;
            player.field_71075_bZ.field_75100_b = spectator;
            this.setFlightSpeed(player, 0.05f);
        }
        player.func_71016_p();
    }

    private void updatePlayer(VampirePlayer vampire, boolean bat) {
        PlayerEntity player = vampire.getRepresentingPlayer();
        vampire.getSpecialAttributes().bat = bat;
        player.setForcedPose((Pose)(bat ? Pose.STANDING : null));
        player.func_213323_x_();
        if (bat) {
            player.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_() + (double)(1.8f - BatVampireAction.BAT_SIZE.field_220316_b), player.func_226281_cx_());
        }
    }

    @Override
    public boolean showHudDuration(PlayerEntity player) {
        return true;
    }
}

