/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.actions;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModRefinements;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;

public class SunscreenVampireAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    @Override
    public boolean activate(IVampirePlayer vampire) {
        this.addEffectInstance(vampire, new EffectInstance((Effect)ModEffects.SUNSCREEN.get(), this.getDuration(vampire), 3, false, false));
        return true;
    }

    @Override
    public int getCooldown() {
        return (Integer)VampirismConfig.BALANCE.vaSunscreenCooldown.get() * 20;
    }

    @Override
    public int getDuration(int level) {
        return 20 * (Integer)VampirismConfig.BALANCE.vaSunscreenDuration.get();
    }

    @Override
    public int getDuration(IFactionPlayer player) {
        int duration = 20 * (Integer)VampirismConfig.BALANCE.vaSunscreenDuration.get();
        if (player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.SUN_SCREEN.get())) {
            duration = (int)((double)duration * (Double)VampirismConfig.BALANCE.vrSunscreenDurationMod.get());
        }
        return duration;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaSunscreenEnabled.get();
    }

    @Override
    public void onActivatedClient(IVampirePlayer vampire) {
    }

    @Override
    public void onDeactivated(IVampirePlayer vampire) {
        this.removePotionEffect(vampire, (Effect)ModEffects.SUNSCREEN.get());
    }

    @Override
    public void onReActivated(IVampirePlayer vampire) {
    }

    @Override
    public boolean onUpdate(IVampirePlayer vampire) {
        return false;
    }

    @Override
    public boolean showHudCooldown(PlayerEntity player) {
        return true;
    }

    @Override
    public boolean showHudDuration(PlayerEntity player) {
        return true;
    }
}

