/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.sit;

import de.teamlapen.vampirism.sit.SitEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SitUtil {
    private static final Map<ResourceLocation, Map<BlockPos, SitEntity>> OCCUPIED = new HashMap<ResourceLocation, Map<BlockPos, SitEntity>>();

    public static boolean addSitEntity(World world, BlockPos blockPos, SitEntity entity) {
        if (!world.field_72995_K) {
            Map<BlockPos, SitEntity> map;
            ResourceLocation id = SitUtil.getDimensionTypeId(world);
            if (!OCCUPIED.containsKey(id)) {
                OCCUPIED.put(id, new HashMap());
            }
            if ((map = OCCUPIED.get(id)).containsKey(blockPos) && map.get(blockPos) != entity) {
                entity.func_70106_y();
                return false;
            }
            map.put(blockPos, entity);
            return true;
        }
        return false;
    }

    public static boolean removeSitEntity(World world, BlockPos pos) {
        ResourceLocation id;
        if (!world.field_72995_K && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(world)) && OCCUPIED.get(id).containsKey(pos)) {
            OCCUPIED.get(id).remove(pos);
            return true;
        }
        return false;
    }

    public static SitEntity getSitEntity(World world, BlockPos pos) {
        ResourceLocation id;
        if (!world.field_72995_K && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(world)) && OCCUPIED.get(id).containsKey(pos)) {
            return OCCUPIED.get(id).get(pos);
        }
        return null;
    }

    public static boolean isOccupied(World world, BlockPos pos) {
        ResourceLocation id = SitUtil.getDimensionTypeId(world);
        return OCCUPIED.containsKey(id) && OCCUPIED.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(PlayerEntity player) {
        for (ResourceLocation i : OCCUPIED.keySet()) {
            for (SitEntity pair : OCCUPIED.get(i).values()) {
                if (!pair.func_184196_w((Entity)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static ResourceLocation getDimensionTypeId(World world) {
        return world.func_234923_W_().func_240901_a_();
    }
}

