/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IExtendedBrewingRecipeRegistry;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.inventory.container.PotionTableContainer;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class PotionTableTileEntity
extends LockableTileEntity
implements ISidedInventory,
ITickableTileEntity,
INamedContainerProvider {
    private static final int[] SLOTS_FOR_UP = new int[]{0, 1, 2};
    private static final int[] SLOTS_FOR_DOWN = new int[]{3, 4, 5, 1, 2};
    private static final int[] SLOTS_FOR_DOWN_EXTENDED = new int[]{3, 4, 5, 6, 7, 1, 2};
    private static final int[] OUTPUT_SLOTS = new int[]{3, 4, 5, 0};
    private static final int[] OUTPUT_SLOTS_EXTENDED = new int[]{3, 4, 5, 6, 7, 0};
    private final BrewingCapabilities config = new BrewingCapabilities();
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    @Nullable
    private UUID ownerID;
    @Nullable
    private ITextComponent ownerName;
    private NonNullList<ItemStack> brewingItemStacks = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private int brewTime;
    private Item ingredientID;
    private Item extraIngredientID;
    private int fuel;
    protected final IIntArray syncedProperties = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return PotionTableTileEntity.this.brewTime;
                }
                case 1: {
                    return PotionTableTileEntity.this.fuel;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    PotionTableTileEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    PotionTableTileEntity.this.fuel = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public PotionTableTileEntity() {
        super((TileEntityType)ModTiles.POTION_TABLE.get());
    }

    public boolean func_213904_e(PlayerEntity player) {
        if (super.func_213904_e(player)) {
            return HunterPlayer.getOpt(player).map(hp -> {
                if (hp.getLevel() > 0) {
                    if (this.ownerID == null) {
                        this.setOwnerID(player);
                        this.config.deriveFromHunter((IHunterPlayer)hp);
                        return true;
                    }
                    if (this.ownerID.equals(player.func_110124_au())) {
                        this.config.deriveFromHunter((IHunterPlayer)hp);
                        return true;
                    }
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.potion_table.other", new Object[]{this.getOwnerName()}), true);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.potion_table.cannot_use", new Object[]{this.getOwnerName()}), true);
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
        }
        Item item = stack.func_77973_b();
        if (index == 0) {
            return item == Items.field_151065_br;
        }
        return BrewingRecipeRegistry.isValidInput((ItemStack)stack) && this.func_70301_a(index).func_190926_b();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (index == 1 || index == 2) {
            return stack.func_77973_b() == Items.field_151069_bo;
        }
        return true;
    }

    public void func_174888_l() {
        this.brewingItemStacks.clear();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("tile.vampirism.potion_table.display", new Object[]{this.ownerName, new TranslationTextComponent("tile.vampirism.potion_table")});
    }

    @Nonnull
    public ITextComponent getOwnerName() {
        return this.ownerName == null ? new StringTextComponent("Unknown") : this.ownerName;
    }

    public int func_70302_i_() {
        return this.brewingItemStacks.size();
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return side == Direction.DOWN ? (this.config.multiTaskBrewing ? SLOTS_FOR_DOWN_EXTENDED : SLOTS_FOR_DOWN) : (this.config.multiTaskBrewing ? OUTPUT_SLOTS_EXTENDED : OUTPUT_SLOTS);
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.brewingItemStacks.size() ? (ItemStack)this.brewingItemStacks.get(index) : ItemStack.field_190927_a;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.brewingItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean isExtended() {
        return this.config.isMultiTaskBrewing();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.brewingItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.brewingItemStacks);
        this.brewTime = compound.func_74765_d("BrewTime");
        this.fuel = compound.func_74771_c("Fuel");
        this.config.fromByte(compound.func_74771_c("config"));
        this.ownerID = compound.func_186855_b("owner") ? compound.func_186857_a("owner") : null;
        this.ownerName = compound.func_74764_b("owner_name") ? ITextComponent.Serializer.func_240644_b_((String)compound.func_74779_i("owner_name")) : null;
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.brewingItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.brewingItemStacks, (int)index);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("BrewTime", (short)this.brewTime);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.brewingItemStacks);
        compound.func_74774_a("Fuel", (byte)this.fuel);
        compound.func_74774_a("config", this.config.toByte());
        if (this.ownerID != null) {
            compound.func_186854_a("owner", this.ownerID);
            compound.func_74778_a("owner_name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.ownerName));
        }
        return compound;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= 0 && index < this.brewingItemStacks.size()) {
            this.brewingItemStacks.set(index, (Object)stack);
        }
    }

    public void setOwnerID(PlayerEntity player) {
        this.ownerID = player.func_110124_au();
        this.ownerName = player.func_145748_c_();
        this.func_70296_d();
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (!this.func_145830_o()) {
            return false;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void func_73660_a() {
        boolean isBrewing;
        PlayerEntity owner;
        ItemStack itemstack = (ItemStack)this.brewingItemStacks.get(0);
        if (this.fuel <= 0 && itemstack.func_77973_b() == Items.field_151065_br) {
            this.fuel = 20;
            itemstack.func_190918_g(1);
            this.func_70296_d();
        }
        if (this.ownerID != null && this.func_145830_o() && this.field_145850_b.func_82737_E() % 64L == 0L && (owner = this.field_145850_b.func_217371_b(this.ownerID)) != null) {
            HunterPlayer.getOpt(owner).ifPresent(this.config::deriveFromHunter);
        }
        boolean canBrew = this.canBrew();
        boolean bl = isBrewing = this.brewTime > 0;
        if (isBrewing) {
            --this.brewTime;
            if (this.brewTime == 0 && canBrew) {
                this.brewPotions();
                this.func_70296_d();
            } else if (!canBrew || this.ingredientID != ((ItemStack)this.brewingItemStacks.get(2)).func_77973_b() || this.extraIngredientID != ((ItemStack)this.brewingItemStacks.get(1)).func_77973_b()) {
                this.brewTime = 0;
                this.func_70296_d();
            }
        } else if (canBrew && this.fuel > 0) {
            --this.fuel;
            this.brewTime = this.config.isSwiftBrewing() ? 400 : 200;
            this.ingredientID = ((ItemStack)this.brewingItemStacks.get(2)).func_77973_b();
            this.extraIngredientID = ((ItemStack)this.brewingItemStacks.get(1)).func_77973_b();
            this.func_70296_d();
        }
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new PotionTableContainer(id, player, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.func_174877_v()), (IInventory)this, this.config.multiTaskBrewing, this.syncedProperties);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.brewing");
    }

    private void brewPotions() {
        ItemStack itemstack1;
        ItemStack ingredientStack = (ItemStack)this.brewingItemStacks.get(2);
        ItemStack extraIngredient = (ItemStack)this.brewingItemStacks.get(1);
        boolean brewed = VampirismAPI.extendedBrewingRecipeRegistry().brewPotions(this.brewingItemStacks, ingredientStack, extraIngredient, this.config, this.config.multiTaskBrewing ? OUTPUT_SLOTS_EXTENDED : OUTPUT_SLOTS, true);
        if (!brewed) {
            NonNullList copiedBrewingItemStack = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{((ItemStack)this.brewingItemStacks.get(3)).func_77946_l(), ((ItemStack)this.brewingItemStacks.get(4)).func_77946_l(), ((ItemStack)this.brewingItemStacks.get(5)).func_77946_l(), ((ItemStack)this.brewingItemStacks.get(2)).func_77946_l(), ((ItemStack)this.brewingItemStacks.get(0)).func_77946_l()});
            if (ForgeEventFactory.onPotionAttemptBrew((NonNullList)copiedBrewingItemStack)) {
                this.brewingItemStacks.set(3, copiedBrewingItemStack.get(0));
                this.brewingItemStacks.set(4, copiedBrewingItemStack.get(1));
                this.brewingItemStacks.set(5, copiedBrewingItemStack.get(2));
                this.brewingItemStacks.set(2, copiedBrewingItemStack.get(3));
                this.brewingItemStacks.set(0, copiedBrewingItemStack.get(4));
                return;
            }
            VampirismAPI.extendedBrewingRecipeRegistry().brewPotions(this.brewingItemStacks, ingredientStack, extraIngredient, this.config, this.config.multiTaskBrewing ? OUTPUT_SLOTS_EXTENDED : OUTPUT_SLOTS, false);
            copiedBrewingItemStack = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{((ItemStack)this.brewingItemStacks.get(3)).func_77946_l(), ((ItemStack)this.brewingItemStacks.get(4)).func_77946_l(), ((ItemStack)this.brewingItemStacks.get(5)).func_77946_l(), ((ItemStack)this.brewingItemStacks.get(2)).func_77946_l(), ((ItemStack)this.brewingItemStacks.get(0)).func_77946_l()});
            ForgeEventFactory.onPotionBrewed(this.brewingItemStacks);
            this.brewingItemStacks.set(3, copiedBrewingItemStack.get(0));
            this.brewingItemStacks.set(4, copiedBrewingItemStack.get(1));
            this.brewingItemStacks.set(5, copiedBrewingItemStack.get(2));
            this.brewingItemStacks.set(2, copiedBrewingItemStack.get(3));
            this.brewingItemStacks.set(0, copiedBrewingItemStack.get(4));
        }
        BlockPos blockpos = this.func_174877_v();
        if (ingredientStack.hasContainerItem()) {
            itemstack1 = ingredientStack.getContainerItem();
            if (ingredientStack.func_190926_b()) {
                ingredientStack = itemstack1;
            } else if (!this.field_145850_b.field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (ItemStack)itemstack1);
            }
        }
        if (extraIngredient.hasContainerItem()) {
            itemstack1 = extraIngredient.getContainerItem();
            if (extraIngredient.func_190926_b()) {
                extraIngredient = itemstack1;
            } else if (!this.field_145850_b.field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (ItemStack)itemstack1);
            }
        }
        this.brewingItemStacks.set(2, (Object)ingredientStack);
        this.brewingItemStacks.set(1, (Object)extraIngredient);
        this.field_145850_b.func_217379_c(1035, blockpos, 0);
    }

    private boolean canBrew() {
        ItemStack extraStack = (ItemStack)this.brewingItemStacks.get(1);
        ItemStack ingredientStack = (ItemStack)this.brewingItemStacks.get(2);
        if (!ingredientStack.func_190926_b()) {
            return VampirismAPI.extendedBrewingRecipeRegistry().canBrew(this.brewingItemStacks, ingredientStack, extraStack, this.config, this.config.multiTaskBrewing ? OUTPUT_SLOTS_EXTENDED : OUTPUT_SLOTS);
        }
        return false;
    }

    protected static class BrewingCapabilities
    implements IExtendedBrewingRecipeRegistry.IExtendedBrewingCapabilities {
        boolean durableBrewing;
        boolean concentratedBrewing;
        boolean swiftBrewing;
        boolean masterBrewing;
        boolean efficientBrewing;
        boolean multiTaskBrewing;

        protected BrewingCapabilities() {
        }

        public void deriveFromHunter(IHunterPlayer player) {
            ISkillHandler manager = player.getSkillHandler();
            this.durableBrewing = manager.isSkillEnabled((ISkill)HunterSkills.DURABLE_BREWING.get()) || manager.isSkillEnabled((ISkill)HunterSkills.CONCENTRATED_DURABLE_BREWING.get());
            this.concentratedBrewing = manager.isSkillEnabled((ISkill)HunterSkills.CONCENTRATED_BREWING.get()) || manager.isSkillEnabled((ISkill)HunterSkills.CONCENTRATED_DURABLE_BREWING.get());
            this.swiftBrewing = manager.isSkillEnabled((ISkill)HunterSkills.SWIFT_BREWING.get());
            this.masterBrewing = manager.isSkillEnabled((ISkill)HunterSkills.MASTER_BREWER.get());
            this.efficientBrewing = manager.isSkillEnabled((ISkill)HunterSkills.EFFICIENT_BREWING.get());
            this.multiTaskBrewing = manager.isSkillEnabled((ISkill)HunterSkills.MULTITASK_BREWING.get());
        }

        public void fromByte(byte d) {
            this.durableBrewing = (d & 1) > 0;
            this.concentratedBrewing = (d & 2) > 0;
            this.swiftBrewing = (d & 4) > 0;
            this.masterBrewing = (d & 8) > 0;
            this.efficientBrewing = (d & 0x10) > 0;
            this.multiTaskBrewing = (d & 0x20) > 0;
        }

        @Override
        public boolean isConcentratedBrewing() {
            return this.concentratedBrewing;
        }

        @Override
        public boolean isDurableBrewing() {
            return this.durableBrewing;
        }

        @Override
        public boolean isEfficientBrewing() {
            return this.efficientBrewing;
        }

        @Override
        public boolean isMasterBrewing() {
            return this.masterBrewing;
        }

        @Override
        public boolean isMultiTaskBrewing() {
            return this.multiTaskBrewing;
        }

        @Override
        public boolean isSwiftBrewing() {
            return this.swiftBrewing;
        }

        public void reset() {
            this.multiTaskBrewing = false;
            this.efficientBrewing = false;
            this.masterBrewing = false;
            this.swiftBrewing = false;
            this.concentratedBrewing = false;
            this.durableBrewing = false;
        }

        public byte toByte() {
            byte d = 0;
            if (this.durableBrewing) {
                d = (byte)(d | 1);
            }
            if (this.concentratedBrewing) {
                d = (byte)(d | 2);
            }
            if (this.swiftBrewing) {
                d = (byte)(d | 4);
            }
            if (this.masterBrewing) {
                d = (byte)(d | 8);
            }
            if (this.efficientBrewing) {
                d = (byte)(d | 0x10);
            }
            if (this.multiTaskBrewing) {
                d = (byte)(d | 0x20);
            }
            return d;
        }
    }
}

