/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModEnchantments;
import de.teamlapen.vampirism.items.enchantment.EnchantmentVampireSlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;

public class MixinHooks {
    private static final List<String> onlyOneStructure = Lists.newArrayList();
    public static boolean enforcingGlowing_bloodVision = false;

    public static void addSingleInstanceStructure(List<ResourceLocation> structures) {
        onlyOneStructure.addAll(structures.stream().map(MixinHooks::singleJigsawString).collect(Collectors.toList()));
        MixinHooks.addSingleInstanceStructureToRepurposedStructures(structures);
    }

    private static void addSingleInstanceStructureToRepurposedStructures(List<ResourceLocation> structures) {
        try {
            if (ModList.get().isLoaded("repurposed_structures")) {
                Map repurposed_structures_limit = (Map)Class.forName("com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePiecesBehavior").getField("PIECES_COUNT").get(null);
                repurposed_structures_limit.putAll(structures.stream().collect(HashMap::new, (map, loc) -> map.put(loc, 1), HashMap::putAll));
            }
        }
        catch (Exception error) {
            LogManager.getLogger().error("Could not add village building to RepurposedStructures limit list", (Throwable)error);
        }
    }

    public static boolean checkStructures(List<? super AbstractVillagePiece> pieces, JigsawPiece jigsawPiece) {
        if (!onlyOneStructure.contains(jigsawPiece.toString())) {
            return false;
        }
        return pieces.stream().anyMatch(structurePiece -> onlyOneStructure.stream().anyMatch(string -> ((AbstractVillagePiece)structurePiece).func_214826_b().toString().equals(string)));
    }

    public static float calculateVampireSlayerEnchantments(Entity entity, ItemStack item) {
        if (!(entity instanceof PlayerEntity)) {
            return 0.0f;
        }
        if (!Helper.isVampire(entity)) {
            return 0.0f;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)item);
        if (!enchantments.containsKey(ModEnchantments.VAMPIRESLAYER.get())) {
            return 0.0f;
        }
        return ((EnchantmentVampireSlayer)ModEnchantments.VAMPIRESLAYER.get()).func_152376_a((Integer)enchantments.get(ModEnchantments.VAMPIRESLAYER.get()), VReference.VAMPIRE_CREATURE_ATTRIBUTE);
    }

    private static String singleJigsawString(ResourceLocation resourceLocation) {
        return "Single[Left[" + resourceLocation.toString() + "]]";
    }
}

