/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class NBTIngredient
extends Ingredient {
    private final ItemStack[] stacks;

    public NBTIngredient(ItemStack ... stack) {
        super(Stream.of(stack).map(Ingredient.SingleItemList::new));
        this.stacks = stack;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        for (ItemStack stack : this.stacks) {
            if (stack.func_77973_b() != input.func_77973_b() || stack.func_77952_i() != input.func_77952_i() || !stack.areShareTagsEqual(input)) continue;
            return true;
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        if (this.stacks.length == 1) {
            json.addProperty("item", this.stacks[0].func_77973_b().getRegistryName().toString());
            json.addProperty("count", (Number)this.stacks[0].func_190916_E());
            if (this.stacks[0].func_77942_o()) {
                json.add("nbt", (JsonElement)new JsonParser().parse(this.stacks[0].func_77978_p().toString()).getAsJsonObject());
            }
        } else {
            JsonArray array = new JsonArray();
            for (ItemStack stack : this.stacks) {
                JsonObject obj = new JsonObject();
                obj.addProperty("item", stack.func_77973_b().getRegistryName().toString());
                obj.addProperty("count", (Number)stack.func_190916_E());
                if (stack.func_77942_o()) {
                    obj.add("nbt", (JsonElement)new JsonParser().parse(stack.func_77978_p().toString()).getAsJsonObject());
                }
                array.add((JsonElement)obj);
            }
            json.add("items", (JsonElement)array);
        }
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<NBTIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Nonnull
        public NBTIngredient parse(PacketBuffer buffer) {
            int length = buffer.func_150792_a();
            ItemStack[] stacks = new ItemStack[length];
            for (int i = 0; i < stacks.length; ++i) {
                stacks[i] = buffer.func_150791_c();
            }
            return new NBTIngredient(stacks);
        }

        @Nonnull
        public NBTIngredient parse(@Nonnull JsonObject json) {
            if (json.has("items")) {
                JsonArray items = json.get("items").getAsJsonArray();
                ItemStack[] stacks = new ItemStack[items.size()];
                for (int i = 0; i < stacks.length; ++i) {
                    stacks[i] = CraftingHelper.getItemStack((JsonObject)items.get(i).getAsJsonObject(), (boolean)true);
                }
                return new NBTIngredient(stacks);
            }
            return new NBTIngredient(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
        }

        public void write(PacketBuffer buffer, NBTIngredient ingredient) {
            buffer.func_150787_b(ingredient.stacks.length);
            for (ItemStack stack : ingredient.stacks) {
                buffer.func_150788_a(stack);
            }
        }
    }
}

