/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.api.items.oil.IArmorOil;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModOils;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.items.OilBottle;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class OilUtils {
    @Nonnull
    public static IOil getOil(@Nonnull ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        IOil oil = null;
        if (tag != null && tag.func_74764_b("oil")) {
            String oilStr = stack.func_77978_p().func_74779_i("oil");
            oil = (IOil)ModRegistries.OILS.getValue(new ResourceLocation(oilStr));
        }
        return oil != null ? oil : (IOil)ModOils.EMPTY.get();
    }

    public static ItemStack setOil(@Nonnull ItemStack stack, @Nonnull IOil oil) {
        stack.func_196082_o().func_74778_a("oil", oil.getRegistryName().toString());
        return stack;
    }

    public static ItemStack createOilItem(IOil oil) {
        return ((OilBottle)ModItems.OIL_BOTTLE.get()).withOil(oil);
    }

    public static Collection<IArmorOil> getEquippedArmorOils(PlayerEntity player) {
        return StreamSupport.stream(player.func_184193_aE().spliterator(), false).map(OilUtils::getAppliedOil).filter(o -> o.isPresent() && o.get() instanceof IArmorOil).map(iApplicableOil -> (IArmorOil)iApplicableOil.get()).collect(Collectors.toList());
    }

    public static Optional<IApplicableOil> getAppliedOil(@Nonnull ItemStack stack) {
        return OilUtils.getAppliedOilStatus(stack).map(Pair::getLeft);
    }

    public static boolean reduceAppliedOilDuration(ItemStack stack) {
        return OilUtils.getAppliedOil(stack).map(oil -> OilUtils.reduceAppliedOilDuration(stack, oil, oil.getDurationReduction())).orElse(true);
    }

    public static boolean reduceAppliedOilDuration(@Nonnull ItemStack stack, IApplicableOil oil, int durationReduction) {
        CompoundNBT compound;
        if (stack.func_77942_o() && (compound = stack.func_196082_o().func_74775_l("applied_oil")).func_74779_i("oil").equals(oil.getRegistryName().toString())) {
            int duration = compound.func_74762_e("duration") - durationReduction;
            if (duration <= 0) {
                OilUtils.removeAppliedOil(stack);
                return true;
            }
            compound.func_74768_a("duration", duration);
            return false;
        }
        return true;
    }

    public static boolean hasAppliedOil(@Nonnull ItemStack stack) {
        return stack.func_77942_o() && stack.func_196082_o().func_74775_l("applied_oil").func_74764_b("oil");
    }

    public static Optional<Pair<IApplicableOil, Integer>> getAppliedOilStatus(@Nonnull ItemStack stack) {
        if (!stack.func_77942_o()) {
            return Optional.empty();
        }
        CompoundNBT compound = stack.func_196082_o().func_74775_l("applied_oil");
        if (compound.func_74764_b("oil")) {
            IOil oil = (IOil)ModRegistries.OILS.getValue(new ResourceLocation(compound.func_74779_i("oil")));
            int duration = compound.func_74762_e("duration");
            if (oil instanceof IApplicableOil && duration > 0) {
                return Optional.of(Pair.of((Object)((IApplicableOil)oil), (Object)duration));
            }
            OilUtils.removeAppliedOil(stack);
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static ItemStack removeAppliedOil(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_196082_o().func_82580_o("applied_oil");
        }
        return stack;
    }

    public static ItemStack setAppliedOil(@Nonnull ItemStack stack, IApplicableOil oil) {
        return OilUtils.setAppliedOil(stack, oil, oil.getMaxDuration(stack));
    }

    public static ItemStack setAppliedOil(@Nonnull ItemStack stack, IApplicableOil oil, int duration) {
        if (duration <= 0) {
            return OilUtils.removeAppliedOil(stack);
        }
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("oil", oil.getRegistryName().toString());
        compound.func_74768_a("duration", duration);
        stack.func_196082_o().func_218657_a("applied_oil", (INBT)compound);
        return stack;
    }
}

