/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampireBookItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampireBookManager {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static VampireBookManager instance;
    private final Map<String, BookContext> idToBook = new HashMap<String, BookContext>();
    private final List<BookContext> nonUnique = new ArrayList<BookContext>();
    private final BookContext DUMMY = new BookContext(new BookInfo("Unknown", "Unknown", "Failed to load"), "error", false);
    private final BookContext OLD = new BookContext(new BookInfo("Unknown", "Unknown", "\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630\u2630"), "old", false);
    public static final String OLD_ID = "old";

    public static VampireBookManager getInstance() {
        if (instance == null) {
            instance = new VampireBookManager();
        }
        return instance;
    }

    private VampireBookManager() {
    }

    public BookInfo getBookById(String id) {
        return this.idToBook.getOrDefault((Object)id, (BookContext)this.DUMMY).book;
    }

    public BookContext getBookContextById(String id) {
        return this.idToBook.getOrDefault(id, this.DUMMY);
    }

    public BookContext getRandomBook(Random rng) {
        return this.nonUnique.size() > 0 ? this.nonUnique.get(rng.nextInt(this.nonUnique.size())) : this.DUMMY;
    }

    public ItemStack getRandomBookItem(Random rng) {
        ItemStack book = new ItemStack((IItemProvider)ModItems.VAMPIRE_BOOK.get(), 1);
        book.func_77982_d(VampireBookItem.createTagFromContext(this.getRandomBook(rng)));
        return book;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        InputStream inputStream = null;
        try {
            inputStream = VampirismMod.class.getResourceAsStream("/vampireBooks.json");
            if (inputStream == null) {
                throw new IOException("Could not find 'vampireBooks.json' in resources");
            }
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            BookContext[] books = (BookContext[])GSON.fromJson((Reader)reader, BookContext[].class);
            this.idToBook.clear();
            this.idToBook.put(OLD_ID, this.OLD);
            for (BookContext b : books) {
                this.idToBook.put(b.id, b);
                if (b.unique) continue;
                this.nonUnique.add(b);
            }
        }
        catch (JsonParseException e) {
            LOGGER.warn("----------------------------------------");
            LOGGER.error("Failed to load vampire books from JSON", (Throwable)e);
            LOGGER.warn("----------------------------------------");
            if (VampirismMod.inDev) {
                throw e;
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read vampire books from resources", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close InputStream", (Throwable)e);
                }
            }
        }
    }

    public static class BookInfo {
        private final String title;
        private final String author;
        private final String[] content;

        public BookInfo(String title, String author, String ... content) {
            this.title = title;
            this.author = author;
            this.content = content;
        }

        public String getAuthor() {
            return this.author;
        }

        public String[] getContent() {
            return this.content;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class BookContext {
        public final BookInfo book;
        public final String id;
        public final boolean unique;

        public BookContext(BookInfo book, String id, boolean unique) {
            this.book = book;
            this.id = id;
            this.unique = unique;
        }
    }
}

